/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

public final class Assertions {
    private Assertions() {
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given boolean value does not evaluate to true!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isFalse(boolean expression, String message) {
        if (expression) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given boolean value does not evaluate to false!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isEqual(int expected, int value, String message) {
        if (value != expected) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given values are not equal!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isBiggerThan(int value, int barrier, String message) {
        if (value <= barrier) {
            if (message == null || message.trim().isEmpty()) {
                message = "The following equation does not hold: [" + value + " > " + barrier + "]!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isBiggerThan(long value, int barrier, String message) {
        if (value <= (long)barrier) {
            if (message == null || message.trim().isEmpty()) {
                message = "The following equation does not hold: [" + value + " > " + barrier + "]!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isDefined(Object object, String message) {
        if (object == null) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given object reference is null!";
            }
            throw new IllegalArgumentException(message);
        }
        if (object instanceof String && ((String)object).trim().isEmpty()) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given string reference points to an empty string!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isNull(Object object, String message) {
        if (object != null) {
            if (message == null || message.trim().isEmpty()) {
                message = "Given object reference is not null!";
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }
}

