/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.api;

public enum EventType {
    APPLICATION_STARTED("application.started", new String[0]),
    APPLICATION_SESSION_STARTED("application.session.started", new String[]{"user_home", "user_name", "profile_location", "work_dir", "rce_version", "os_name", "jvm_version"}),
    APPLICATION_SHUTDOWN_REQUESTED("application.shutdown.requested", new String[]{"method", "is_restart"}),
    APPLICATION_TERMINATING("application.terminating", new String[0]),
    SERVERPORT_OPENED("serverport.opened", new String[]{"type", "port", "bind_ip"}),
    SERVERPORT_CLOSED("serverport.closed", new String[]{"type", "port", "bind_ip"}),
    CONNECTION_INCOMING_ACCEPTED("connection.incoming.accepted", new String[]{"type", "connection_id", "remote_node_id", "login_name", "auth_method", "auth_failure_count", "remote_ip", "remote_port", "server_port"}),
    CONNECTION_INCOMING_AUTH_FAILED("connection.incoming.auth.failed", new String[]{"type", "connection_id", "login_name", "auth_method", "auth_failure_reason", "auth_failure_count", "remote_ip", "remote_port", "server_port"}),
    CONNECTION_INCOMING_REFUSED("connection.incoming.refused", new String[]{"type", "connection_id", "close_reason", "last_login_name", "last_auth_failure_reason", "last_auth_method", "auth_failure_count", "remote_ip", "remote_port", "server_port", "duration"}),
    CONNECTION_INCOMING_CLOSED("connection.incoming.closed", new String[]{"type", "connection_id", "close_reason", "remote_ip", "remote_port", "server_port", "duration"}),
    UPLINK_INCOMING_ACCEPTED("uplink.incoming.accepted", new String[]{"session_id", "connection_id", "client_version", "protocol_version", "login_name", "original_login_name", "client_id", "original_client_id", "namespace"}),
    UPLINK_INCOMING_REFUSED("uplink.incoming.refused", new String[]{"session_id", "connection_id", "client_version", "protocol_version", "login_name", "client_id", "reason"}),
    UPLINK_INCOMING_CLOSED("uplink.incoming.closed", new String[]{"session_id", "connection_id", "final_state"}),
    NETWORK_NODE_NAMED("network.node.named", new String[]{"instance_id", "session_id", "logical_sub_node_id", "name", "is_local_node"}),
    WORKFLOW_RUN_INITIATED("workflow.run.initiated", new String[]{"workflow_run_id", "workflow_controller_node", "workflow_controller_is_local_node", "local_workflow_file", "workflow_metadata", "success"}),
    WORKFLOW_RUN_REQUESTED("workflow.run.requested", new String[]{"workflow_run_id", "start_ts", "initiator_node", "initiator_is_local_node", "workflow_metadata", "success"}),
    WORKFLOW_RUN_EXECUTED("workflow.run.executed", new String[]{"workflow_run_id", "end_ts", "duration", "final_state"}),
    WORKFLOW_RUN_FINISHED("workflow.run.finished", new String[]{"workflow_run_id", "final_state"}),
    WORKFLOW_COMPONENT_RUN_INITIATED("workflow.component.run.initiated", new String[]{"workflow_run_id", "component_run_id", "execution_controller_node", "execution_controller_is_local_node"}),
    WORKFLOW_COMPONENT_RUN_REQUESTED("workflow.component.run.requested", new String[]{"workflow_run_id", "component_run_id", "workflow_controller_node", "workflow_controller_is_local_node", "start_ts"}),
    WORKFLOW_COMPONENT_RUN_EXECUTED("workflow.component.run.executed", new String[]{"workflow_run_id", "component_run_id", "end_ts", "duration", "final_state"}),
    WORKFLOW_COMPONENT_RUN_FINISHED("workflow.component.run.finished", new String[]{"workflow_run_id", "component_run_id", "end_ts", "duration", "final_state"}),
    ACCOUNTS_INITIALIZED("accounts.initialized", new String[]{"type", "number_of_accounts", "origin"}),
    ACCOUNTS_UPDATED("accounts.updated", new String[]{"type", "number_of_accounts", "origin"}),
    SYSMON_INITIALIZED("sysmon.initialized", new String[]{"jvm_pid", "jvm_processor_count", "jvm_heap_limit", "system_total_ram", "system_logical_cpus"}),
    CUSTOM("custom", new String[]{"type"});

    private final String id;
    private String[] attributeKeys;

    private EventType(String typeId, String[] attributeKeys) {
        this.id = typeId;
        this.attributeKeys = attributeKeys;
    }

    public String getId() {
        return this.id;
    }

    public String[] getAttributeKeys() {
        return this.attributeKeys;
    }

    public static class Attributes {
        public static final String USER_HOME = "user_home";
        public static final String USER_NAME = "user_name";
        public static final String PROFILE_LOCATION = "profile_location";
        public static final String WORK_DIR = "work_dir";
        public static final String RCE_VERSION = "rce_version";
        public static final String OS_NAME = "os_name";
        public static final String JVM_VERSION = "jvm_version";
        public static final String METHOD = "method";
        public static final String IS_RESTART = "is_restart";
        public static final String TYPE = "type";
        public static final String PORT = "port";
        public static final String BIND_IP = "bind_ip";
        public static final String CONNECTION_ID = "connection_id";
        public static final String REMOTE_NODE_ID = "remote_node_id";
        public static final String LOGIN_NAME = "login_name";
        public static final String AUTH_METHOD = "auth_method";
        public static final String AUTH_FAILURE_COUNT = "auth_failure_count";
        public static final String REMOTE_IP = "remote_ip";
        public static final String REMOTE_PORT = "remote_port";
        public static final String SERVER_PORT = "server_port";
        public static final String AUTH_FAILURE_REASON = "auth_failure_reason";
        public static final String CLOSE_REASON = "close_reason";
        public static final String LAST_LOGIN_NAME = "last_login_name";
        public static final String LAST_AUTH_FAILURE_REASON = "last_auth_failure_reason";
        public static final String LAST_AUTH_METHOD = "last_auth_method";
        public static final String DURATION = "duration";
        public static final String SESSION_ID = "session_id";
        public static final String CLIENT_VERSION = "client_version";
        public static final String PROTOCOL_VERSION = "protocol_version";
        public static final String ORIGINAL_LOGIN_NAME = "original_login_name";
        public static final String CLIENT_ID = "client_id";
        public static final String ORIGINAL_CLIENT_ID = "original_client_id";
        public static final String NAMESPACE = "namespace";
        public static final String REASON = "reason";
        public static final String FINAL_STATE = "final_state";
        public static final String INSTANCE_ID = "instance_id";
        public static final String LOGICAL_SUB_NODE_ID = "logical_sub_node_id";
        public static final String NAME = "name";
        public static final String IS_LOCAL_NODE = "is_local_node";
        public static final String WORKFLOW_RUN_ID = "workflow_run_id";
        public static final String WORKFLOW_CONTROLLER_NODE = "workflow_controller_node";
        public static final String WORKFLOW_CONTROLLER_IS_LOCAL_NODE = "workflow_controller_is_local_node";
        public static final String LOCAL_WORKFLOW_FILE = "local_workflow_file";
        public static final String WORKFLOW_METADATA = "workflow_metadata";
        public static final String SUCCESS = "success";
        public static final String START_TS = "start_ts";
        public static final String INITIATOR_NODE = "initiator_node";
        public static final String INITIATOR_IS_LOCAL_NODE = "initiator_is_local_node";
        public static final String END_TS = "end_ts";
        public static final String COMPONENT_RUN_ID = "component_run_id";
        public static final String EXECUTION_CONTROLLER_NODE = "execution_controller_node";
        public static final String EXECUTION_CONTROLLER_IS_LOCAL_NODE = "execution_controller_is_local_node";
        public static final String NUMBER_OF_ACCOUNTS = "number_of_accounts";
        public static final String ORIGIN = "origin";
        public static final String JVM_PID = "jvm_pid";
        public static final String JVM_PROCESSOR_COUNT = "jvm_processor_count";
        public static final String JVM_HEAP_LIMIT = "jvm_heap_limit";
        public static final String SYSTEM_TOTAL_RAM = "system_total_ram";
        public static final String SYSTEM_LOGICAL_CPUS = "system_logical_cpus";
    }
}

