/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.gui.authorization.AuthorizationConstants;
import de.rcenvironment.core.gui.authorization.AuthorizationGroupViewerComparator;
import de.rcenvironment.core.gui.authorization.AuthorizationLabelProvider;
import de.rcenvironment.core.gui.authorization.PublishingType;
import de.rcenvironment.core.gui.authorization.ToolbarFilterWidget;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class AssignGroupsDialog
extends TitleAreaDialog {
    private static final int MINUS_ONE = -1;
    private static final int LEFT_BUTTON = 1;
    private Map<AuthorizationAccessGroup, Boolean> groupToStateMapping;
    private AuthorizationPermissionSet permissionSet;
    private Button publicButton;
    private Button localButton;
    private Button customButton;
    private PublishingType type;
    private String componentName;
    private CheckboxTableViewer groupTableViewer;
    private ListSortAction sortActionAscending;
    private ListSortAction sortActionDescending;
    private AuthorizationGroupViewerComparator comparator;

    protected AssignGroupsDialog(Shell parentShell, Map<AuthorizationAccessGroup, Boolean> groupToStateMapping, AuthorizationPermissionSet permissionSet, String componentName) {
        super(parentShell);
        this.groupToStateMapping = groupToStateMapping;
        this.permissionSet = permissionSet;
        this.componentName = componentName;
    }

    public void create() {
        super.create();
        this.setTitle("Assign Groups");
        this.setMessage(StringUtils.format((String)"Assign groups to component '%s':", (Object[])new Object[]{this.componentName}), 1);
    }

    protected void okPressed() {
        this.groupToStateMapping.clear();
        List<Object> checkedElements = Arrays.asList(this.groupTableViewer.getCheckedElements());
        TableItem[] tableItemArray = this.groupTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            AuthorizationAccessGroup group = (AuthorizationAccessGroup)tableItem.getData();
            this.groupToStateMapping.put(group, checkedElements.contains(group));
            ++n2;
        }
        if (this.publicButton.getSelection()) {
            this.type = PublishingType.PUBLIC;
        } else if (this.localButton.getSelection()) {
            this.type = PublishingType.LOCAL;
        } else if (this.customButton.getSelection()) {
            this.type = PublishingType.CUSTOM;
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayout((Layout)new GridLayout(2, true));
        GridData contentData = new GridData(1808);
        contentData.heightHint = 400;
        content.setLayoutData((Object)contentData);
        Group groupsGroup = new Group(content, 0);
        GridLayout groupsGroupGridLayout = new GridLayout(3, false);
        groupsGroup.setLayout((Layout)groupsGroupGridLayout);
        GridData groupsGroupGridData = new GridData();
        groupsGroupGridData.grabExcessHorizontalSpace = true;
        groupsGroupGridData.grabExcessVerticalSpace = false;
        groupsGroup.setLayoutData((Object)groupsGroupGridData);
        groupsGroup.setText("Group Assignment Type");
        this.localButton = new Button((Composite)groupsGroup, 16);
        this.localButton.setText("Local");
        this.customButton = new Button((Composite)groupsGroup, 16);
        this.customButton.setText("Custom");
        this.publicButton = new Button((Composite)groupsGroup, 16);
        this.publicButton.setText("Public Access");
        final ToolBar toolbar = new ToolBar(content, 8519744);
        GridData toolbarGridData = new GridData(136);
        toolbar.setLayoutData((Object)toolbarGridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(content, 512);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        GridData scrollGridData = new GridData(1808);
        scrollGridData.horizontalSpan = 2;
        scrolledComposite.setLayoutData((Object)scrollGridData);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(250, 200);
        this.groupTableViewer = CheckboxTableViewer.newCheckList((Composite)scrolledComposite, (int)592384);
        this.groupTableViewer.getTable().setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.groupTableViewer.getTable().setLayoutData((Object)new GridData(16384, 128, true, true));
        this.groupTableViewer.setContentProvider((IContentProvider)new GroupsTableContentProvider());
        this.groupTableViewer.setCheckStateProvider((ICheckStateProvider)new GroupsCheckStateProvider());
        this.groupTableViewer.setLabelProvider((IBaseLabelProvider)new AuthorizationLabelProvider());
        this.groupTableViewer.setInput(this.groupToStateMapping.keySet());
        this.comparator = new AuthorizationGroupViewerComparator();
        this.groupTableViewer.setComparator((ViewerComparator)this.comparator);
        this.groupTableViewer.getTable().addListener(4, event -> {
            int index = this.groupTableViewer.getTable().getSelectionIndex();
            this.groupTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            if (event.button != 1 || event.detail == 32 || index == -1 || !this.groupTableViewer.getTable().getItem(index).getBounds().contains(new Point(event.x, event.y))) {
                return;
            }
            this.groupTableViewer.setChecked(this.groupTableViewer.getElementAt(index), !this.groupTableViewer.getChecked(this.groupTableViewer.getElementAt(index)));
        });
        scrolledComposite.setContent(this.groupTableViewer.getControl());
        this.makeAction();
        this.fillLocalToolbar(toolbar);
        this.customButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (AssignGroupsDialog.this.customButton.getSelection()) {
                    AssignGroupsDialog.this.groupTableViewer.getTable().setEnabled(true);
                    toolbar.setEnabled(true);
                } else {
                    AssignGroupsDialog.this.groupTableViewer.getTable().setEnabled(false);
                    toolbar.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        if (this.permissionSet.isLocalOnly()) {
            this.localButton.setSelection(true);
            this.groupTableViewer.getTable().setEnabled(false);
            toolbar.setEnabled(false);
        } else if (this.permissionSet.isPublic()) {
            this.publicButton.setSelection(true);
            this.groupTableViewer.getTable().setEnabled(false);
            toolbar.setEnabled(false);
        } else if (this.groupToStateMapping.isEmpty()) {
            this.localButton.setSelection(true);
            this.groupTableViewer.getTable().setEnabled(false);
            toolbar.setEnabled(false);
        } else {
            this.customButton.setSelection(true);
            this.groupTableViewer.getTable().setEnabled(true);
            toolbar.setEnabled(true);
        }
        scrolledComposite.setFocus();
        return container;
    }

    private void fillLocalToolbar(ToolBar toolbar) {
        new ToolbarFilterWidget((StructuredViewer)this.groupTableViewer, "Filter groups...").fill(toolbar, 0);
        new ActionContributionItem((IAction)this.sortActionAscending).fill(toolbar, 1);
        new ActionContributionItem((IAction)this.sortActionDescending).fill(toolbar, 2);
    }

    private void makeAction() {
        this.sortActionAscending = new ListSortAction(1);
        this.sortActionAscending.setImageDescriptor(AuthorizationConstants.SORT_ASC);
        this.sortActionAscending.setText("Sort alphabetically ascending");
        this.sortActionDescending = new ListSortAction(-1);
        this.sortActionDescending.setImageDescriptor(AuthorizationConstants.SORT_DESC);
        this.sortActionDescending.setText("Sort alphabetically descending");
    }

    public PublishingType getType() {
        return this.type;
    }

    public class GroupsCheckStateProvider
    implements ICheckStateProvider {
        public boolean isChecked(Object arg0) {
            return (Boolean)AssignGroupsDialog.this.groupToStateMapping.get(arg0);
        }

        public boolean isGrayed(Object arg0) {
            return false;
        }
    }

    public class GroupsTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object arg0) {
            ArrayList<AuthorizationAccessGroup> groups = new ArrayList<AuthorizationAccessGroup>();
            for (AuthorizationAccessGroup group : AssignGroupsDialog.this.groupToStateMapping.keySet()) {
                groups.add(group);
            }
            return groups.toArray();
        }
    }

    private final class ListSortAction
    extends Action {
        private int direction;

        protected ListSortAction(int direction) {
            this.direction = direction;
            this.setChecked(AssignGroupsDialog.this.comparator.getDirection() == direction);
        }

        public void run() {
            AssignGroupsDialog.this.comparator.setDirection(this.direction);
            AssignGroupsDialog.this.groupTableViewer.refresh();
            AssignGroupsDialog.this.sortActionAscending.setChecked(this.direction == 1);
            AssignGroupsDialog.this.sortActionDescending.setChecked(this.direction == -1);
        }
    }
}

