/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.api;

import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EndpointDefinitionBuilder {
    private final EndpointType type;
    private final Map<String, Object> rawDefinition = new HashMap<String, Object>();

    public EndpointDefinitionBuilder(EndpointType type) {
        this.type = type;
        this.rawDefinition.put("dataTypes", new LinkedList());
    }

    public EndpointDefinitionBuilder defaultDatatype(DataType defaultDatatype) {
        this.rawDefinition.put("defaultDataType", defaultDatatype.name());
        return this;
    }

    public EndpointDefinitionBuilder allowedDatatype(DataType datatype) {
        return this.allowedDatatypes(Arrays.asList(datatype));
    }

    public EndpointDefinitionBuilder allowedDatatypes(Collection<DataType> datatypes) {
        List stringList = datatypes.stream().map(Enum::name).collect(Collectors.toList());
        this.rawDefinition.put("dataTypes", stringList);
        return this;
    }

    public EndpointDefinitionBuilder name(String name) {
        this.rawDefinition.put("name", name);
        return this;
    }

    public EndpointDefinitionBuilder inputHandlings(Collection<EndpointDefinition.InputDatumHandling> inputHandlings) {
        List stringList = inputHandlings.stream().map(Enum::name).collect(Collectors.toList());
        this.rawDefinition.put("inputHandlingOptions", stringList);
        return this;
    }

    public EndpointDefinitionBuilder defaultInputHandling(EndpointDefinition.InputDatumHandling handling) {
        this.rawDefinition.put("defaultInputHandling", handling.name());
        return this;
    }

    public EndpointDefinitionBuilder defaultInputExecutionConstraint(EndpointDefinition.InputExecutionContraint constraint) {
        this.rawDefinition.put("defaultInputExecutionConstraint", constraint.name());
        return this;
    }

    public EndpointDefinitionBuilder inputExecutionConstraints(Collection<EndpointDefinition.InputExecutionContraint> constraintList) {
        List stringList = constraintList.stream().map(Enum::name).collect(Collectors.toList());
        this.rawDefinition.put("inputExecutionConstraintOptions", stringList);
        return this;
    }

    public EndpointDefinitionBuilder metadata(Map<String, Map<String, Object>> metadata) {
        this.rawDefinition.put("metaData", metadata);
        return this;
    }

    public EndpointDefinition build() {
        if (!this.rawDefinition.containsKey("defaultDataType")) {
            throw new IllegalStateException("Cannot build an EndpointDefinition without having set a default datatype");
        }
        return ComponentEndpointModelFactory.createEndpointDefinition(this.rawDefinition, this.type);
    }
}

