/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.command;

import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.component.integration.workflow.command.ParseResult;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class WfIntegrateCommandParser {
    private static final String EXPOSE_OUTPUT_FLAG = "--expose-output";
    private static final String EXPOSE_INPUT_FLAG = "--expose-input";
    private static final String EXPOSE_FLAG = "--expose";
    private static final String EXPOSE_INPUTS_FLAG = "--expose-inputs";
    private static final String EXPOSE_OUTPUTS_FLAG = "--expose-outputs";
    private static final String[] VALID_EXPOSE_FLAGS = new String[]{"--expose", "--expose-input", "--expose-output", "--expose-inputs", "--expose-outputs"};

    WfIntegrateCommandParser() {
    }

    public Collection<ParseResult<EndpointAdapter>> parseEndpointAdapterDefinition(CommandContext context, WorkflowDescription desc) {
        String parameterFlag = context.consumeNextToken();
        if (!Arrays.asList(VALID_EXPOSE_FLAGS).contains(parameterFlag)) {
            return Collections.singletonList(ParseResult.createErrorResult(StringUtils.format((String)"Unexpected exposure flag '%s'. Expected '--expose', '--expose-input[s]', or '--expose-output[s]'. Skipping this token.", (Object[])new Object[]{parameterFlag})));
        }
        String definition = context.consumeNextToken();
        String[] parts = definition.split(":");
        if (parts.length != 1 && parts.length != 2 && parts.length != 3) {
            return Collections.singletonList(ParseResult.createErrorResult(StringUtils.format((String)"Could not parse endpoint adapter definition '%s'. Expected format: Either '<component id>:<endpoint id>:<external name>' or '<component id>:<endpoint id>'", (Object[])new Object[]{definition})));
        }
        String componentId = parts[0];
        ParseResult<WorkflowNode> adaptedNodeOptional = this.findAdaptedNode(desc, componentId);
        if (adaptedNodeOptional.isErrorResult()) {
            return Collections.singletonList(ParseResult.createErrorResult(adaptedNodeOptional.getErrorDisplayMessage()));
        }
        WorkflowNode adaptedNode = adaptedNodeOptional.getResult();
        if (parts.length == 1) {
            boolean exposeInputs = EXPOSE_FLAG.equals(parameterFlag) || EXPOSE_INPUTS_FLAG.equals(parameterFlag);
            boolean exposeOutputs = EXPOSE_FLAG.equals(parameterFlag) || EXPOSE_OUTPUTS_FLAG.equals(parameterFlag);
            return this.buildAllEndpointAdaptersForNode(desc, adaptedNode, exposeInputs, exposeOutputs);
        }
        if (parts.length == 2) {
            String endpointName = parts[1];
            String externalName = parts[1];
            return Collections.singletonList(this.buildEndpointAdapter(desc, parameterFlag, adaptedNode, endpointName, externalName));
        }
        String endpointName = parts[1];
        String externalName = parts[2];
        return Collections.singletonList(this.buildEndpointAdapter(desc, parameterFlag, adaptedNode, endpointName, externalName));
    }

    private ParseResult<EndpointAdapter> buildEndpointAdapter(WorkflowDescription desc, String parameterFlag, WorkflowNode adaptedNode, String endpointName, String externalName) {
        EndpointDescriptionsManager inputDescriptionsManager = adaptedNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputDescriptionsManager = adaptedNode.getOutputDescriptionsManager();
        List<Object> potentiallyAdaptedInputs = EXPOSE_FLAG.equals(parameterFlag) || EXPOSE_INPUT_FLAG.equals(parameterFlag) ? Stream.concat(inputDescriptionsManager.getStaticEndpointDescriptions().stream(), inputDescriptionsManager.getDynamicEndpointDescriptions().stream()).filter(endpointDescription -> endpointDescription.getName().equals(endpointName)).collect(Collectors.toList()) : new LinkedList();
        List<Object> potentiallyAdaptedOutputs = EXPOSE_FLAG.equals(parameterFlag) || EXPOSE_OUTPUT_FLAG.equals(parameterFlag) ? Stream.concat(outputDescriptionsManager.getStaticEndpointDescriptions().stream(), outputDescriptionsManager.getDynamicEndpointDescriptions().stream()).filter(endpointDescription -> endpointDescription.getName().equals(endpointName)).collect(Collectors.toList()) : new LinkedList();
        int numberOfPotentiallyAdaptedEndpoints = potentiallyAdaptedInputs.size() + potentiallyAdaptedOutputs.size();
        if (numberOfPotentiallyAdaptedEndpoints == 0) {
            StringBuilder errorMessage = new StringBuilder(StringUtils.format((String)"Given endpoint '%s' is not present on node '%s' [ID: %s].", (Object[])new Object[]{endpointName, adaptedNode.getName(), adaptedNode.getIdentifierAsObject().toString()}));
            String inputs = Stream.concat(inputDescriptionsManager.getStaticEndpointDescriptions().stream(), inputDescriptionsManager.getDynamicEndpointDescriptions().stream()).map(description -> StringUtils.format((String)"%s [ID: %s]", (Object[])new Object[]{description.getName(), description.getIdentifier()})).collect(Collectors.joining("\n           "));
            String outputs = Stream.concat(outputDescriptionsManager.getStaticEndpointDescriptions().stream(), outputDescriptionsManager.getDynamicEndpointDescriptions().stream()).map(description -> StringUtils.format((String)"%s [ID: %s]", (Object[])new Object[]{description.getName(), description.getIdentifier()})).collect(Collectors.joining("\n           "));
            if (inputs.isEmpty() && outputs.isEmpty()) {
                errorMessage.append(" That node does not contain any endpoints.");
            } else {
                errorMessage.append(" The following endpoints are present on that node:\n");
                if (!inputs.isEmpty()) {
                    errorMessage.append("  Inputs:  ");
                    errorMessage.append(inputs);
                }
                if (!outputs.isEmpty()) {
                    errorMessage.append("  Outputs: ");
                    errorMessage.append(outputs);
                }
            }
            return ParseResult.createErrorResult(errorMessage.toString());
        }
        if (numberOfPotentiallyAdaptedEndpoints > 1) {
            ArrayList<String> errorLines = new ArrayList<String>(numberOfPotentiallyAdaptedEndpoints + 1);
            errorLines.add(StringUtils.format((String)"Given endpoint '%s' is ambiguous on node '%s' [ID: %s]. Candidates:", (Object[])new Object[]{endpointName, adaptedNode.getName(), adaptedNode.getIdentifierAsObject().toString()}));
            errorLines.addAll(Stream.concat(potentiallyAdaptedInputs.stream(), potentiallyAdaptedOutputs.stream()).map(endpointDefinition -> this.endpointDefinitionToDisplayString((EndpointDescription)endpointDefinition)).collect(Collectors.toList()));
            return ParseResult.createErrorResult(String.join((CharSequence)"\n", errorLines));
        }
        EndpointDescription adaptedEndpoint = (EndpointDescription)Stream.concat(potentiallyAdaptedInputs.stream(), potentiallyAdaptedOutputs.stream()).findFirst().get();
        EndpointAdapter.Builder definitionBuilder = potentiallyAdaptedInputs.contains(adaptedEndpoint) ? EndpointAdapter.inputAdapterBuilder() : EndpointAdapter.outputAdapterBuilder();
        definitionBuilder.workflowNodeIdentifier(adaptedNode.getIdentifierAsObject().toString()).internalEndpointName(endpointName).externalEndpointName(externalName).dataType(adaptedEndpoint.getDataType());
        if (potentiallyAdaptedInputs.contains(adaptedEndpoint)) {
            return this.finishBuildingInputAdapter(definitionBuilder, adaptedEndpoint);
        }
        return this.finishBuildingOutputAdapter(definitionBuilder);
    }

    private ParseResult<EndpointAdapter> finishBuildingOutputAdapter(EndpointAdapter.Builder definitionBuilder) {
        return ParseResult.createSuccessfulResult(definitionBuilder.build());
    }

    private ParseResult<EndpointAdapter> finishBuildingInputAdapter(EndpointAdapter.Builder definitionBuilder, EndpointDescription adaptedEndpoint) {
        String inputDatumHandlingString = adaptedEndpoint.getMetaDataValue("inputHandling_73b1056e");
        String inputExecutionConstraintString = adaptedEndpoint.getMetaDataValue("inputExecutionConstraint_4aae3eea");
        if (inputDatumHandlingString != null && inputExecutionConstraintString != null) {
            definitionBuilder.inputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)inputDatumHandlingString));
            definitionBuilder.inputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)inputExecutionConstraintString));
        } else if (adaptedEndpoint.getEndpointDefinition() != null) {
            definitionBuilder.inputHandling(adaptedEndpoint.getEndpointDefinition().getDefaultInputDatumHandling());
            definitionBuilder.inputExecutionConstraint(adaptedEndpoint.getEndpointDefinition().getDefaultInputExecutionConstraint());
        } else {
            return ParseResult.createErrorResult(StringUtils.format((String)"Could not determine input datum handling of endpoint '%s' [ID: %s]. This may be due to unavailability of the component. Please make sure that all components whose endpoints are adapted are available at the time of integration.", (Object[])new Object[]{adaptedEndpoint.getName(), adaptedEndpoint.getIdentifier()}));
        }
        return ParseResult.createSuccessfulResult(definitionBuilder.build());
    }

    private String endpointDefinitionToDisplayString(EndpointDescription endpointDefinition) {
        return StringUtils.format((String)"  %s [ID: %s]", (Object[])new Object[]{endpointDefinition.getName(), endpointDefinition.getIdentifier()});
    }

    private ParseResult<WorkflowNode> findAdaptedNode(WorkflowDescription desc, String componentId) {
        Stream<WorkflowNode> adaptedNodesById;
        Stream<WorkflowNode> adaptedNodesByName = desc.getWorkflowNodes().stream().filter(node -> node.getName().equals(componentId));
        List adaptedNodes = Stream.concat(adaptedNodesByName, adaptedNodesById = desc.getWorkflowNodes().stream().filter(node -> node.getIdentifierAsObject().toString().equals(componentId))).collect(Collectors.toList());
        if (adaptedNodes.isEmpty()) {
            return ParseResult.createErrorResult(StringUtils.format((String)"Given node '%s' is not present in workflow", (Object[])new Object[]{componentId}));
        }
        if (adaptedNodes.size() > 1) {
            ArrayList<String> errorLines = new ArrayList<String>(adaptedNodes.size() + 1);
            errorLines.add(StringUtils.format((String)"Given node %s is ambiguous. Candidates:", (Object[])new Object[]{componentId}));
            errorLines.addAll(adaptedNodes.stream().map(wfNode -> StringUtils.format((String)"  %s [ID: %s]", (Object[])new Object[]{wfNode.getName(), wfNode.getIdentifierAsObject()})).collect(Collectors.toList()));
            return ParseResult.createErrorResult(String.join((CharSequence)"\n", errorLines));
        }
        WorkflowNode adaptedNode = (WorkflowNode)adaptedNodes.get(0);
        return ParseResult.createSuccessfulResult(adaptedNode);
    }

    private Collection<ParseResult<EndpointAdapter>> buildAllEndpointAdaptersForNode(WorkflowDescription desc, WorkflowNode adaptedNode, boolean exposeInputs, boolean exposeOutputs) {
        EndpointAdapter.Builder definitionBuilder;
        EndpointDescriptionsManager inputDescriptionsManager = adaptedNode.getInputDescriptionsManager();
        EndpointDescriptionsManager outputDescriptionsManager = adaptedNode.getOutputDescriptionsManager();
        List<Object> potentiallyAdaptedInputs = exposeInputs ? Stream.concat(inputDescriptionsManager.getStaticEndpointDescriptions().stream(), inputDescriptionsManager.getDynamicEndpointDescriptions().stream()).collect(Collectors.toList()) : new LinkedList();
        List<Object> potentiallyAdaptedOutputs = exposeOutputs ? Stream.concat(outputDescriptionsManager.getStaticEndpointDescriptions().stream(), outputDescriptionsManager.getDynamicEndpointDescriptions().stream()).collect(Collectors.toList()) : new LinkedList();
        int numberOfPotentiallyAdaptedEndpoints = potentiallyAdaptedInputs.size() + potentiallyAdaptedOutputs.size();
        if (numberOfPotentiallyAdaptedEndpoints == 0) {
            return Collections.singletonList(ParseResult.createErrorResult(StringUtils.format((String)"There are no endpoints present to expose on node '%s'", (Object[])new Object[]{adaptedNode.getName()})));
        }
        LinkedList<ParseResult<EndpointAdapter>> returnValue = new LinkedList<ParseResult<EndpointAdapter>>();
        for (EndpointDescription endpointDescription : potentiallyAdaptedInputs) {
            definitionBuilder = EndpointAdapter.inputAdapterBuilder().workflowNodeIdentifier(adaptedNode.getIdentifierAsObject().toString()).internalEndpointName(endpointDescription.getName()).externalEndpointName(endpointDescription.getName()).dataType(endpointDescription.getDataType());
            returnValue.add(this.finishBuildingInputAdapter(definitionBuilder, endpointDescription));
        }
        for (EndpointDescription endpointDescription : potentiallyAdaptedOutputs) {
            definitionBuilder = EndpointAdapter.outputAdapterBuilder().workflowNodeIdentifier(adaptedNode.getIdentifierAsObject().toString()).internalEndpointName(endpointDescription.getName()).externalEndpointName(endpointDescription.getName()).dataType(endpointDescription.getDataType());
            returnValue.add(this.finishBuildingOutputAdapter(definitionBuilder));
        }
        return returnValue;
    }
}

