/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.logging.LogFactory;

final class ProcessUtils {
    public static final int LINUX_EXIT_CODE_SUCCESS = 0;
    public static final int LINUX_EXIT_CODE_SIGTERM = 143;
    public static final int WINDOWS_EXIT_CODE_SUCCESS = 0;
    public static final int WINDOWS_EXIT_CODE_SIGTERM = 1;
    public static final int WINDOWS_EXIT_CODE_WAIT_NO_CHILDREN = 128;
    public static final int WINDOWS_EXIT_CODE_EA_LIST_INCONSISTENT = 255;
    private static final int TEN_SECONDS_IN_MILLIS = 10000;
    private static final String[] WINDOWS_SHELL_TOKENS = new String[]{"cmd.exe", "/c", "[command]"};
    private static final String[] LINUX_SHELL_TOKENS = new String[]{"setsid", "/bin/sh", "-c", "[command]"};
    private static final String WINDOWS_KILL_COMMAND_TEMPLATE = "Taskkill /T /F /PID %d";
    private static final String LINUX_TERM_COMMAND_TEMPLATE = "for pid in $(ps -s %d -o pid=); do kill ${pid}; done";
    private static final String LINUX_KILL_COMMAND_TEMPLATE = "for pid in $(ps -s %d -o pid=); do kill -9 ${pid}; done";
    private static final String INACCESSIBLE_OBJECT_EXCEPTION = "InaccessibleObjectException";
    private static final String LINUX_CHECK_COMMAND_TEMPLATE = "ps -s %d -o pid=";
    private static final int LINUX_TERM_ATTEMPTS = 3;
    private static final int LINUX_KILL_ATTEMPTS = 3;
    private static final String UNKOWN_PLATFORM_ERROR = "Unkown platform. Currently only Windows and Linux are supported.";

    private ProcessUtils() {
    }

    static CommandLine constructCommandLine(String command) {
        String[] commandTokens;
        if (Platform.isWindows()) {
            commandTokens = Arrays.copyOf(WINDOWS_SHELL_TOKENS, WINDOWS_SHELL_TOKENS.length);
            commandTokens[ProcessUtils.WINDOWS_SHELL_TOKENS.length - 1] = "\"" + command + "\"";
        } else if (Platform.isLinux()) {
            commandTokens = Arrays.copyOf(LINUX_SHELL_TOKENS, LINUX_SHELL_TOKENS.length);
            commandTokens[ProcessUtils.LINUX_SHELL_TOKENS.length - 1] = command;
        } else {
            throw new IllegalStateException(UNKOWN_PLATFORM_ERROR);
        }
        CommandLine cmd = new CommandLine(commandTokens[0]);
        int i = 1;
        while (i < commandTokens.length) {
            cmd.addArgument(commandTokens[i], false);
            ++i;
        }
        return cmd;
    }

    static int getPid(Process pProcess) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        try {
            if (Platform.isWindows()) {
                Field f = pProcess.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long processHandle = f.getLong(pProcess);
                return Kernel32.INSTANCE.GetProcessId(processHandle);
            }
            if (Platform.isLinux()) {
                Field f = pProcess.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(pProcess);
            }
            throw new IllegalStateException(UNKOWN_PLATFORM_ERROR);
        }
        catch (RuntimeException e) {
            if (e.getClass().getSimpleName().contains(INACCESSIBLE_OBJECT_EXCEPTION)) {
                LogFactory.getLog((String)ProcessUtils.class.getCanonicalName()).debug((Object)"Using fallback method to retrieve process id due to limited reflection access in Java versions >=16. Original exception:", (Throwable)e);
                String processString = pProcess.toString();
                Pattern pattern = Pattern.compile("pid=(\\d+),");
                Matcher matcher = pattern.matcher(processString);
                if (matcher.find()) {
                    return Integer.parseInt(matcher.group(1));
                }
                throw e;
            }
            throw e;
        }
    }

    static boolean killProcessTree(int pid) throws ExecuteException, IOException, InterruptedException {
        DefaultExecutor executor = new DefaultExecutor();
        if (Platform.isWindows()) {
            int[] nArray = new int[3];
            nArray[1] = 128;
            nArray[2] = 255;
            int[] validExitValues = nArray;
            executor.setExitValues(validExitValues);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null));
            CommandLine cl = ProcessUtils.constructCommandLine(StringUtils.format((String)WINDOWS_KILL_COMMAND_TEMPLATE, (Object[])new Object[]{pid}));
            int exitCode = executor.execute(cl);
            int[] nArray2 = validExitValues;
            int n = validExitValues.length;
            int n2 = 0;
            while (n2 < n) {
                int validExitValue = nArray2[n2];
                if (exitCode == validExitValue) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (Platform.isLinux()) {
            boolean terminated = ProcessUtils.termOrKill(executor, 3, LINUX_TERM_COMMAND_TEMPLATE, pid);
            if (terminated) {
                return true;
            }
            Thread.sleep(10000L);
            return ProcessUtils.termOrKill(executor, 3, LINUX_KILL_COMMAND_TEMPLATE, pid);
        }
        throw new IllegalStateException(UNKOWN_PLATFORM_ERROR);
    }

    private static boolean termOrKill(DefaultExecutor executor, int attempts, String terminationCommand, int pid) throws ExecuteException, IOException {
        int i = 0;
        while (i < attempts) {
            CommandLine terminate = ProcessUtils.constructCommandLine(StringUtils.format((String)terminationCommand, (Object[])new Object[]{pid}));
            int[] nArray = new int[2];
            nArray[1] = 1;
            executor.setExitValues(nArray);
            executor.execute(terminate);
            CommandLine check = ProcessUtils.constructCommandLine(StringUtils.format((String)LINUX_CHECK_COMMAND_TEMPLATE, (Object[])new Object[]{pid}));
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            executor.setExitValues(nArray2);
            int checkExitCode = executor.execute(check);
            if (checkExitCode == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static interface Kernel32
    extends Library {
        public static final Kernel32 INSTANCE = (Kernel32)Native.load((String)"kernel32", Kernel32.class);

        public int GetProcessId(Long var1);
    }
}

