/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.common;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.start.common.Instance;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.app.IApplication;

public abstract class InstanceRunner {
    protected static volatile InstanceValidationService instanceValidationService;
    private static volatile CommandExecutionService commandExecutionService;
    protected final Log log = LogFactory.getLog(this.getClass());

    public void bindCommandExecutionService(CommandExecutionService newService) {
        commandExecutionService = newService;
    }

    public void bindInstanceValidationService(InstanceValidationService newService) {
        instanceValidationService = newService;
    }

    public int run() throws Exception {
        this.log.debug((Object)("Core version: " + VersionUtils.getCoreBundleVersion()));
        this.log.debug((Object)("Product version: " + VersionUtils.getProductVersion()));
        this.log.debug((Object)("Command line arguments passed: " + System.getProperty("sun.java.command")));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        for (String vmArg : runtime.getInputArguments()) {
            this.log.debug((Object)("JVM argument passed: " + vmArg));
        }
        if (Instance.isShutdownRequested()) {
            return IApplication.EXIT_OK;
        }
        if (!this.validateInstance()) {
            return IApplication.EXIT_OK;
        }
        return this.performRun();
    }

    private boolean validateInstance() {
        boolean repeatValidation;
        do {
            boolean confirmationGiven;
            boolean confirmationRequired;
            boolean recoveryRequired;
            boolean shutdownRequired;
            repeatValidation = false;
            Map<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>> validationResults = instanceValidationService.validateInstance();
            int passed = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.PASSED).size();
            int failedWithConfirmationRequired = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_CONFIRMATION_REQUIRED).size();
            int failedWithRecoveryRequired = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_RECOVERY_REQUIRED).size();
            int failedWithShutdownRequired = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED).size();
            this.log.debug((Object)StringUtils.format((String)"Instance validation results [%d in total]: %d passed, %d failed with confirmation required, %d passed with recovery required, %d failed with shutdown required", (Object[])new Object[]{passed + failedWithConfirmationRequired + failedWithRecoveryRequired + failedWithShutdownRequired, passed, failedWithConfirmationRequired, failedWithRecoveryRequired, failedWithShutdownRequired}));
            for (InstanceValidationResult result : validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_CONFIRMATION_REQUIRED)) {
                this.log.error((Object)StringUtils.format((String)"Instance validation '%s' failed: %s", (Object[])new Object[]{result.getValidationDisplayName(), result.getLogMessage()}));
            }
            for (InstanceValidationResult result : validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_RECOVERY_REQUIRED)) {
                this.log.debug((Object)StringUtils.format((String)"Instance validation '%s' failed recoverably: %s", (Object[])new Object[]{result.getValidationDisplayName(), result.getLogMessage()}));
            }
            for (InstanceValidationResult result : validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED)) {
                this.log.error((Object)StringUtils.format((String)"Instance validation '%s' failed irrecoverably: %s. RCE is shutting down", (Object[])new Object[]{result.getValidationDisplayName(), result.getLogMessage()}));
            }
            boolean bl = shutdownRequired = failedWithShutdownRequired > 0;
            if (shutdownRequired) {
                this.onShutdownRequired(validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED));
                return false;
            }
            boolean bl2 = recoveryRequired = failedWithRecoveryRequired > 0;
            if (recoveryRequired) {
                boolean recoverySucceeded = this.onRecoveryRequired(validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_RECOVERY_REQUIRED));
                if (recoverySucceeded) {
                    repeatValidation = true;
                } else {
                    return false;
                }
            }
            boolean bl3 = confirmationRequired = failedWithConfirmationRequired > 0;
            if (!confirmationRequired || (confirmationGiven = this.onConfirmationRequired(validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_CONFIRMATION_REQUIRED)))) continue;
            return false;
        } while (repeatValidation);
        return true;
    }

    public abstract int performRun() throws Exception;

    public abstract void onShutdownRequired(List<InstanceValidationResult> var1);

    public abstract boolean onRecoveryRequired(List<InstanceValidationResult> var1);

    public abstract boolean onConfirmationRequired(List<InstanceValidationResult> var1);

    public void onValidationSuccess(List<InstanceValidationResult> validationResults) {
    }

    public void beforeAwaitShutdown() {
    }

    public void triggerShutdown() {
    }

    public void triggerRestart() {
    }

    protected Future<CommandExecutionResult> initiateAsyncCommandExecution(String[] execCommandTokens, final String taskDescription, final boolean isBatchMode) {
        if (commandExecutionService == null) {
            this.log.error((Object)("Command execution service not available; ignoring provided command(s) " + execCommandTokens));
            return null;
        }
        final String taskDescriptionWithTokens = String.valueOf(taskDescription) + " (\"" + org.apache.commons.lang3.StringUtils.join((Object[])execCommandTokens, (String)" ") + "\")";
        final PrintStream stdout = System.out;
        TextOutputReceiver outputReceiver = new TextOutputReceiver(){

            public void addOutput(String line) {
                if (isBatchMode) {
                    InstanceRunner.this.log.debug((Object)("Output of command-line batch command(s): " + line));
                    stdout.println(line);
                } else {
                    InstanceRunner.this.log.info((Object)("Output of command-line startup command(s): " + line));
                }
            }

            public void onStart() {
                InstanceRunner.this.log.debug((Object)("Starting " + taskDescriptionWithTokens));
            }

            public void onFatalError(Exception e) {
                CommandException ce = (CommandException)e;
                if (ce.getType().equals((Object)CommandException.Type.HELP_REQUESTED)) {
                    stdout.println(commandExecutionService.getHelpText(false, ce.shouldPrintDeveloperHelp()));
                } else {
                    InstanceRunner.this.log.error((Object)("Error during " + taskDescription), (Throwable)e);
                }
            }

            public void onFinished() {
                InstanceRunner.this.log.debug((Object)("Finished " + taskDescriptionWithTokens));
            }
        };
        return commandExecutionService.asyncExecMultiCommand(Arrays.asList(execCommandTokens), outputReceiver, (Object)taskDescription);
    }
}

