/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.jpedal.DisplayOffsets;
import org.jpedal.PDFtoImageConvertor;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.TextDecoder;
import org.jpedal.render.SwingDisplay;

public class DecoderOptions {
    private int pageMode = 1;
    private DisplayOffsets displayOffsets = new DisplayOffsets();
    Javascript javascript = null;
    public static Color highlightColor = new Color(10, 100, 170);
    public static Color backgroundColor = null;
    Color nonDrawnPageColor = Color.WHITE;
    Color pageColor = Color.WHITE;
    private Integer instance_bestQualityMaxScaling = null;
    private int[] instance_formsNoPrint = null;
    private static int[] formsNoPrint = null;
    private static String[] extactionPageSize = null;
    private String[] instance_extactionPageSize = null;
    private static Boolean overridePageSize = null;
    private Boolean instance_overridePageSize = null;
    private Boolean instance_allowPagesSmallerThanPageSize = Boolean.FALSE;
    private boolean isXMLExtraction = true;
    private boolean useJavascript = true;

    public boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    public void setXMLExtraction(boolean bl) {
        this.isXMLExtraction = bl;
    }

    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    public void setDisplayOffsets(DisplayOffsets displayOffsets) {
        this.displayOffsets = displayOffsets;
    }

    public void setPageMode(int n) {
        this.pageMode = n;
    }

    public int getPageMode() {
        return this.pageMode;
    }

    public boolean hasJavascript() {
        return false;
    }

    public void setJavaScriptUsed(boolean bl) {
        this.useJavascript = bl;
    }

    public void disposeObjects() {
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
    }

    public void useXMLExtraction() {
        this.isXMLExtraction = true;
    }

    public PdfGroupingAlgorithms getGroupingObject(int n, PdfData pdfData, PdfPageData pdfPageData) throws PdfException {
        if (n == -1) {
            throw new RuntimeException("No pages decoded - call decodePage(pageNumber) first");
        }
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData, pdfPageData, this.isXMLExtraction);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject(PdfData pdfData, PdfPageData pdfPageData) {
        PdfData pdfData2 = pdfData;
        if (pdfData2 == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData2, pdfPageData, this.isXMLExtraction);
    }

    public Javascript getJS() {
        return this.javascript;
    }

    public void set(Map map) throws PdfException {
        for (Object k : map.keySet()) {
            if (k instanceof Integer) {
                Integer n = (Integer)k;
                Object v = map.get(n);
                if (n.equals(JPedalSettings.UNDRAWN_PAGE_COLOR)) {
                    if (v instanceof Integer) {
                        this.nonDrawnPageColor = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.UNDRAWN_PAGE_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.PAGE_COLOR)) {
                    if (v instanceof Integer) {
                        this.pageColor = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.PAGE_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                    if (v instanceof Integer) {
                        this.instance_bestQualityMaxScaling = (Integer)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
                }
                if (n.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                    if (v instanceof String[]) {
                        this.instance_extactionPageSize = (String[])v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
                }
                if (n.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                    if (v instanceof int[]) {
                        this.instance_formsNoPrint = (int[])v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
                }
                if (n.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                    if (v instanceof Boolean) {
                        this.instance_overridePageSize = (Boolean)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
                }
                if (n.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) {
                    if (v instanceof Boolean) {
                        this.instance_allowPagesSmallerThanPageSize = (Boolean)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
                }
                DecoderOptions.setParameter(map, k);
                continue;
            }
            throw new PdfException("Unknown or unsupported key (not Integer) " + k);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setParameter(Map map, Object object) throws PdfException {
        if (!(object instanceof Integer)) throw new PdfException("Unknown or unsupported key (not Integer) " + object);
        Integer n = (Integer)object;
        Object v = map.get(n);
        if (n.equals(JPedalSettings.INVERT_HIGHLIGHT)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.INVERT_HIGHLIGHT expects an Boolean value");
            SwingDisplay.invertHighlight = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
            if (!(v instanceof Color)) throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
            backgroundColor = (Color)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
            if (!(v instanceof Color)) throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
            highlightColor = (Color)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
            Boolean bl = (Boolean)v;
            PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = bl;
            return;
        } else if (n.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
            Boolean bl = (Boolean)v;
            TextDecoder.showInvisibleText = bl;
            return;
        } else if (n.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
            if (!(v instanceof Integer)) throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
            Integer n2 = (Integer)v;
            FontData.maxSizeAllowedInMemory = n2;
            return;
        } else {
            if (n.equals(JPedalSettings.IMAGE_HIRES)) return;
            if (n.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                if (!(v instanceof Integer)) throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
                PDFtoImageConvertor.bestQualityMaxScaling = (Integer)v;
                return;
            } else if (n.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                if (!(v instanceof String[])) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
                extactionPageSize = (String[])v;
                return;
            } else if (n.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
                overridePageSize = (Boolean)v;
                return;
            } else if (n.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                if (!(v instanceof int[])) throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
                formsNoPrint = (int[])v;
                return;
            } else {
                if (!n.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) throw new PdfException("Unknown or unsupported key " + n);
                if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
                PDFtoImageConvertor.allowPagesSmallerThanPageSize = (Boolean)v;
            }
        }
    }

    public static void modifyJPedalParameters(Map map) throws PdfException {
        for (Object k : map.keySet()) {
            DecoderOptions.setParameter(map, k);
        }
    }

    public Color getPageColor() {
        return this.pageColor;
    }

    public Paint getNonDrawnPageColor() {
        return this.nonDrawnPageColor;
    }

    public Boolean getInstance_allowPagesSmallerThanPageSize() {
        return this.instance_allowPagesSmallerThanPageSize;
    }

    public Integer getInstance_bestQualityMaxScaling() {
        return this.instance_bestQualityMaxScaling;
    }

    public static int[] getFormsNoPrint() {
        return formsNoPrint;
    }

    public int[] getInstance_FormsNoPrint() {
        return this.instance_formsNoPrint;
    }

    public Boolean getPageSizeToUse() {
        Boolean bl = Boolean.FALSE;
        if (this.instance_overridePageSize != null) {
            bl = this.instance_overridePageSize;
        } else if (overridePageSize != null) {
            bl = overridePageSize;
        }
        return bl;
    }

    public float getImageDimensions(int n, PdfPageData pdfPageData) {
        String string;
        float f = -2.0f;
        String string2 = System.getProperty("org.jpedal.pageSizeOverridesImage");
        if (string2 != null) {
            if (this.instance_overridePageSize != null) {
                this.instance_overridePageSize = Boolean.parseBoolean(string2);
            } else {
                overridePageSize = Boolean.parseBoolean(string2);
            }
        }
        if ((string = System.getProperty("org.jpedal.pageMaxScaling")) != null) {
            try {
                if (this.instance_bestQualityMaxScaling != null) {
                    this.instance_bestQualityMaxScaling = new Integer(Integer.parseInt(string));
                } else {
                    PDFtoImageConvertor.bestQualityMaxScaling = new Integer(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray = null;
        String string3 = System.getProperty("org.jpedal.pageSize");
        if (string3 != null) {
            stringArray = string3.split("x");
        }
        if (stringArray == null) {
            stringArray = this.instance_extactionPageSize != null ? this.instance_extactionPageSize : extactionPageSize;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (stringArray != null) {
            if (stringArray.length == 2) {
                f2 = Float.parseFloat(stringArray[0]);
                f3 = Float.parseFloat(stringArray[1]);
            } else {
                throw new RuntimeException("Invalid parameters in JVM option -DpageSize ");
            }
        }
        float f4 = 0.0f;
        if (stringArray != null) {
            float f5 = pdfPageData.getCropBoxWidth(n);
            float f6 = pdfPageData.getCropBoxHeight(n);
            float f7 = f3 / f6;
            if (f7 < (f4 = f2 / f5)) {
                f4 = f7;
            }
        }
        Boolean bl = this.getPageSizeToUse();
        if (stringArray != null && bl.booleanValue()) {
            f = f4;
        }
        return f;
    }
}

