/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.view.Messages;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class WorkflowInstancePropertySource
implements IPropertySource {
    protected static final String PROP_KEY_WORKKLOWPLATFORM = "de.rcenvironment.wfCtrlNodeId";
    protected static final String PROP_KEY_STARTTIME = "de.rcenvironment.wfStart";
    protected static final String PROP_KEY_NAME = "de.rcenvironment.wfName";
    protected static final String PROP_KEY_WORKFLOWNODES_COUNT = "de.rcenvironment.wfNodeCnt";
    protected static final String PROP_KEY_CONNECTIONS_COUNT = "de.rcenvironment.cnCnt";
    protected static final String PROP_KEY_COMPONENT_TYPES = "de.rcenvironment.wfNodeTypes";
    protected static final String PROP_KEY_INVOLVED_INSTANCES = "de.rcenvironment.involvedInstances";
    protected WorkflowExecutionInformation wfExeInfo;
    private final PlatformService platformService;

    public WorkflowInstancePropertySource(WorkflowExecutionInformation wfExeInfo) {
        this.wfExeInfo = wfExeInfo;
        this.platformService = (PlatformService)ServiceRegistry.createAccessFor((Object)this).getService(PlatformService.class);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROP_KEY_NAME, Messages.name), new PropertyDescriptor((Object)PROP_KEY_STARTTIME, Messages.starttime), new PropertyDescriptor((Object)PROP_KEY_WORKKLOWPLATFORM, Messages.platform), new PropertyDescriptor((Object)PROP_KEY_WORKFLOWNODES_COUNT, "Component count"), new PropertyDescriptor((Object)PROP_KEY_CONNECTIONS_COUNT, "Connection count"), new PropertyDescriptor((Object)PROP_KEY_COMPONENT_TYPES, "Component types count"), new PropertyDescriptor((Object)PROP_KEY_INVOLVED_INSTANCES, "Instances involved")};
        return descriptors;
    }

    public Object getPropertyValue(Object key) {
        Object value = null;
        if (key.equals(PROP_KEY_NAME)) {
            value = this.wfExeInfo.getInstanceName();
        } else if (key.equals(PROP_KEY_WORKKLOWPLATFORM)) {
            value = this.wfExeInfo.getNodeId() == null || this.platformService.matchesLocalInstance((ResolvableNodeId)this.wfExeInfo.getNodeId()) ? Messages.local : this.wfExeInfo.getNodeId().getAssociatedDisplayName();
        } else if (key.equals(PROP_KEY_STARTTIME)) {
            value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.wfExeInfo.getStartTime()));
        } else if (key.equals(PROP_KEY_WORKFLOWNODES_COUNT)) {
            value = this.wfExeInfo.getWorkflowDescription().getWorkflowNodes().size();
        } else if (key.equals(PROP_KEY_CONNECTIONS_COUNT)) {
            value = this.wfExeInfo.getWorkflowDescription().getConnections().size();
        } else if (key.equals(PROP_KEY_COMPONENT_TYPES)) {
            value = this.getComponentTypesCount();
        } else if (key.equals(PROP_KEY_INVOLVED_INSTANCES)) {
            value = this.getInstancesCount();
        }
        return value;
    }

    public boolean isPropertySet(Object key) {
        return true;
    }

    private int getComponentTypesCount() {
        int count = 0;
        HashSet<String> componentIdentifiers = new HashSet<String>();
        for (WorkflowNode node : this.wfExeInfo.getWorkflowDescription().getWorkflowNodes()) {
            if (componentIdentifiers.contains(node.getComponentDescription().getIdentifier())) continue;
            componentIdentifiers.add(node.getComponentDescription().getIdentifier());
            ++count;
        }
        return count;
    }

    private int getInstancesCount() {
        int count = 0;
        HashSet<String> nodeIdentifiers = new HashSet<String>();
        for (WorkflowNode node : this.wfExeInfo.getWorkflowDescription().getWorkflowNodes()) {
            if (nodeIdentifiers.contains(node.getComponentDescription().getComponentInstallation().getNodeId())) continue;
            nodeIdentifiers.add(node.getComponentDescription().getComponentInstallation().getNodeId());
            ++count;
        }
        if (!nodeIdentifiers.contains(this.wfExeInfo.getNodeId().getLogicalNodeIdString())) {
            ++count;
        }
        return count;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }
}

