/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.gui.utils.incubator.AlphanumericalTextContraintListener;
import de.rcenvironment.core.gui.workflow.editor.NewWorkflowProjectWizard;
import de.rcenvironment.core.gui.workflow.editor.ProjectTreeContentProvider;
import de.rcenvironment.core.gui.workflow.editor.ProjectTreeLabelProvider;
import de.rcenvironment.core.gui.workflow.editor.ProjectUsages;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectSelectionPage
extends WizardPage {
    private static final char[] FORBIDDEN_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '>', '<', '|'};
    private static final int TEXT_WIDTH = 100;
    private static final int TREE_HEIGHT = 200;
    private static final int TREE_WIDTH = 100;
    private static final int LIST_HEIGHT = 200;
    private static final int PANEL_HEIGHT = 250;
    private static final int DIALOGWINDOWIDTH = 500;
    private static final int BORDERSIZE = 5;
    public Text projectNameTextField;
    protected Button useDefaultNameButton;
    protected String workflowName;
    protected ModifyListener projectNameTextFieldModifyListener;
    protected TreeViewer projectTreeViewer;
    private ProjectUsages usage;
    private IStructuredSelection selection;
    private Button newProjectRadioButton;
    private Button existingProjectRadioButton;

    public ProjectSelectionPage(Wizard parentWizard, IStructuredSelection selection) {
        super("Project");
        this.selection = selection;
        this.setTitle("Project");
        this.setDescription("Place the workflow in a project");
    }

    protected void dialogChanged() {
        IProject existingProject;
        String newProjectName = this.getProjectNameTextField().getText();
        if (newProjectName.length() == 0 && this.newProjectRadioButton.getSelection()) {
            this.updateStatus("Please chose a name for the new project");
            return;
        }
        if (newProjectName.length() > 0 && (existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName)) != null && existingProject.exists() && this.newProjectRadioButton.getSelection()) {
            this.updateStatus("This project name is already in use");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        if (message == null) {
            NewWorkflowProjectWizard.allowFinish();
        } else {
            NewWorkflowProjectWizard.preventFinish();
        }
        this.setPageComplete(message == null);
    }

    private void createExistingProjectPanel(Composite parent) {
        GridLayout existingGrid = new GridLayout(1, false);
        GridData existingGridDataComp = new GridData();
        existingGridDataComp.widthHint = 245;
        existingGridDataComp.heightHint = 250;
        existingGridDataComp.verticalAlignment = 1;
        existingGridDataComp.horizontalAlignment = 1;
        existingGridDataComp.grabExcessVerticalSpace = true;
        GridData existingGridDataRadio = new GridData();
        existingGridDataRadio.widthHint = 240;
        existingGridDataRadio.verticalAlignment = 1;
        existingGridDataRadio.horizontalAlignment = 1;
        existingGridDataRadio.grabExcessVerticalSpace = true;
        GridData existingGridDataList = new GridData();
        existingGridDataList.widthHint = 215;
        existingGridDataList.heightHint = 200;
        existingGridDataList.verticalAlignment = 1;
        existingGridDataList.horizontalAlignment = 1;
        existingGridDataList.grabExcessVerticalSpace = true;
        existingGridDataList.grabExcessHorizontalSpace = true;
        Composite existingProjectComposite = new Composite(parent, 2048);
        existingProjectComposite.setLayout((Layout)existingGrid);
        existingProjectComposite.setLayoutData((Object)existingGridDataComp);
        this.setExistingProjectRadioButton(new Button(existingProjectComposite, 16));
        this.getExistingProjectRadioButton().setText("Place in existing project");
        this.getExistingProjectRadioButton().setVisible(true);
        this.getExistingProjectRadioButton().setLayoutData((Object)existingGridDataRadio);
        this.projectTreeViewer = new TreeViewer(existingProjectComposite, 2820);
        this.projectTreeViewer.setContentProvider((IContentProvider)new ProjectTreeContentProvider());
        this.projectTreeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTreeLabelProvider());
        this.projectTreeViewer.setInput((Object)File.listRoots());
        this.projectTreeViewer.getTree().setSize(100, 200);
        this.projectTreeViewer.getTree().setLayoutData((Object)existingGridDataList);
        this.setControl((Control)existingProjectComposite);
    }

    private void createNewProjectPanel(Composite parent) {
        GridLayout newGrid = new GridLayout(1, false);
        GridData newGridDataComp = new GridData();
        newGridDataComp.widthHint = 245;
        newGridDataComp.heightHint = 250;
        newGridDataComp.verticalAlignment = 1;
        newGridDataComp.horizontalAlignment = 1;
        newGridDataComp.grabExcessVerticalSpace = false;
        GridData newGridDataRadio = new GridData();
        newGridDataRadio.widthHint = 245;
        newGridDataRadio.verticalAlignment = 1;
        newGridDataRadio.horizontalAlignment = 1;
        GridData newGridDataCheck = new GridData();
        newGridDataCheck.widthHint = 245;
        newGridDataCheck.verticalAlignment = 1;
        newGridDataCheck.horizontalAlignment = 1;
        GridData newGridDataLabel = new GridData();
        newGridDataLabel.widthHint = 245;
        newGridDataLabel.verticalAlignment = 1;
        newGridDataLabel.horizontalAlignment = 1;
        GridData newGridDataText = new GridData();
        newGridDataText.widthHint = 200;
        newGridDataText.minimumWidth = 100;
        newGridDataText.verticalAlignment = 1;
        newGridDataText.horizontalAlignment = 1;
        newGridDataText.grabExcessHorizontalSpace = true;
        Composite newProjectComposite = new Composite(parent, 2048);
        newProjectComposite.setLayout((Layout)newGrid);
        newProjectComposite.setLayoutData((Object)newGridDataComp);
        this.setNewProjectRadioButton(new Button(newProjectComposite, 16));
        this.getNewProjectRadioButton().setText("Place in new project");
        this.getNewProjectRadioButton().setLayoutData((Object)newGridDataRadio);
        this.getNewProjectRadioButton().setVisible(true);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.getNewProjectRadioButton().setSelection(false);
            this.getExistingProjectRadioButton().setSelection(true);
            this.setUsage(ProjectUsages.EXISTING);
        } else {
            this.getNewProjectRadioButton().setSelection(true);
            this.getExistingProjectRadioButton().setSelection(false);
            this.setUsage(ProjectUsages.NEW);
        }
        this.useDefaultNameButton = new Button(newProjectComposite, 32);
        this.useDefaultNameButton.setSelection(true);
        this.useDefaultNameButton.setText("Use default project name");
        this.useDefaultNameButton.setEnabled(this.getNewProjectRadioButton().getSelection());
        this.useDefaultNameButton.setVisible(true);
        this.useDefaultNameButton.setLayoutData((Object)newGridDataCheck);
        Label projectNameLabel = new Label(newProjectComposite, 0);
        projectNameLabel.setText("Project name: ");
        projectNameLabel.setVisible(true);
        projectNameLabel.setLayoutData((Object)newGridDataLabel);
        this.setProjectNameTextField(new Text(newProjectComposite, 2052));
        this.projectNameTextField.setEnabled(false);
        this.projectNameTextField.setVisible(true);
        this.projectNameTextField.setLayoutData((Object)newGridDataText);
        this.projectNameTextField.addListener(25, (Listener)new AlphanumericalTextContraintListener(false, true));
        this.projectNameTextField.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
        this.projectNameTextFieldModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ProjectSelectionPage.this.dialogChanged();
            }
        };
        this.projectNameTextField.addModifyListener(this.projectNameTextFieldModifyListener);
        if (NewWorkflowProjectWizard.sharedWorkflowName != null) {
            this.projectNameTextField.setText(NewWorkflowProjectWizard.sharedWorkflowName);
        }
        this.setControl((Control)newProjectComposite);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.createExistingProjectPanel(comp);
        this.createNewProjectPanel(comp);
        this.registerListeners();
        this.handleInitialTreeSelection();
    }

    private void handleInitialTreeSelection() {
        boolean useExistingProject = false;
        if (this.selection != null) {
            useExistingProject = true;
            useExistingProject = this.selection.getFirstElement() != null;
        }
        if (useExistingProject) {
            if (this.selection.size() == 1 && this.selection.getFirstElement() instanceof IProject) {
                this.projectTreeViewer.setSelection((ISelection)this.selection);
                this.getExistingProjectRadioButton().setSelection(true);
                this.getNewProjectRadioButton().setSelection(false);
            } else if (this.selection.size() == 1 && this.selection.getFirstElement() instanceof IFolder) {
                IFolder folder = (IFolder)this.selection.getFirstElement();
                String pathToExpand2 = folder.getFullPath().toOSString().substring(1);
                List<String> pathToExpand = Arrays.asList(pathToExpand2.split("\\\\"));
                TreeItem[] currentCandidates = this.projectTreeViewer.getTree().getItems();
                TreeItem lastItem = null;
                for (String segment : pathToExpand) {
                    TreeItem matchedItem = null;
                    TreeItem[] treeItemArray = currentCandidates;
                    int n = currentCandidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item.getText().equals(segment)) {
                            item.setExpanded(true);
                            matchedItem = item;
                            this.projectTreeViewer.refresh();
                            break;
                        }
                        ++n2;
                    }
                    if (matchedItem == null) continue;
                    currentCandidates = matchedItem.getItems();
                    lastItem = matchedItem;
                }
                if (lastItem != null) {
                    this.projectTreeViewer.getTree().setSelection(lastItem);
                }
                this.projectTreeViewer.refresh();
                this.getExistingProjectRadioButton().setSelection(true);
                this.getNewProjectRadioButton().setSelection(false);
            } else if (this.selection.size() == 1 && this.selection.getFirstElement() instanceof IFile) {
                IFile file = (IFile)this.selection.getFirstElement();
                StructuredSelection iss = new StructuredSelection((Object)file.getProject());
                this.projectTreeViewer.setSelection((ISelection)iss);
                this.getExistingProjectRadioButton().setSelection(true);
                this.getNewProjectRadioButton().setSelection(false);
            } else {
                this.activateExistingProjectPart();
            }
        } else {
            this.activateExistingProjectPart();
        }
        if (this.projectTreeViewer.getTree().getItemCount() == 0) {
            this.getExistingProjectRadioButton().setEnabled(false);
            this.projectTreeViewer.getTree().setEnabled(false);
            this.getNewProjectRadioButton().setSelection(true);
        }
    }

    private void registerListeners() {
        this.newProjectRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ProjectSelectionPage.this.getNewProjectRadioButton().getSelection()) {
                    if (NewWorkflowProjectWizard.sharedWorkflowName != null) {
                        ProjectSelectionPage.this.getProjectNameTextField().setText(NewWorkflowProjectWizard.sharedWorkflowName);
                    }
                    ProjectSelectionPage.this.useDefaultNameButton.setEnabled(true);
                    ProjectSelectionPage.this.getExistingProjectRadioButton().setSelection(false);
                    ProjectSelectionPage.this.projectTreeViewer.getTree().setEnabled(false);
                    ProjectSelectionPage.this.setUsage(ProjectUsages.NEW);
                    ProjectSelectionPage.this.dialogChanged();
                }
            }
        });
        this.existingProjectRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ProjectSelectionPage.this.getNewProjectRadioButton().setSelection(false);
                ProjectSelectionPage.this.useDefaultNameButton.setEnabled(false);
                ProjectSelectionPage.this.projectTreeViewer.getTree().setEnabled(true);
                if (ProjectSelectionPage.this.projectTreeViewer.getTree().getSelection().length == 0) {
                    ProjectSelectionPage.this.projectTreeViewer.getTree().setSelection(ProjectSelectionPage.this.projectTreeViewer.getTree().getItem(0));
                }
                NewWorkflowProjectWizard.setWorkbenchSelection((IStructuredSelection)new StructuredSelection((Object)ProjectSelectionPage.this.projectTreeViewer.getSelection()));
                ProjectSelectionPage.this.setUsage(ProjectUsages.EXISTING);
                ProjectSelectionPage.this.dialogChanged();
            }
        });
        this.useDefaultNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean selectionState = ProjectSelectionPage.this.useDefaultNameButton.getSelection();
                ProjectSelectionPage.this.getProjectNameTextField().setEditable(!selectionState);
                ProjectSelectionPage.this.getProjectNameTextField().setEnabled(!selectionState);
            }
        });
        this.projectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewWorkflowProjectWizard.setWorkbenchSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    protected void activateExistingProjectPart() {
        this.getNewProjectRadioButton().setSelection(true);
        this.getExistingProjectRadioButton().setSelection(false);
        if (this.workflowName != null) {
            this.getProjectNameTextField().setText(this.workflowName);
        }
    }

    public Text getProjectNameTextField() {
        return this.projectNameTextField;
    }

    public void setProjectNameTextField(Text projectNameTextField) {
        this.projectNameTextField = projectNameTextField;
    }

    public ProjectUsages getUsage() {
        return this.usage;
    }

    public void setUsage(ProjectUsages usage) {
        this.usage = usage;
    }

    public Button getNewProjectRadioButton() {
        return this.newProjectRadioButton;
    }

    public void setNewProjectRadioButton(Button newProjectRadioButton) {
        this.newProjectRadioButton = newProjectRadioButton;
    }

    public Button getExistingProjectRadioButton() {
        return this.existingProjectRadioButton;
    }

    public void setExistingProjectRadioButton(Button existingProjectRadioButton) {
        this.existingProjectRadioButton = existingProjectRadioButton;
    }
}

