/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties;

import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.gui.properties.Messages;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MethodPropertiesDialogGenerator
extends Dialog {
    private static final String TRUE = "true";
    private final MethodDescription methodDescription;
    private Map<Widget, String> widgetToKeyMap;

    protected MethodPropertiesDialogGenerator(Shell parentShell, MethodDescription methodDescription) {
        super(parentShell);
        this.methodDescription = methodDescription;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(Messages.algorithmProperties) + " - " + this.methodDescription.getMethodName());
        InputStream path = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/optimizer16.png");
        Image icon = new Image(null, new ImageData(path));
        shell.setImage(icon);
    }

    protected Control createDialogArea(Composite parent) {
        this.widgetToKeyMap = new HashMap<Widget, String>();
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        CTabFolder settingsTabFolder = new CTabFolder(dialogContainer, 2048);
        if (this.methodDescription != null) {
            if (this.methodDescription.getCommonSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getCommonSettings())) {
                CTabItem commonSettingsTab = new CTabItem(settingsTabFolder, 0);
                commonSettingsTab.setText("Common Settings");
                Composite commonSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                commonSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettings(this.methodDescription.getCommonSettings(), commonSettingsContainer);
                commonSettingsTab.setControl((Control)commonSettingsContainer);
            }
            if (this.methodDescription.getSpecificSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getSpecificSettings())) {
                CTabItem specificSettingsTab = new CTabItem(settingsTabFolder, 0);
                specificSettingsTab.setText("Algorithm Specific Settings");
                Composite specificSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                specificSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettings(this.methodDescription.getSpecificSettings(), specificSettingsContainer);
                specificSettingsTab.setControl((Control)specificSettingsContainer);
            }
            if (this.methodDescription.getResponsesSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getResponsesSettings())) {
                CTabItem responsesSettingsTab = new CTabItem(settingsTabFolder, 0);
                responsesSettingsTab.setText("Responses Settings");
                Composite responsesSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                responsesSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettings(this.methodDescription.getResponsesSettings(), responsesSettingsContainer);
                responsesSettingsTab.setControl((Control)responsesSettingsContainer);
            }
        }
        return dialogContainer;
    }

    private boolean checkIfSettingsAreGUIRelevant(Map<String, Map<String, String>> settings) {
        boolean returnValue = true;
        if (settings.isEmpty()) {
            returnValue = false;
        }
        if (settings != null) {
            for (String key : settings.keySet()) {
                if (settings.get(key).get("doNotShow") == null) continue;
                returnValue = false;
            }
        }
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    private void createSettings(Map<String, Map<String, String>> settings, Composite container) {
        block12: {
            if (settings == null) break block12;
            sortedSettings = new String[settings.keySet().size()];
            position = -1;
            for (String key : settings.keySet()) {
                block14: {
                    block13: {
                        orderNumber = settings.get(key).get("GuiOrder");
                        if (orderNumber == null) break block13;
                        position = Integer.parseInt(orderNumber) - 1;
                        if (position < sortedSettings.length) ** GOTO lbl14
                        while (position >= sortedSettings.length || sortedSettings[position] != null) {
                            --position;
                        }
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            ++position;
lbl14:
                            // 2 sources

                            ** while (sortedSettings[position] != null)
                        }
lbl15:
                        // 1 sources

                        break block14;
                    }
                    position = sortedSettings.length - 1;
                    while (sortedSettings[position] != null) {
                        --position;
                    }
                }
                sortedSettings[position] = key;
            }
            var8_12 = sortedSettings;
            orderNumber = sortedSettings.length;
            var6_6 = 0;
            while (var6_6 < orderNumber) {
                key = var8_12[var6_6];
                currentSetting = settings.get(key);
                if (settings.get(key).get("doNotShow") == null || !settings.get(key).get("doNotShow").equalsIgnoreCase("true")) {
                    value = currentSetting.get("Value");
                    if (value == null || value.equals("")) {
                        value = currentSetting.get("DefaultValue");
                    }
                    if (settings.get(key).get("SWTWidget").equals("Text")) {
                        newTextfield = this.createLabelAndTextfield(container, currentSetting.get("GuiName"), currentSetting.get("dataType"), value);
                        newTextfield.setData((Object)key);
                        this.widgetToKeyMap.put((Widget)newTextfield, key);
                        newTextfield.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
                    } else if (settings.get(key).get("SWTWidget").equals("Combo")) {
                        newCombo = this.createLabelAndCombo(container, currentSetting.get("GuiName"), currentSetting.get("Choices"), value);
                        this.widgetToKeyMap.put((Widget)newCombo, key);
                        newCombo.setData((Object)key);
                        newCombo.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
                    } else if (settings.get(key).get("SWTWidget").equals("Check")) {
                        newCheckbox = this.createLabelAndCheckbox(container, currentSetting.get("GuiName"), value);
                        this.widgetToKeyMap.put((Widget)newCheckbox, key);
                        newCheckbox.setData((Object)key);
                        newCheckbox.addSelectionListener((SelectionListener)new SelectionChangedListener());
                    }
                }
                ++var6_6;
            }
            new Label(container, 0).setText("");
            horizontalLine = new Label(container, 258);
            lineGridData = new GridData(16777992);
            horizontalLine.setLayoutData((Object)lineGridData);
            new Label(container, 0).setText("");
            loadDefaults = new Button(container, 8);
            loadDefaults.setImage(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.RESTORE_DEFAULT).createImage());
            gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            loadDefaults.setLayoutData((Object)gridData);
            loadDefaults.setText(Messages.restoreDefaultAlgorithmProperties);
            loadDefaults.addSelectionListener((SelectionListener)new DefaultSelectionListener(container, settings));
        }
    }

    private Button createLabelAndCheckbox(Composite container, String text, String value) {
        new Label(container, 0).setText(text);
        Button result = new Button(container, 32);
        if (value.equals(TRUE)) {
            result.setSelection(true);
        } else {
            result.setSelection(false);
        }
        return result;
    }

    private Combo createLabelAndCombo(Composite container, String text, String entries, String value) {
        String[] entryData;
        new Label(container, 0).setText(text);
        Combo result = new Combo(container, 8);
        String[] stringArray = entryData = entries.split(",");
        int n = entryData.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            result.add(entry);
            ++n2;
        }
        result.select(result.indexOf(value));
        return result;
    }

    private Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        new Label(container, 0).setText(text);
        Text result = new Text(container, 2052);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.setText(value);
        if (dataType.equals("Int")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 2));
        } else if (dataType.equals("Real")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 1));
        }
        return result;
    }

    public void validateInputs() {
        boolean isValid = true;
        for (Widget widget : this.widgetToKeyMap.keySet()) {
            Map settings = null;
            if (this.methodDescription.getCommonSettings() != null && this.methodDescription.getCommonSettings().containsKey(this.widgetToKeyMap.get(widget))) {
                settings = (Map)this.methodDescription.getCommonSettings().get(this.widgetToKeyMap.get(widget));
            } else if (this.methodDescription.getSpecificSettings() != null && this.methodDescription.getSpecificSettings().containsKey(this.widgetToKeyMap.get(widget))) {
                settings = (Map)this.methodDescription.getSpecificSettings().get(this.widgetToKeyMap.get(widget));
            } else if (this.methodDescription.getResponsesSettings() != null && this.methodDescription.getResponsesSettings().containsKey(this.widgetToKeyMap.get(widget))) {
                settings = (Map)this.methodDescription.getResponsesSettings().get(this.widgetToKeyMap.get(widget));
            }
            if (settings == null) continue;
            String dataType = (String)settings.get("dataType");
            String swtWidget = (String)settings.get("SWTWidget");
            String validation = (String)settings.get("Validation");
            if (!swtWidget.equals("Text")) continue;
            if (((Text)widget).getText().equals("") && validation.contains("required")) {
                isValid = false;
                continue;
            }
            if (((Text)widget).getText().equals("")) continue;
            if (dataType.equalsIgnoreCase("INT")) {
                int value = Integer.MAX_VALUE;
                try {
                    value = Integer.parseInt(((Text)widget).getText());
                    isValid &= this.checkValidation(value, validation);
                }
                catch (NumberFormatException numberFormatException) {
                    value = Integer.MAX_VALUE;
                    isValid &= false;
                }
            }
            if (!dataType.equalsIgnoreCase("REAL")) continue;
            double value = Double.MAX_VALUE;
            try {
                value = Double.parseDouble(((Text)widget).getText());
                isValid &= this.checkValidation(value, validation);
            }
            catch (NumberFormatException numberFormatException) {
                value = Double.MAX_VALUE;
                isValid &= false;
            }
        }
        this.getButton(0).setEnabled(isValid);
    }

    private boolean checkValidation(double value, String validation) {
        boolean result = true;
        if (validation != null && !validation.equals("")) {
            String[] splitValidations;
            String[] stringArray = splitValidations = validation.split(",");
            int n = splitValidations.length;
            int n2 = 0;
            while (n2 < n) {
                double restriction;
                String argument = stringArray[n2];
                if (argument.contains("<=")) {
                    restriction = Double.parseDouble(argument.substring(2));
                    if (value > restriction) {
                        result = false;
                    }
                } else if (argument.contains(">=")) {
                    restriction = Double.parseDouble(argument.substring(2));
                    if (value < restriction) {
                        result = false;
                    }
                } else if (argument.contains("<")) {
                    restriction = Double.parseDouble(argument.substring(1));
                    if (value >= restriction) {
                        result = false;
                    }
                } else if (argument.contains(">") && value <= (restriction = Double.parseDouble(argument.substring(1)))) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean checkValidation(int value, String validation) {
        return this.checkValidation((double)value, validation);
    }

    private class DefaultSelectionListener
    implements SelectionListener {
        private Composite container;
        private Map<String, Map<String, String>> settings;

        DefaultSelectionListener(Composite container, Map<String, Map<String, String>> settings) {
            this.container = container;
            this.settings = settings;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String key;
                Control field = controlArray[n2];
                if (field instanceof Text && (key = (String)((Text)field).getData()) != null && (value = this.settings.get(key).get("DefaultValue")) != null) {
                    ((Text)field).setText(value);
                }
                if (field instanceof Combo && (key = (String)((Combo)field).getData()) != null && (value = this.settings.get(key).get("DefaultValue")) != null) {
                    ((Combo)field).setText(value);
                }
                if (field instanceof Button && (key = (String)((Button)field).getData()) != null && (value = this.settings.get(key).get("DefaultValue")) != null) {
                    if (value.equals(MethodPropertiesDialogGenerator.TRUE) || value.equals("false")) {
                        ((Button)field).setSelection(Boolean.parseBoolean(value));
                    } else {
                        ((Button)field).setText(value);
                    }
                }
                ++n2;
            }
        }
    }

    private class MethodPropertiesModifyListener
    implements ModifyListener {
        private MethodPropertiesModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            Widget source = (Widget)arg0.getSource();
            if (source instanceof Text) {
                if (MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Text)source).getText());
                } else if (MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Text)source).getText());
                } else if (MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Text)source).getText());
                }
            } else if (source instanceof Combo) {
                if (MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Combo)source).getText());
                } else if (MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Combo)source).getText());
                } else if (MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings() != null && MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                    ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", ((Combo)source).getText());
                }
            }
            MethodPropertiesDialogGenerator.this.validateInputs();
        }
    }

    private class SelectionChangedListener
    extends SelectionAdapter {
        private SelectionChangedListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Button source = (Button)e.getSource();
            if (MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getCommonSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", "" + source.getSelection());
            } else if (MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getSpecificSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", "" + source.getSelection());
            } else if (MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().containsKey(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))) {
                ((Map)MethodPropertiesDialogGenerator.this.methodDescription.getResponsesSettings().get(MethodPropertiesDialogGenerator.this.widgetToKeyMap.get(source))).put("Value", "" + source.getSelection());
            }
            MethodPropertiesDialogGenerator.this.validateInputs();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }
}

