/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.gui;

import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Component;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Discipline;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Parameter;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GuiInputParser {
    private static final String NAME = "name";
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private XMLSupportService xmlSupport = (XMLSupportService)ServiceRegistry.createAccessFor((Object)this).getService(XMLSupportService.class);

    public List<Component> parse(String configuration) throws XPathExpressionException, XMLException {
        if (configuration == null) {
            return new ArrayList<Component>();
        }
        Document doc = this.xmlSupport.readXMLFromString(configuration);
        return this.parse(doc, "/cpacs/toolspecific/vampZero/components/component");
    }

    public List<Component> parse(InputStream stream) throws XPathExpressionException, XMLException {
        if (stream == null) {
            return new ArrayList<Component>();
        }
        Document doc = this.xmlSupport.readXMLFromStream(stream);
        return this.parse(doc, "/zeroGuiIn/component");
    }

    protected List<Component> parse(Document doc, String xpathPrefix) throws XPathExpressionException {
        ArrayList<Component> componentList = new ArrayList<Component>();
        ArrayList<Discipline> disciplineList = new ArrayList<Discipline>();
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        NodeList components = (NodeList)this.xpath.evaluate(xpathPrefix, doc.getDocumentElement(), XPathConstants.NODESET);
        int cn = components.getLength();
        int c = 0;
        while (c < cn) {
            Node component = components.item(c);
            String componentName = GuiInputParser.getNodeTextValue(component, NAME);
            NodeList disciplines = (NodeList)this.xpath.evaluate("disciplines/discipline", component, XPathConstants.NODESET);
            disciplineList.clear();
            int dn = disciplines.getLength();
            int d = 0;
            while (d < dn) {
                Node discipline = disciplines.item(d);
                String disciplineName = GuiInputParser.getNodeTextValue(discipline, NAME);
                NodeList parameters = (NodeList)this.xpath.evaluate("parameters/parameter", discipline, XPathConstants.NODESET);
                parameterList.clear();
                int pn = parameters.getLength();
                int p = 0;
                while (p < pn) {
                    Node parameter = parameters.item(p);
                    String parameterName = GuiInputParser.getNodeTextValue(parameter, NAME);
                    String parameterDescription = GuiInputParser.getNodeTextValue(parameter, "description");
                    String parameterValue = GuiInputParser.getNodeTextValue(parameter, "value");
                    String parameterFactor = GuiInputParser.getNodeTextValue(parameter, "factor");
                    Parameter newParameter = ((Parameter)new Parameter().setName(parameterName)).setDescription(parameterDescription).setValue(parameterValue).setFactor(parameterFactor);
                    parameterList.add(newParameter);
                    ++p;
                }
                Collections.sort(parameterList);
                Discipline newDiscipline = ((Discipline)new Discipline().setName(disciplineName)).setParameters(parameterList);
                disciplineList.add(newDiscipline);
                ++d;
            }
            Collections.sort(disciplineList);
            Component newComponent = ((Component)new Component().setName(componentName)).setDisciplines(disciplineList);
            componentList.add(newComponent);
            ++c;
        }
        Collections.sort(componentList);
        return componentList;
    }

    private static String getNodeTextValue(Node parentNode, String elementName) throws XPathExpressionException {
        NodeList nodes = parentNode.getChildNodes();
        int n = nodes.getLength();
        int i = 0;
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(elementName)) {
                return node.getTextContent().trim();
            }
            ++i;
        }
        return null;
    }
}

