/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.session.internal;

import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSession;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractUplinkSessionImpl
implements UplinkSession {
    private static final int VERY_SHORT_WAIT_MSEC = 50;
    private static final int OUTGOING_MESSAGE_QUEUE_SIZE = 5;
    private static final boolean DEBUG_OUTPUT_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.sessions");
    protected final AsyncOrderedExecutionQueue incomingMessageQueue;
    protected final AsyncOrderedExecutionQueue outgoingMessageQueue;
    protected final Log log = LogFactory.getLog(this.getClass());
    private UplinkSessionState state = UplinkSessionState.INITIAL;
    private String logDescriptor;
    private final CompletableFuture<String> assignedNamespaceIdFuture = new CompletableFuture();
    private final Semaphore outgoingMessageQueueLimit = new Semaphore(5);

    protected AbstractUplinkSessionImpl(ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        Objects.requireNonNull(concurrencyUtilsFactory);
        this.incomingMessageQueue = concurrencyUtilsFactory.createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
        this.outgoingMessageQueue = concurrencyUtilsFactory.createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    }

    @Override
    public synchronized UplinkSessionState getState() {
        return this.state;
    }

    @Override
    public final void enqueueMessageBlockForSending(long channelId, MessageBlock messageBlock) throws IOException {
        try {
            this.outgoingMessageQueueLimit.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting to enqueue a message of type " + (Object)((Object)messageBlock.getType()));
        }
        if (DEBUG_OUTPUT_ENABLED) {
            this.log.debug((Object)StringUtils.format((String)"Enqueueing message of type %s for sending to channel %d, payload size %d bytes", (Object[])new Object[]{messageBlock.getType(), channelId, messageBlock.getDataLength()}));
        }
        this.outgoingMessageQueue.enqueue(() -> {
            try {
                try {
                    this.getProtocolWrapper().sendMessageBlock(channelId, messageBlock);
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Error during asynchronous sending of message with type " + (Object)((Object)messageBlock.getType())));
                    this.outgoingMessageQueueLimit.release();
                }
            }
            finally {
                this.outgoingMessageQueueLimit.release();
            }
        });
    }

    @Override
    public final synchronized boolean isActive() {
        return this.state == UplinkSessionState.ACTIVE;
    }

    @Override
    public final String getAssignedNamespaceId() {
        String currentValue = this.assignedNamespaceIdFuture.getNow(null);
        if (currentValue != null) {
            return currentValue;
        }
        throw new IllegalStateException("Namespace id requested before it was available");
    }

    @Override
    public final Optional<String> getAssignedNamespaceIdIfAvailable() {
        return Optional.ofNullable(this.assignedNamespaceIdFuture.getNow(null));
    }

    @Override
    public final String getLogDescriptor() {
        return this.logDescriptor;
    }

    @Override
    public final String getDestinationIdPrefix() {
        return this.getAssignedNamespaceId();
    }

    public final String toString() {
        return this.logDescriptor;
    }

    protected final synchronized void setSessionState(UplinkSessionState newState) {
        switch (newState) {
            case CLIENT_HANDSHAKE_REQUEST_READY: 
            case SERVER_HANDSHAKE_RESPONSE_READY: 
            case PARTIALLY_CLOSED_BY_LOCAL: 
            case PARTIALLY_CLOSED_BY_REMOTE: {
                throw new IllegalArgumentException("The state " + (Object)((Object)newState) + " is managed by the base class and should not be set explicitly; " + "use the \"mark...\" methods to reach it");
            }
        }
        this.setStateInternal(newState);
    }

    protected final synchronized void markClientHandshakeSentOrReceived() {
        if (this.state != UplinkSessionState.INITIAL) {
            this.log.debug((Object)("Ignoring client handshake event as the session's state is " + (Object)((Object)this.state)));
            return;
        }
        this.setStateInternal(UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY);
    }

    protected final synchronized void markServerHandshakeSentOrReceived() {
        if (this.state != UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY) {
            this.log.debug((Object)("Ignoring server handshake event as the session's state is " + (Object)((Object)this.state)));
            return;
        }
        this.setStateInternal(UplinkSessionState.SERVER_HANDSHAKE_RESPONSE_READY);
    }

    protected final synchronized void markAsCloseRequestedLocally() {
        if (this.state == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR) {
            return;
        }
        if (this.state == UplinkSessionState.PARTIALLY_CLOSED_BY_REMOTE) {
            this.setStateInternal(UplinkSessionState.FULLY_CLOSED);
        } else if (this.state == UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL || this.state == UplinkSessionState.FULLY_CLOSED) {
            this.log.debug((Object)("Ignoring redundant request to mark session " + this.getLogDescriptor() + " as closed by a local event as its state is already " + (Object)((Object)this.state)));
        } else {
            this.setStateInternal(UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL);
        }
    }

    @Override
    public synchronized void markAsCloseRequestedByRemoteEvent() {
        if (this.state == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR) {
            return;
        }
        if (this.state == UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL) {
            this.setStateInternal(UplinkSessionState.FULLY_CLOSED);
        } else if (this.state == UplinkSessionState.PARTIALLY_CLOSED_BY_REMOTE) {
            this.log.warn((Object)("Ignoring redundant request to mark session " + this.getLogDescriptor() + " as closed by a remote event as its state is already " + (Object)((Object)this.state)));
        } else {
            this.setStateInternal(UplinkSessionState.PARTIALLY_CLOSED_BY_REMOTE);
        }
    }

    private void setStateInternal(UplinkSessionState newState) {
        UplinkSessionState oldState = this.state;
        if (newState == oldState) {
            this.log.warn((Object)("Ignoring redundant request to set the state of session " + this.getLogDescriptor() + " to " + (Object)((Object)newState)));
            return;
        }
        this.log.debug((Object)("State of session " + this.getLogDescriptor() + " is changing from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
        this.state = newState;
        this.onSessionStateChanged(oldState, newState);
    }

    protected abstract void onSessionStateChanged(UplinkSessionState var1, UplinkSessionState var2);

    protected abstract CommonUplinkLowLevelProtocolWrapper getProtocolWrapper();

    protected final void setAssignedNamespaceId(String serverAssignedNamespaceId) {
        this.assignedNamespaceIdFuture.complete(serverAssignedNamespaceId);
    }

    protected final void updateLogDescriptor() {
        String namespaceIdOrPlaceholder = this.assignedNamespaceIdFuture.getNow("<no namespace yet>");
        this.logDescriptor = StringUtils.format((String)"%s [%s]", (Object[])new Object[]{this.getLocalSessionId(), namespaceIdOrPlaceholder});
    }
}

