/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.channel.MessageChannelTrafficListener;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupState;
import de.rcenvironment.core.communication.management.CommunicationManagementService;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.routing.internal.NetworkFormatter;
import de.rcenvironment.core.communication.routing.internal.NetworkRoutingServiceImpl;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.communication.testutils.CommonVirtualInstanceControl;
import de.rcenvironment.core.communication.testutils.TestNetworkRequestHandler;
import de.rcenvironment.core.communication.testutils.VirtualCommunicationBundle;
import de.rcenvironment.core.communication.testutils.VirtualCommunicationBundleFactory;
import de.rcenvironment.core.communication.testutils.VirtualInstanceSkeleton;
import de.rcenvironment.core.communication.testutils.VirtualInstanceState;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class VirtualInstance
extends VirtualInstanceSkeleton
implements CommonVirtualInstanceControl {
    private static volatile boolean rememberRuntimePeersAfterRestart;
    private CommunicationManagementService managementService;
    private NetworkRoutingService networkRoutingService;
    private MessageRoutingService messageRoutingService;
    private MessageChannelService messageChannelService;
    private ConnectionSetupService connectionSetupService;
    private NodeConfigurationService nodeConfigurationService;
    private VirtualCommunicationBundle virtualCommunicationBundle = VirtualCommunicationBundleFactory.createFromNodeConfigurationService(this.getNodeConfigurationService());
    private CommunicationService communicationService;

    public VirtualInstance(String displayName) {
        this(displayName, true);
    }

    public VirtualInstance(String displayName, boolean isRelay) {
        this(null, displayName, isRelay);
    }

    public VirtualInstance(String predefinedInstanceId, String displayName, boolean isRelay) {
        super(predefinedInstanceId, displayName, isRelay);
        this.virtualCommunicationBundle.setAutoStartNetworkOnActivation(false);
        this.virtualCommunicationBundle.activate();
        this.nodeConfigurationService = this.virtualCommunicationBundle.getService(NodeConfigurationService.class);
        this.messageChannelService = this.virtualCommunicationBundle.getService(MessageChannelService.class);
        this.connectionSetupService = this.virtualCommunicationBundle.getService(ConnectionSetupService.class);
        this.networkRoutingService = this.virtualCommunicationBundle.getService(NetworkRoutingService.class);
        this.messageRoutingService = this.virtualCommunicationBundle.getService(MessageRoutingService.class);
        this.managementService = this.virtualCommunicationBundle.getService(CommunicationManagementService.class);
        this.communicationService = this.virtualCommunicationBundle.getService(CommunicationService.class);
        this.messageChannelService.registerRequestHandler("test", new TestNetworkRequestHandler(this.nodeConfigurationService.getInstanceNodeSessionId()));
    }

    public static void setRememberRuntimePeersAfterRestarts(boolean rememberRuntimePeers) {
        rememberRuntimePeersAfterRestart = rememberRuntimePeers;
    }

    public NetworkResponse performRoutedRequest(Serializable messageContent, String messageType, InstanceNodeSessionId targetNodeId) throws CommunicationException, InterruptedException, ExecutionException, SerializationException {
        byte[] serializedBody = MessageUtils.serializeObject(messageContent);
        return this.messageRoutingService.performRoutedRequest(serializedBody, messageType, targetNodeId);
    }

    public NetworkResponse performRoutedRequest(Serializable messageContent, InstanceNodeSessionId targetNodeId, int timeoutMsec) throws CommunicationException, InterruptedException, ExecutionException, TimeoutException, SerializationException {
        return this.performRoutedRequest(messageContent, "test", targetNodeId);
    }

    @Override
    public void addNetworkConnectionListener(MessageChannelLifecycleListener listener) {
        this.getMessageChannelService().addChannelLifecycleListener(listener);
    }

    @Override
    public void addNetworkTrafficListener(MessageChannelTrafficListener listener) {
        this.getMessageChannelService().addTrafficListener(listener);
    }

    @Override
    public void simulateCustomProtocolVersion(String version) {
        this.getService(MessageChannelService.class).overrideProtocolVersion(version);
    }

    @Override
    public synchronized void addInitialNetworkPeer(NetworkContactPoint contactPoint) {
        VirtualInstanceState currentState = this.getCurrentState();
        if (currentState == VirtualInstanceState.STARTED) {
            this.log.warn((Object)"addInitialNetworkPeer() called for an instance in the STARTED state; change to addRuntimeNetworkPeer()");
            this.connectAsync(contactPoint);
            return;
        }
        if (currentState != VirtualInstanceState.INITIAL) {
            throw new IllegalStateException("Initial peers can only be added in the INITIAL state");
        }
        super.addInitialNetworkPeer(contactPoint);
    }

    public synchronized ConnectionSetup connectAsync(NetworkContactPoint contactPoint) {
        if (this.getCurrentState() != VirtualInstanceState.STARTED) {
            throw new IllegalStateException("Runtime peers can only be added in the STARTED state (is " + (Object)((Object)this.getCurrentState()) + ")");
        }
        if (rememberRuntimePeersAfterRestart) {
            super.addInitialNetworkPeer(contactPoint);
        }
        ConnectionSetup connectionSetup = this.connectionSetupService.createConnectionSetup(contactPoint, null, true);
        connectionSetup.signalStartIntent();
        return connectionSetup;
    }

    public ConnectionSetup connectAndWait(NetworkContactPoint contactPoint, int timeoutMsec) throws TimeoutException, InterruptedException {
        ConnectionSetup connection = this.connectAsync(contactPoint);
        connection.awaitState(ConnectionSetupState.CONNECTED, timeoutMsec);
        return connection;
    }

    public void waitUntilContainsInReachableNodes(final InstanceNodeSessionId targetNodeId, int timeout) throws InterruptedException, TimeoutException {
        if (this.containsInReachableNodes(targetNodeId)) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        NetworkRoutingServiceImpl networkRoutingServiceImpl = (NetworkRoutingServiceImpl)this.networkRoutingService;
        NetworkTopologyChangeListenerAdapter topologyChangeListener = new NetworkTopologyChangeListenerAdapter(){

            @Override
            public void onReachableNodesChanged(Set<InstanceNodeSessionId> reachableNodes, Set<InstanceNodeSessionId> addedNodes, Set<InstanceNodeSessionId> removedNodes) {
                if (reachableNodes.contains(targetNodeId)) {
                    latch.countDown();
                }
            }
        };
        try {
            networkRoutingServiceImpl.addNetworkTopologyChangeListener(topologyChangeListener);
            if (this.containsInReachableNodes(targetNodeId)) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            this.log.debug((Object)StringUtils.format((String)"Node %s became reachable for node %s after waiting for %,d msec", (Object[])new Object[]{targetNodeId, this.getInstanceNodeSessionId(), System.currentTimeMillis() - startTime}));
        }
        finally {
            networkRoutingServiceImpl.removeNetworkTopologyChangeListener(topologyChangeListener);
        }
    }

    public boolean containsInReachableNodes(InstanceNodeSessionId targetNodeId) {
        Set<InstanceNodeSessionId> reachable = this.networkRoutingService.getReachableNetworkGraph().getNodeIds();
        return reachable.contains(targetNodeId);
    }

    @Deprecated
    public String getFormattedLegacyNetworkGraph() {
        return this.getFormattedRawNetworkGraph();
    }

    public String getFormattedRawNetworkGraph() {
        return NetworkFormatter.networkGraphToGraphviz(this.getRoutingService().getRawNetworkGraph(), true);
    }

    public String getFormattedReachableNetworkGraph() {
        return NetworkFormatter.networkGraphToGraphviz(this.getRoutingService().getReachableNetworkGraph(), true);
    }

    public String getFormattedLSAKnowledge() {
        StringBuilder buffer = new StringBuilder();
        Map<InstanceNodeSessionId, Map<String, String>> properties = this.getService(NodePropertiesService.class).getAllNodeProperties();
        buffer.append(StringUtils.format((String)"LSA properties as seen by %s (%d entries):", (Object[])new Object[]{this.getInstanceNodeSessionId(), properties.size()}));
        for (Map.Entry<InstanceNodeSessionId, Map<String, String>> entry : properties.entrySet()) {
            buffer.append(StringUtils.format((String)"\n  %s: %s", (Object[])new Object[]{entry.getKey(), entry.getValue().get("lsa")}));
        }
        return buffer.toString();
    }

    public String getFormattedNetworkStats() {
        return NetworkFormatter.networkStats(this.getRoutingService().getProtocolManager().getNetworkStats());
    }

    @Deprecated
    public boolean hasSameTopologyHashesForAllNodes() {
        throw new UnsupportedOperationException("Obsolete method");
    }

    public List<? extends NetworkGraphLink> getRouteTo(VirtualInstance destination) {
        return this.messageRoutingService.getRouteTo(destination.getInstanceNodeSessionId());
    }

    public NetworkGraph getRawNetworkGraph() {
        return this.networkRoutingService.getRawNetworkGraph();
    }

    public NetworkGraph getReachableNetworkGraph() {
        return this.networkRoutingService.getReachableNetworkGraph();
    }

    public int getKnownNodeCount() {
        return this.getReachableNetworkGraph().getNodeCount();
    }

    public boolean knownTopologyContainsLinkTo(VirtualInstance targetInstance) {
        return this.getReachableNetworkGraph().containsLinkBetween(this.getInstanceNodeSessionId(), targetInstance.getInstanceNodeSessionId());
    }

    @Deprecated
    public boolean checkMessageReceivedById(String messageId) {
        return this.networkRoutingService.getProtocolManager().messageReivedById(messageId);
    }

    @Deprecated
    public boolean checkMessageReceivedByContent(Serializable messageContent) {
        return this.networkRoutingService.getProtocolManager().messageReivedByContent(messageContent);
    }

    @Override
    public void registerNetworkTransportProvider(NetworkTransportProvider provider) {
        this.messageChannelService.addNetworkTransportProvider(provider);
    }

    public <T> T getService(Class<T> clazz) {
        return this.virtualCommunicationBundle.getService(clazz);
    }

    public <T> void injectService(Class<T> clazz, T implementation) {
        this.virtualCommunicationBundle.injectService(clazz, implementation);
    }

    public VirtualCommunicationBundle getVirtualCommunicationBundle() {
        return this.virtualCommunicationBundle;
    }

    public CommunicationManagementService getManagementService() {
        return this.managementService;
    }

    public CommunicationService getCommunicationService() {
        return this.communicationService;
    }

    public NetworkRoutingService getRoutingService() {
        return this.networkRoutingService;
    }

    public MessageChannelService getMessageChannelService() {
        return this.messageChannelService;
    }

    public NodeConfigurationService getConfigurationService() {
        return super.getNodeConfigurationService();
    }

    public ConnectionSetupService getConnectionSetupService() {
        return this.virtualCommunicationBundle.getService(ConnectionSetupService.class);
    }

    public NodePropertiesService getNodePropertiesService() {
        return this.virtualCommunicationBundle.getService(NodePropertiesService.class);
    }

    @Override
    protected void performStartup() throws InterruptedException, CommunicationException {
        this.managementService.startUpNetwork();
    }

    @Override
    protected void performShutdown() throws InterruptedException {
        this.managementService.shutDownNetwork();
    }

    @Override
    protected void performSimulatedCrash() throws InterruptedException {
        this.managementService.simulateUncleanShutdown();
    }

    public InstanceNodeId getPersistentInstanceNodeId() {
        return this.getInstanceNodeSessionId().convertToInstanceNodeId();
    }

    public InstanceNodeSessionId getInstanceNodeSessionId() {
        return this.nodeInformation.getInstanceNodeSessionId();
    }

    public String getInstanceNodeSessionIdString() {
        return this.nodeInformation.getInstanceNodeSessionId().getInstanceNodeSessionIdString();
    }

    public String toString() {
        return this.getInstanceNodeSessionId().toString();
    }

    public NetworkContactPoint getDefaultContactPoint() {
        List<NetworkContactPoint> serverContactPoints = this.getConfigurationService().getServerContactPoints();
        if (serverContactPoints.isEmpty()) {
            throw new IllegalStateException("No server contact points configured");
        }
        return serverContactPoints.get(0);
    }
}

