/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.internal;

import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.internal.DefaultTypedDatumFactory;
import de.rcenvironment.core.datamodel.internal.TypedDatumConversionTable;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DateTimeTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.datamodel.types.internal.MatrixTDImpl;
import de.rcenvironment.core.datamodel.types.internal.SmallTableTDImpl;
import de.rcenvironment.core.utils.common.StringUtils;

public class DefaultTypedDatumConverter
implements TypedDatumConverter {
    private static final String STRING_CAN_NOT_CONVERT = "Can not convert from %s to %s";
    private static DefaultTypedDatumFactory factory = new DefaultTypedDatumFactory();

    @Override
    public <T extends TypedDatum> T castOrConvert(TypedDatum input, Class<T> targetClass) throws DataTypeException {
        return (T)this.castOrConvert(input, DataType.byTDClass(targetClass));
    }

    @Override
    public TypedDatum castOrConvert(TypedDatum input, DataType targetType) throws DataTypeException {
        DataType inputType = input.getDataType();
        if (inputType.equals((Object)targetType)) {
            return input;
        }
        if (!this.isConvertibleTo(input, targetType)) {
            throw new DataTypeException(StringUtils.format((String)STRING_CAN_NOT_CONVERT, (Object[])new Object[]{input.getDataType().toString(), targetType.toString()}));
        }
        if (targetType.equals((Object)DataType.SmallTable)) {
            switch (inputType) {
                case Vector: 
                case Matrix: {
                    break;
                }
                default: {
                    SmallTableTD smallTable = factory.createSmallTable(1, 1);
                    smallTable.setTypedDatumForCell(input, 0, 0);
                    return smallTable;
                }
            }
        }
        switch (inputType) {
            case Boolean: {
                BooleanTD boolDatum = (BooleanTD)input;
                if (boolDatum.getBooleanValue()) {
                    return this.castOrConvert((TypedDatum)factory.createInteger(1L), targetType);
                }
                return this.castOrConvert((TypedDatum)factory.createInteger(0L), targetType);
            }
            case Integer: {
                IntegerTD integerDatum = (IntegerTD)input;
                return this.castOrConvert((TypedDatum)factory.createFloat(integerDatum.getIntValue()), targetType);
            }
            case Float: {
                FloatTD floatDatum = (FloatTD)input;
                VectorTD vector = factory.createVector(1);
                vector.setFloatTDForElement(floatDatum, 0);
                return this.castOrConvert((TypedDatum)vector, targetType);
            }
            case Vector: {
                VectorTD vectorDatum = (VectorTD)input;
                FloatTD[][] matrixEntries = new FloatTD[vectorDatum.getRowDimension()][1];
                int i = 0;
                while (i < vectorDatum.getRowDimension()) {
                    matrixEntries[i][0] = vectorDatum.getFloatTDOfElement(i);
                    ++i;
                }
                return this.castOrConvert((TypedDatum)new MatrixTDImpl(matrixEntries), targetType);
            }
            case Matrix: {
                MatrixTD matrixDatum = (MatrixTD)input;
                return this.castOrConvert((TypedDatum)new SmallTableTDImpl(matrixDatum.toArray()), targetType);
            }
            case DateTime: {
                IntegerTD integer = factory.createInteger(((DateTimeTD)input).getDateTimeInMilliseconds());
                return this.castOrConvert((TypedDatum)integer, targetType);
            }
        }
        throw new DataTypeException(StringUtils.format((String)STRING_CAN_NOT_CONVERT, (Object[])new Object[]{inputType.toString(), targetType.toString()}));
    }

    @Override
    public boolean isConvertibleTo(TypedDatum input, Class<? extends TypedDatum> targetType) {
        return this.isConvertibleTo(input, DataType.byTDClass(targetType));
    }

    @Override
    public boolean isConvertibleTo(TypedDatum input, DataType targetType) {
        return TypedDatumConversionTable.getTable()[TypedDatumConversionTable.getIndexOfType(input.getDataType())][TypedDatumConversionTable.getIndexOfType(targetType)] == 0;
    }

    @Override
    public boolean isConvertibleTo(DataType sourceType, DataType targetType) {
        return TypedDatumConversionTable.getTable()[TypedDatumConversionTable.getIndexOfType(sourceType)][TypedDatumConversionTable.getIndexOfType(targetType)] == 0;
    }

    @Override
    public <T extends TypedDatum> T castOrConvertUnsafe(TypedDatum input, Class<T> targetClass) throws DataTypeException {
        return (T)this.castOrConvertUnsafe(input, DataType.byTDClass(targetClass));
    }

    @Override
    public TypedDatum castOrConvertUnsafe(TypedDatum input, DataType targetType) throws DataTypeException {
        DataType inputType = input.getDataType();
        if (inputType.equals((Object)targetType)) {
            return input;
        }
        if (!this.isUnsafeConvertibleTo(input, targetType)) {
            throw new DataTypeException(StringUtils.format((String)STRING_CAN_NOT_CONVERT, (Object[])new Object[]{inputType.toString(), targetType.toString()}));
        }
        switch (inputType) {
            case Empty: {
                return factory.createShortText("");
            }
            case Boolean: {
                return factory.createShortText(input.toString());
            }
            case Integer: {
                return factory.createShortText(input.toString());
            }
            case Float: {
                return factory.createShortText(input.toString());
            }
        }
        throw new DataTypeException(StringUtils.format((String)STRING_CAN_NOT_CONVERT, (Object[])new Object[]{inputType.toString(), targetType.toString()}));
    }

    @Override
    public boolean isUnsafeConvertibleTo(TypedDatum input, Class<? extends TypedDatum> targetType) {
        return this.isUnsafeConvertibleTo(input, DataType.byTDClass(targetType));
    }

    @Override
    public boolean isUnsafeConvertibleTo(TypedDatum input, DataType targetType) {
        return TypedDatumConversionTable.getTable()[TypedDatumConversionTable.getIndexOfType(input.getDataType())][TypedDatumConversionTable.getIndexOfType(targetType)] == 2;
    }

    @Override
    public boolean isUnsafeConvertibleTo(DataType sourceType, DataType targetType) {
        return TypedDatumConversionTable.getTable()[TypedDatumConversionTable.getIndexOfType(sourceType)][TypedDatumConversionTable.getIndexOfType(targetType)] == 2;
    }
}

