/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class ComponentStepDefinitions
extends InstanceManagementStepDefinitionBase {
    public ComponentStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Given(value="^adding(?: tool[s]?)? \"([^\"]+)\" to( all)?(?: instance[s]?)?(?: \"([^\"]+)\")?$")
    public void givenAddingTools(String tools, String allFlag, String instanceIds) throws Throwable {
        AddToolIterator addToolIterator = new AddToolIterator(tools);
        this.iterateInstances(addToolIterator, allFlag, instanceIds);
    }

    @When(value="^removing(?: tool[s]?)? \"([^\"]+)\"(?: from)?( all)?(?: instance[s]?)?(?: \"([^\"]+)\")?$")
    public void whenRemovingTools(String tools, String allFlag, String instanceIds) throws Throwable {
        RemoveToolIterator removeToolIterator = new RemoveToolIterator(tools);
        this.iterateInstances(removeToolIterator, allFlag, instanceIds);
    }

    @Then(value="^instance \"([^\"]*)\" should see these components:$")
    public void thenInstanceSeesComponents(String instanceId, DataTable componentsTable) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        HashMap<String, ComponentVisibilityState> visibilityMap = new HashMap<String, ComponentVisibilityState>();
        for (List criteriaRow : componentsTable.cells(0)) {
            String argNodeName = (String)criteriaRow.get(0);
            String argCompName = (String)criteriaRow.get(1);
            String expectedState = (String)criteriaRow.get(2);
            String mapKey = String.valueOf(argNodeName) + "/" + argCompName;
            ComponentVisibilityState entry = new ComponentVisibilityState(argCompName, argNodeName, expectedState, null);
            visibilityMap.put(mapKey, entry);
            this.log.debug((Object)("Parsed component expectation: " + entry));
        }
        String output = this.executeCommandOnInstance(instance, "components list --as-table --auth", false);
        String[] stringArray = output.split("\n");
        int argCompName = stringArray.length;
        int argNodeName = 0;
        while (argNodeName < argCompName) {
            String trimmedLine;
            String line = stringArray[argNodeName];
            if (!line.startsWith("Finished executing command") && !(trimmedLine = line.trim()).isEmpty()) {
                String[] lineParts = trimmedLine.split("\\|");
                if (lineParts.length != 6) {
                    this.log.error((Object)("Ignoring output line with unexpected number of elements: " + line));
                } else {
                    String componentRefName = lineParts[2];
                    String nodeName = lineParts[0];
                    String actualState = lineParts[5];
                    String mapKey = String.valueOf(nodeName) + "/" + componentRefName;
                    ComponentVisibilityState existing = (ComponentVisibilityState)visibilityMap.get(mapKey);
                    if (existing != null) {
                        existing.setActualState(actualState);
                    }
                }
            }
            ++argNodeName;
        }
        boolean hasMismatch = false;
        StringBuilder errorLines = new StringBuilder();
        for (ComponentVisibilityState entry : visibilityMap.values()) {
            if (entry.stateMatches()) continue;
            String errorLine = "  Unexpected component state: " + entry;
            errorLines.append("\n");
            errorLines.append(errorLine);
            this.printToCommandConsole(errorLine);
            hasMismatch = true;
        }
        if (hasMismatch) {
            Assert.fail((String)("At least one component had an unexpected visibility/authorization state: " + errorLines.toString()));
        }
    }

    private class AddToolIterator
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String toolList;

        AddToolIterator(String toolList) {
            this.toolList = toolList;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws IOException {
            for (String tool : ComponentStepDefinitions.this.parseCommaSeparatedList(this.toolList)) {
                ComponentStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"Adding tool %s to instance %s", (Object[])new Object[]{tool, instance}));
                File toolFile = instance.getAbsolutePathFromRelative(StringUtils.format((String)"integration/tools/%s", (Object[])new Object[]{tool}));
                if (toolFile.exists()) {
                    FileUtils.cleanDirectory((File)toolFile);
                } else {
                    toolFile.mkdir();
                }
                File testToolTemplateDir = Paths.get(ComponentStepDefinitions.this.executionContext.getTestScriptLocation().toString(), "tools", tool).toFile();
                FileUtils.copyDirectory((File)testToolTemplateDir, (File)toolFile);
            }
        }
    }

    private class ComponentVisibilityState {
        private String componentName;
        private String nodeName;
        private String expectedState;
        private String actualState;

        ComponentVisibilityState(String componentName, String nodeName, String expectedState, String actualState) {
            this.componentName = componentName;
            this.nodeName = nodeName;
            this.setExpectedState(expectedState);
            this.setActualState(actualState);
        }

        public void setExpectedState(String expectedState) {
            this.expectedState = Optional.ofNullable(expectedState).orElse("(absent)");
        }

        public void setActualState(String actualState) {
            this.actualState = Optional.ofNullable(actualState).orElse("(absent)");
        }

        public boolean stateMatches() {
            return this.expectedState.equals(this.actualState);
        }

        public String toString() {
            return StringUtils.format((String)"%s | %s | expected: %s | found: %s", (Object[])new Object[]{this.nodeName, this.componentName, this.expectedState, this.actualState});
        }
    }

    private class RemoveToolIterator
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String toolList;

        RemoveToolIterator(String toolList) {
            this.toolList = toolList;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws Throwable {
            for (String tool : ComponentStepDefinitions.this.parseCommaSeparatedList(this.toolList)) {
                ComponentStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"Removing tool %s from instance %s", (Object[])new Object[]{tool, instance}));
                File toolFile = instance.getAbsolutePathFromRelative(StringUtils.format((String)"integration/tools/%s", (Object[])new Object[]{tool}));
                if (!toolFile.exists()) continue;
                FileUtils.cleanDirectory((File)toolFile);
            }
        }
    }
}

