/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderPageTreeFactory;
import de.rcenvironment.core.gui.workflow.execute.WorkflowPageClearHistoryDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PlaceholderPage
extends WizardPage {
    private static final Color COLOR_WHITE = Display.getCurrent().getSystemColor(1);
    static final Color COLOR_RED = Display.getCurrent().getSystemColor(3);
    private static final int SHORTTEXT_MAXLENGTH = 140;
    private final WorkflowDescription workflowDescription;
    private WorkflowPlaceholderHandler placeholderHelper;
    private Tree componentPlaceholderTree;
    private Map<Integer, Control> controlMap;
    private Map<Integer, Button> saveButtonMap;
    private Map<Integer, String> treeItemNameToPlaceholder;
    private Map<Integer, String> treeItemToUUIDMap;
    private final Map<String, Set<String>> placeholderValidators = new HashMap<String, Set<String>>();

    public PlaceholderPage(WorkflowDescription workflowDescription) {
        super(Messages.workflowPageName);
        this.workflowDescription = workflowDescription;
        this.setTitle(Messages.workflowPageTitle);
        this.setDescription(Messages.configure);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)comp);
        IPreferenceStore prefs = Activator.getInstance().getPreferenceStore();
        String placeholderPersistentSettingsUUID = prefs.getString("placeholder_UUID");
        if (placeholderPersistentSettingsUUID.isEmpty()) {
            placeholderPersistentSettingsUUID = UUID.randomUUID().toString();
            prefs.putValue("placeholder_UUID", placeholderPersistentSettingsUUID);
        }
        this.placeholderHelper = WorkflowPlaceholderHandler.createPlaceholderDescriptionFromWorkflowDescription((WorkflowDescription)this.workflowDescription, (String)placeholderPersistentSettingsUUID);
        this.addPlaceholderGroup(comp);
        Button clearHistoryButton = new Button(comp, 0);
        clearHistoryButton.setText(Messages.clearHistoryButton);
        clearHistoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkflowPageClearHistoryDialog chd = new WorkflowPageClearHistoryDialog(PlaceholderPage.this.getShell(), Messages.clearHistoryDialogTitle, PlaceholderPage.this.placeholderHelper, PlaceholderPage.this.workflowDescription);
                chd.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.placeholderHelper.getIdentifiersOfPlaceholderContainingComponents().size() == 0) {
            clearHistoryButton.setEnabled(false);
        }
    }

    private void addPlaceholderGroup(Composite container) {
        this.controlMap = new HashMap<Integer, Control>();
        this.saveButtonMap = new HashMap<Integer, Button>();
        this.treeItemNameToPlaceholder = new HashMap<Integer, String>();
        this.treeItemToUUIDMap = new HashMap<Integer, String>();
        Group placeholderInformationGroup = new Group(container, 0);
        placeholderInformationGroup.setText(Messages.placeholderInformationHeader);
        placeholderInformationGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        placeholderInformationGroup.setLayoutData((Object)gridData);
        PlaceholderPageTreeFactory treeFactory = new PlaceholderPageTreeFactory(this, this.placeholderHelper, placeholderInformationGroup);
        treeFactory.fillTree();
        this.componentPlaceholderTree = treeFactory.getTree();
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final TreeItem treeItem = (TreeItem)e.item;
                PlaceholderPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeItem.getParent().getColumn(0).pack();
                        treeItem.getParent().getColumn(0).setWidth(treeItem.getParent().getColumn(0).getWidth() + 10);
                    }
                });
            }
        };
        this.componentPlaceholderTree.addListener(18, listener);
        this.componentPlaceholderTree.addListener(17, listener);
        this.deleteEmptyTreeItems();
        this.openItems();
        this.componentPlaceholderTree.getColumn(0).pack();
        this.componentPlaceholderTree.getColumn(0).setWidth(this.componentPlaceholderTree.getColumn(0).getWidth() + 10);
    }

    private void deleteEmptyTreeItems() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem tItem = treeItemArray[n2];
            int itemCount = 0;
            TreeItem[] treeItemArray2 = tItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem childItem = treeItemArray2[n4];
                ++itemCount;
                if (childItem.getItemCount() > 0) {
                    itemCount += childItem.getItemCount();
                } else if (this.treeItemNameToPlaceholder.containsKey(tItem.hashCode())) {
                    ++itemCount;
                } else {
                    childItem.dispose();
                    --itemCount;
                }
                ++n4;
            }
            if (itemCount <= 1) {
                tItem.dispose();
            }
            ++n2;
        }
    }

    private void openItems() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem parent = treeItemArray[n2];
            TreeItem[] treeItemArray2 = parent.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem secondLevel = treeItemArray2[n4];
                if (secondLevel.getItemCount() == 0) {
                    Control control = this.controlMap.get(secondLevel.hashCode());
                    if (control instanceof Text) {
                        Text cfr_ignored_0 = (Text)control;
                        parent.setExpanded(true);
                    }
                } else {
                    TreeItem[] treeItemArray3 = secondLevel.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem thirdLevel = treeItemArray3[n6];
                        Control control = this.controlMap.get(thirdLevel.hashCode());
                        if (control instanceof Text) {
                            Text cfr_ignored_1 = (Text)control;
                            parent.setExpanded(true);
                            secondLevel.setExpanded(true);
                        } else if (control instanceof Combo) {
                            Combo cfr_ignored_2 = (Combo)control;
                            parent.setExpanded(true);
                            secondLevel.setExpanded(true);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    void addSaveButton(TreeItem item, Text placeholderText) {
        TreeEditor checkButton = new TreeEditor(item.getParent());
        checkButton.horizontalAlignment = 16384;
        checkButton.grabHorizontal = true;
        Button checkForSaveButton = new Button((Composite)item.getParent(), 32);
        checkForSaveButton.setText("Save");
        checkButton.minimumWidth = checkForSaveButton.getSize().x;
        checkButton.setEditor((Control)checkForSaveButton, item, 2);
        this.saveButtonMap.put(item.hashCode(), checkForSaveButton);
        if (placeholderText.getText() != null && !placeholderText.getText().equals("")) {
            checkForSaveButton.setSelection(true);
        }
    }

    void placeApplyToAllButtonsWhereNecessary(Tree baseTree) {
        Map placeholderDataTypes = this.placeholderHelper.getPlaceholdersDataType();
        TreeItem[] treeItemArray = baseTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentTree = treeItemArray[n2];
            ArrayList<ExtendedTreeItem> componentKeyValues = new ArrayList<ExtendedTreeItem>();
            TreeItem[] treeItemArray2 = componentTree.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem instanceItem = treeItemArray2[n4];
                TreeItem[] treeItemArray3 = instanceItem.getItems();
                int n5 = treeItemArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem keyValue = treeItemArray3[n6];
                    String placeholderKey = String.valueOf(instanceItem.getText()) + "." + this.treeItemNameToPlaceholder.get(keyValue.hashCode());
                    String dataType = placeholderDataTypes.getOrDefault(placeholderKey, "text");
                    componentKeyValues.add(new ExtendedTreeItem(keyValue, dataType));
                    ++n6;
                }
                ++n4;
            }
            Map groupedTreeItems = componentKeyValues.stream().collect(Collectors.groupingBy(extendedItem -> extendedItem.treeItem.getText(), Collectors.groupingBy(extendedItem -> extendedItem.dataType, Collectors.toSet())));
            for (Map treeItemGroupByPlaceholderName : groupedTreeItems.values()) {
                for (Set treeItemGroup : treeItemGroupByPlaceholderName.values()) {
                    if (treeItemGroup.size() <= 1) continue;
                    for (ExtendedTreeItem equivalentTreeItem : treeItemGroup) {
                        this.addApplyToAllButton(equivalentTreeItem, componentKeyValues);
                    }
                }
            }
            ++n2;
        }
    }

    void addPlaceholderValidator(String componentName, String placeholderName) {
        Set<String> placeholderNames = this.placeholderValidators.get(componentName);
        if (placeholderNames == null) {
            placeholderNames = new HashSet<String>();
        }
        placeholderNames.add(placeholderName);
        this.placeholderValidators.put(componentName, placeholderNames);
    }

    private void removePlaceholderValidator(String componentName, String placeholderName) {
        Set<String> placeholderNames = this.placeholderValidators.get(componentName);
        placeholderNames.remove(placeholderName);
        if (placeholderNames.isEmpty()) {
            this.placeholderValidators.remove(componentName);
        }
    }

    private void addApplyToAllButton(ExtendedTreeItem extendedTreeItem, List<ExtendedTreeItem> allItems) {
        TreeEditor buttonEditor = new TreeEditor(extendedTreeItem.treeItem.getParent());
        buttonEditor.horizontalAlignment = 16384;
        buttonEditor.grabHorizontal = true;
        Button placeholderButton = new Button((Composite)extendedTreeItem.treeItem.getParent(), 8);
        placeholderButton.setToolTipText(Messages.applyToAllToolTip);
        placeholderButton.setText(Messages.applyToAll);
        placeholderButton.setSize(placeholderButton.getText().length() * 6, 0);
        placeholderButton.computeSize(-1, extendedTreeItem.treeItem.getParent().getItemHeight());
        placeholderButton.addSelectionListener((SelectionListener)new ButtonListener(extendedTreeItem, allItems));
        buttonEditor.minimumWidth = placeholderButton.getSize().x;
        buttonEditor.setEditor((Control)placeholderButton, extendedTreeItem.treeItem, 3);
    }

    void addFileChooser(TreeItem item, final String dataType, final Text placeholderText) {
        TreeEditor pathButtonEditor = new TreeEditor(item.getParent());
        pathButtonEditor.horizontalAlignment = 16384;
        pathButtonEditor.grabHorizontal = true;
        Button pathChooserButton = new Button((Composite)item.getParent(), 8);
        pathChooserButton.setText("...");
        pathChooserButton.setSize(pathChooserButton.getText().length() * 6, 0);
        pathChooserButton.computeSize(-1, item.getParent().getItemHeight());
        pathButtonEditor.minimumWidth = pathChooserButton.getSize().x;
        pathChooserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String selectedPath = dataType.equals("dir") ? PropertyTabGuiHelper.selectDirectoryFromFileSystemWithPath((Shell)PlaceholderPage.this.getShell(), (String)"Open path...", (String)placeholderText.getText()) : PropertyTabGuiHelper.selectFileFromFileSystem((Shell)PlaceholderPage.this.getShell(), (String[])new String[0], (String)"Open path...", (String)placeholderText.getText());
                if (selectedPath != null) {
                    placeholderText.setText(selectedPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        pathButtonEditor.setEditor((Control)pathChooserButton, item, 2);
    }

    private String getControlText(int id) {
        Control control = this.controlMap.get(id);
        String text = null;
        if (control instanceof Text) {
            Text current = (Text)control;
            text = current.getText();
        } else if (control instanceof Combo) {
            Combo current = (Combo)control;
            text = current.getText();
        }
        return text;
    }

    protected Control getControl(int id) {
        return this.controlMap.get(id);
    }

    static boolean isTextEmpty(Text source) {
        return source.getText() == null || source.getText().equals("");
    }

    protected void validateInput(Text source, String componentName, String placeholderName, boolean isShorttext) {
        if ((!PlaceholderPage.isTextEmpty(source) || isShorttext) && source.getText().length() <= 140) {
            if (source.getBackground().equals((Object)COLOR_RED)) {
                source.setBackground(COLOR_WHITE);
                this.removePlaceholderValidator(componentName, placeholderName);
            }
        } else {
            source.setBackground(COLOR_RED);
            this.addPlaceholderValidator(componentName, placeholderName);
        }
    }

    public boolean validateErrors() {
        return !this.placeholderValidators.isEmpty();
    }

    public int getErrorAmount() {
        return this.placeholderValidators.size();
    }

    public Map<String, String> getComponentNamesWithError(boolean indicator) {
        Set<String> componentNames = this.placeholderValidators.keySet();
        HashMap<String, String> newComponentNames = new HashMap<String, String>();
        for (String name : componentNames) {
            String additionalInfos = "";
            if (indicator) {
                additionalInfos = " " + Messages.missingPlaceholder;
            }
            newComponentNames.put(name, additionalInfos);
        }
        return newComponentNames;
    }

    protected void performFinish() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentItems = treeItemArray[n2];
            TreeItem[] treeItemArray2 = componentItems.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem componentIDItems = treeItemArray2[n4];
                if (componentIDItems.getItemCount() == 0) {
                    for (String fullPlaceholder : this.placeholderHelper.getPlaceholderOfComponent(this.getComponentIDByName(componentItems.getText()))) {
                        if (!WorkflowPlaceholderHandler.getNameOfPlaceholder((String)fullPlaceholder).equals(this.treeItemNameToPlaceholder.get(componentIDItems.hashCode()))) continue;
                        boolean addToHistory = true;
                        if (this.saveButtonMap.get(componentIDItems.hashCode()) != null) {
                            addToHistory = this.saveButtonMap.get(componentIDItems.hashCode()).getSelection();
                        }
                        this.placeholderHelper.setGlobalPlaceholderValue(fullPlaceholder, this.getComponentIDByName(componentItems.getText()), this.getControlText(componentIDItems.hashCode()), this.workflowDescription.getIdentifier(), addToHistory);
                    }
                } else {
                    TreeItem[] treeItemArray3 = componentIDItems.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem instancePlaceholderItems = treeItemArray3[n6];
                        for (String fullPlaceholder : this.placeholderHelper.getPlaceholderNamesOfComponentInstance(this.treeItemToUUIDMap.get(instancePlaceholderItems.hashCode()))) {
                            if (!WorkflowPlaceholderHandler.getNameOfPlaceholder((String)fullPlaceholder).equals(this.treeItemNameToPlaceholder.get(instancePlaceholderItems.hashCode()))) continue;
                            boolean addToHistory = true;
                            if (this.saveButtonMap.get(instancePlaceholderItems.hashCode()) != null) {
                                addToHistory = this.saveButtonMap.get(instancePlaceholderItems.hashCode()).getSelection();
                            }
                            this.placeholderHelper.setPlaceholderValue(fullPlaceholder, this.getComponentIDByName(componentIDItems.getText()), this.treeItemToUUIDMap.get(instancePlaceholderItems.hashCode()), this.getControlText(instancePlaceholderItems.hashCode()), this.workflowDescription.getIdentifier(), addToHistory);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void savePlaceholdersToPersistentSettings() {
        IPreferenceStore prefs;
        String placeholderPersistentSettingsUUID;
        if (WorkflowPlaceholderHandler.getPlaceholderPersistentSettingsUUID() == null && (placeholderPersistentSettingsUUID = (prefs = Activator.getInstance().getPreferenceStore()).getString("placeholder_UUID")).isEmpty()) {
            WorkflowPlaceholderHandler.setPlaceholderPersistentSettingsUUID((String)UUID.randomUUID().toString());
            prefs.putValue("placeholder_UUID", placeholderPersistentSettingsUUID);
        }
        this.placeholderHelper.saveHistory();
    }

    protected Map<String, Map<String, String>> getPlaceholders() {
        HashMap<String, Map<String, String>> placeholdersMap = new HashMap<String, Map<String, String>>();
        for (WorkflowNode wn : this.workflowDescription.getWorkflowNodes()) {
            Map compInstPlaceholders;
            HashMap placeholders = new HashMap();
            Map compTypePlaceholders = this.placeholderHelper.getPlaceholdersOfComponentType(wn.getComponentDescription().getIdentifier());
            if (compTypePlaceholders != null) {
                placeholders.putAll(compTypePlaceholders);
            }
            if ((compInstPlaceholders = this.placeholderHelper.getPlaceholdersOfComponentInstance(wn.getIdentifier())) != null) {
                placeholders.putAll(compInstPlaceholders);
            }
            placeholdersMap.put(wn.getIdentifier(), placeholders);
        }
        return placeholdersMap;
    }

    String getComponentIDByName(String name) {
        for (WorkflowNode wn : this.workflowDescription.getWorkflowNodes()) {
            if (!wn.getName().equals(name)) continue;
            return wn.getComponentDescription().getIdentifier();
        }
        return null;
    }

    public Map<String, Set<String>> getPlaceholderValidators() {
        return this.placeholderValidators;
    }

    protected boolean canFinish() {
        if (this.componentPlaceholderTree != null) {
            return this.componentPlaceholderTree.getItemCount() == 0;
        }
        return false;
    }

    public void dispose() {
        for (Integer key : this.controlMap.keySet()) {
            this.controlMap.get(key).dispose();
        }
        this.componentPlaceholderTree.dispose();
        super.dispose();
    }

    public void putIntoControlMap(TreeItem item, Control control) {
        this.controlMap.put(item.hashCode(), control);
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    public WorkflowNode getWorkflowNode(WorkflowNodeIdentifier wfNodeID) {
        return this.workflowDescription.getWorkflowNode(wfNodeID);
    }

    public String getWorkflowIdentifier() {
        return this.workflowDescription.getIdentifier();
    }

    public void setWorkflowNodeIDForTreeItem(TreeItem treeItem, WorkflowNodeIdentifier wfNodeID) {
        this.treeItemToUUIDMap.put(treeItem.hashCode(), wfNodeID.toString());
    }

    public WorkflowNodeIdentifier getWorkflowNodeIDForTreeItem(TreeItem treeItem) {
        return new WorkflowNodeIdentifier(this.treeItemToUUIDMap.get(treeItem.hashCode()));
    }

    public void setPlaceholderForTreeItem(TreeItem treeItem, String placeholder) {
        this.treeItemNameToPlaceholder.put(treeItem.hashCode(), placeholder);
    }

    public String getPlaceholderForTreeItem(TreeItem item) {
        return this.treeItemNameToPlaceholder.get(item.hashCode());
    }

    public String getPlaceholderDataType(String wfNodeName, String placeholderName) {
        return (String)this.placeholderHelper.getPlaceholdersDataType().get(String.valueOf(wfNodeName) + "." + placeholderName);
    }

    private class ButtonListener
    extends SelectionAdapter {
        private ExtendedTreeItem extendedTreeItem;
        private List<ExtendedTreeItem> allItems;

        ButtonListener(ExtendedTreeItem extendedTreeItem, List<ExtendedTreeItem> allItems) {
            this.extendedTreeItem = extendedTreeItem;
            this.allItems = allItems;
        }

        public void widgetSelected(SelectionEvent event) {
            Control treeItemControl = PlaceholderPage.this.getControl(this.extendedTreeItem.treeItem.hashCode());
            String valueToBeCoppied = null;
            if (treeItemControl instanceof Text) {
                valueToBeCoppied = ((Text)treeItemControl).getText();
            } else if (treeItemControl instanceof Combo) {
                valueToBeCoppied = ((Combo)treeItemControl).getText();
            }
            if (valueToBeCoppied != null && !valueToBeCoppied.isEmpty()) {
                int i = 0;
                while (i < this.allItems.size()) {
                    if (this.extendedTreeItem.treeItem.getText().equals(this.allItems.get((int)i).treeItem.getText())) {
                        Control toReplaceItem;
                        if (this.extendedTreeItem.dataType == null && this.allItems.get((int)i).dataType == null) {
                            toReplaceItem = PlaceholderPage.this.getControl(this.allItems.get((int)i).treeItem.hashCode());
                            if (toReplaceItem instanceof Text) {
                                ((Text)toReplaceItem).setText(valueToBeCoppied);
                            } else if (toReplaceItem instanceof Combo) {
                                ((Combo)toReplaceItem).select(((Combo)treeItemControl).indexOf(valueToBeCoppied));
                            }
                        } else if (this.extendedTreeItem.dataType.equals(this.allItems.get((int)i).dataType)) {
                            toReplaceItem = PlaceholderPage.this.getControl(this.allItems.get((int)i).treeItem.hashCode());
                            if (toReplaceItem instanceof Text) {
                                ((Text)toReplaceItem).setText(valueToBeCoppied);
                            } else if (toReplaceItem instanceof Combo) {
                                ((Combo)toReplaceItem).select(((Combo)treeItemControl).indexOf(valueToBeCoppied));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private final class ExtendedTreeItem {
        public final TreeItem treeItem;
        public final String dataType;

        ExtendedTreeItem(TreeItem treeItem, String dataType) {
            Objects.requireNonNull(treeItem);
            Objects.requireNonNull(dataType);
            this.treeItem = treeItem;
            this.dataType = dataType;
        }
    }
}

