/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.cache.BackgroundCleaner;
import org.apache.derby.impl.services.cache.CacheEntry;
import org.apache.derby.impl.services.cache.ClockPolicy;
import org.apache.derby.impl.services.cache.ReplacementPolicy;

final class ConcurrentCache
implements CacheManager {
    private final ConcurrentHashMap<Object, CacheEntry> cache;
    private final CacheableFactory holderFactory;
    private final String name;
    private final int maxSize;
    private final ReplacementPolicy replacementPolicy;
    private volatile boolean stopped;
    private BackgroundCleaner cleaner;

    ConcurrentCache(CacheableFactory cacheableFactory, String string, int n, int n2) {
        this.cache = new ConcurrentHashMap(n);
        this.replacementPolicy = new ClockPolicy(this, n, n2);
        this.holderFactory = cacheableFactory;
        this.name = string;
        this.maxSize = n2;
    }

    ReplacementPolicy getReplacementPolicy() {
        return this.replacementPolicy;
    }

    private CacheEntry getEntry(Object object) {
        CacheEntry cacheEntry;
        CacheEntry cacheEntry2 = this.cache.get(object);
        while (true) {
            if (cacheEntry2 != null) {
                cacheEntry2.lock();
                cacheEntry2.waitUntilIdentityIsSet();
                if (cacheEntry2.isValid()) {
                    return cacheEntry2;
                }
                cacheEntry2.unlock();
                cacheEntry2 = this.cache.get(object);
                continue;
            }
            cacheEntry = new CacheEntry();
            cacheEntry.lock();
            CacheEntry cacheEntry3 = this.cache.putIfAbsent(object, cacheEntry);
            if (cacheEntry3 == null) break;
            cacheEntry2 = cacheEntry3;
        }
        return cacheEntry;
    }

    private void removeEntry(Object object) {
        CacheEntry cacheEntry = this.cache.remove(object);
        Cacheable cacheable = cacheEntry.getCacheable();
        if (cacheable != null && cacheable.getIdentity() != null) {
            cacheable.clearIdentity();
        }
        cacheEntry.free();
    }

    void evictEntry(Object object) {
        CacheEntry cacheEntry = this.cache.remove(object);
        cacheEntry.getCacheable().clearIdentity();
        cacheEntry.setCacheable(null);
    }

    private Cacheable insertIntoFreeSlot(Object object, CacheEntry cacheEntry) throws StandardException {
        try {
            this.replacementPolicy.insertEntry(cacheEntry);
        }
        catch (StandardException standardException) {
            this.removeEntry(object);
            throw standardException;
        }
        Cacheable cacheable = cacheEntry.getCacheable();
        if (cacheable == null) {
            cacheable = this.holderFactory.newCacheable(this);
        }
        cacheEntry.keep(true);
        return cacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settingIdentityComplete(Object object, CacheEntry cacheEntry, Cacheable cacheable) {
        cacheEntry.lock();
        try {
            cacheEntry.settingIdentityComplete();
            if (cacheable != null) {
                cacheEntry.setCacheable(cacheable);
            } else {
                this.removeEntry(object);
            }
        }
        finally {
            cacheEntry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable find(Object object) throws StandardException {
        Cacheable cacheable;
        if (this.stopped) {
            return null;
        }
        CacheEntry cacheEntry = this.getEntry(object);
        try {
            cacheable = cacheEntry.getCacheable();
            if (cacheable != null) {
                cacheEntry.keep(true);
                Cacheable cacheable2 = cacheable;
                return cacheable2;
            }
            cacheable = this.insertIntoFreeSlot(object, cacheEntry);
        }
        finally {
            cacheEntry.unlock();
        }
        Cacheable cacheable3 = null;
        try {
            cacheable3 = cacheable.setIdentity(object);
        }
        finally {
            this.settingIdentityComplete(object, cacheEntry, cacheable3);
        }
        return cacheable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable findCached(Object object) throws StandardException {
        if (this.stopped) {
            return null;
        }
        CacheEntry cacheEntry = this.cache.get(object);
        if (cacheEntry == null) {
            return null;
        }
        cacheEntry.lock();
        try {
            cacheEntry.waitUntilIdentityIsSet();
            Cacheable cacheable = cacheEntry.getCacheable();
            if (cacheable != null) {
                cacheEntry.keep(true);
            }
            Cacheable cacheable2 = cacheable;
            return cacheable2;
        }
        finally {
            cacheEntry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable create(Object object, Object object2) throws StandardException {
        Cacheable cacheable;
        if (this.stopped) {
            return null;
        }
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.lock();
        if (this.cache.putIfAbsent(object, cacheEntry) != null) {
            throw StandardException.newException("XBCA0.S", this.name, object);
        }
        try {
            cacheable = this.insertIntoFreeSlot(object, cacheEntry);
        }
        finally {
            cacheEntry.unlock();
        }
        Cacheable cacheable2 = null;
        try {
            cacheable2 = cacheable.createIdentity(object, object2);
        }
        finally {
            this.settingIdentityComplete(object, cacheEntry, cacheable2);
        }
        return cacheable2;
    }

    @Override
    public void release(Cacheable cacheable) {
        CacheEntry cacheEntry = this.cache.get(cacheable.getIdentity());
        cacheEntry.lock();
        try {
            cacheEntry.unkeep();
        }
        finally {
            cacheEntry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Cacheable cacheable) throws StandardException {
        Object object = cacheable.getIdentity();
        CacheEntry cacheEntry = this.cache.get(object);
        cacheEntry.lock();
        try {
            cacheEntry.unkeepForRemove();
            cacheable.clean(true);
            this.removeEntry(object);
        }
        finally {
            cacheEntry.unlock();
        }
    }

    @Override
    public void cleanAll() throws StandardException {
        this.cleanCache(null);
    }

    @Override
    public void clean(Matchable matchable) throws StandardException {
        this.cleanCache(matchable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache(Matchable matchable) throws StandardException {
        for (CacheEntry cacheEntry : this.cache.values()) {
            Cacheable cacheable;
            cacheEntry.lock();
            try {
                if (!cacheEntry.isValid()) continue;
                Cacheable cacheable2 = cacheEntry.getCacheable();
                if (matchable != null && !matchable.match(cacheable2.getIdentity()) || !cacheable2.isDirty()) continue;
                cacheEntry.keep(false);
                cacheable = cacheable2;
            }
            finally {
                cacheEntry.unlock();
                continue;
            }
            this.cleanAndUnkeepEntry(cacheEntry, cacheable);
        }
    }

    void cleanEntry(CacheEntry cacheEntry) throws StandardException {
        Cacheable cacheable;
        cacheEntry.lock();
        try {
            cacheable = cacheEntry.getCacheable();
            if (cacheable == null) {
                return;
            }
            cacheEntry.keep(false);
        }
        finally {
            cacheEntry.unlock();
        }
        this.cleanAndUnkeepEntry(cacheEntry, cacheable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAndUnkeepEntry(CacheEntry cacheEntry, Cacheable cacheable) throws StandardException {
        try {
            cacheable.clean(false);
        }
        finally {
            cacheEntry.lock();
            try {
                cacheEntry.unkeep();
            }
            finally {
                cacheEntry.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ageOut() {
        for (CacheEntry cacheEntry : this.cache.values()) {
            cacheEntry.lock();
            try {
                Cacheable cacheable;
                if (cacheEntry.isKept() || (cacheable = cacheEntry.getCacheable()) == null || cacheable.isDirty()) continue;
                this.removeEntry(cacheable.getIdentity());
            }
            finally {
                cacheEntry.unlock();
            }
        }
    }

    @Override
    public void shutdown() throws StandardException {
        this.stopped = true;
        this.cleanAll();
        this.ageOut();
        if (this.cleaner != null) {
            this.cleaner.unsubscribe();
        }
    }

    @Override
    public void useDaemonService(DaemonService daemonService) {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe();
        }
        this.cleaner = new BackgroundCleaner(this, daemonService, Math.max(this.maxSize / 10, 1));
    }

    BackgroundCleaner getBackgroundCleaner() {
        return this.cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discard(Matchable matchable) {
        boolean bl = true;
        for (CacheEntry cacheEntry : this.cache.values()) {
            cacheEntry.lock();
            try {
                Cacheable cacheable = cacheEntry.getCacheable();
                if (cacheable == null || matchable != null && !matchable.match(cacheable.getIdentity())) continue;
                if (cacheEntry.isKept()) {
                    bl = false;
                    continue;
                }
                this.removeEntry(cacheable.getIdentity());
            }
            finally {
                cacheEntry.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Cacheable> values() {
        ArrayList<Cacheable> arrayList = new ArrayList<Cacheable>();
        for (CacheEntry cacheEntry : this.cache.values()) {
            cacheEntry.lock();
            try {
                Cacheable cacheable = cacheEntry.getCacheable();
                if (cacheable == null) continue;
                arrayList.add(cacheable);
            }
            finally {
                cacheEntry.unlock();
            }
        }
        return arrayList;
    }
}

