/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.api.ServiceCallContextUtils;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.communication.rpc.ServiceCallResultFactory;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.internal.CallbackUtils;
import de.rcenvironment.core.communication.rpc.internal.MethodCaller;
import de.rcenvironment.core.communication.rpc.spi.LocalServiceLookupResult;
import de.rcenvironment.core.communication.rpc.spi.LocalServiceResolver;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemotableService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.common.security.MethodPermissionCheck;
import de.rcenvironment.core.utils.common.security.MethodPermissionCheckHasAnnotation;
import de.rcenvironment.core.utils.incubator.Assertions;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ServiceCallHandlerServiceImpl
implements RemoteServiceCallHandlerService {
    private static final MethodPermissionCheck METHOD_PERMISSION_CHECK = new MethodPermissionCheckHasAnnotation(AllowRemoteAccess.class);
    private PlatformService platformService;
    private CallbackService callbackService;
    private CallbackProxyService callbackProxyService;
    private LocalServiceResolver serviceResolver;
    private final Map<String, LocalServiceLookupResult> serviceCache;
    private final Log log = LogFactory.getLog(this.getClass());
    private final CounterCategory parameterTypesCounter;

    public ServiceCallHandlerServiceImpl() {
        this.serviceCache = new HashMap<String, LocalServiceLookupResult>();
        StatisticsTrackerService statisticsService = (StatisticsTrackerService)StaticToolkitHolder.getServiceWithUnitTestFallback(StatisticsTrackerService.class);
        this.parameterTypesCounter = statisticsService.getCounterCategory("Remote service calls (received): parameter types", StatisticsFilterLevel.DEVELOPMENT);
    }

    @Reference
    public void bindLocalServiceResolver(LocalServiceResolver newInstance) {
        this.serviceResolver = newInstance;
    }

    @Reference
    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    @Reference
    public void bindCallbackService(CallbackService newInstance) {
        this.callbackService = newInstance;
    }

    @Reference
    public void bindCallbackProxyService(CallbackProxyService newInstance) {
        this.callbackProxyService = newInstance;
    }

    @Override
    public ServiceCallResult dispatchToLocalService(ServiceCallRequest serviceCallRequest) throws InternalMessagingException {
        Assertions.isDefined((Object)serviceCallRequest, (String)"The parameter \"serviceCallRequest\" must not be null.");
        if (!this.platformService.matchesLocalInstance(serviceCallRequest.getTargetNodeId())) {
            throw new IllegalStateException("Internal consistency error: called to handle a ServiceCallResult for another node");
        }
        ThreadContextMemento previousThreadContext = ServiceCallContextUtils.attachServiceCallDataToThreadContext(serviceCallRequest.getCallerNodeId(), serviceCallRequest.getTargetNodeId(), serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName());
        try {
            ServiceCallResult serviceCallResult = this.invokeLocalService(serviceCallRequest);
            return serviceCallResult;
        }
        finally {
            previousThreadContext.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceCallResult invokeLocalService(ServiceCallRequest serviceCallRequest) throws InternalMessagingException {
        LocalServiceLookupResult serviceLookupResult;
        Object[] parameters = serviceCallRequest.getParameterList().toArray();
        ArrayList<Serializable> parameterList = new ArrayList<Serializable>();
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            parameterList.add((Serializable)CallbackUtils.handleCallbackProxy(object, this.callbackService, this.callbackProxyService));
            ++n2;
        }
        if (this.parameterTypesCounter.isEnabled()) {
            for (Object e : parameterList) {
                this.parameterTypesCounter.countClass(e);
            }
        }
        String string = serviceCallRequest.getServiceName();
        Map<String, LocalServiceLookupResult> map = this.serviceCache;
        synchronized (map) {
            serviceLookupResult = this.serviceCache.get(string);
            if (serviceLookupResult == null) {
                serviceLookupResult = this.lookupAndValidateService(serviceCallRequest, string);
                this.serviceCache.put(string, serviceLookupResult);
            }
        }
        if (!serviceLookupResult.isValidRemotableService()) {
            return ServiceCallResultFactory.representInvalidRequestAtHandler(serviceCallRequest, "No matching service found");
        }
        String methodName = serviceCallRequest.getMethodName();
        if (!serviceLookupResult.isValidMethodRequest(methodName)) {
            return ServiceCallResultFactory.representInvalidRequestAtHandler(serviceCallRequest, "Matching service found, but the method is not allowed to be called");
        }
        try {
            Object returnValue;
            try {
                returnValue = MethodCaller.callMethod(serviceLookupResult.getImplementation(), methodName, parameterList, METHOD_PERMISSION_CHECK);
            }
            catch (InvocationTargetException e) {
                Throwable methodException = e.getCause();
                if (methodException instanceof Exception && !(methodException instanceof RuntimeException)) {
                    return ServiceCallResultFactory.wrapMethodException((Exception)methodException);
                }
                return ServiceCallResultFactory.representInternalErrorAtHandler(serviceCallRequest, "Unexpected Throwable during service method invocation", methodException);
            }
            catch (RemoteOperationException e) {
                return ServiceCallResultFactory.representInternalErrorAtHandler(serviceCallRequest, "Error during service method invocation", e);
            }
            if (returnValue != null) {
                if (!(returnValue instanceof Serializable)) {
                    String message = StringUtils.format((String)("Return value is not serializable: " + returnValue.getClass().getName()), (Object[])new Object[0]);
                    return ServiceCallResultFactory.representInternalErrorAtHandler(serviceCallRequest, message);
                }
                returnValue = CallbackUtils.handleCallbackObject(returnValue, serviceCallRequest.getCallerNodeId().convertToInstanceNodeSessionId(), this.callbackService);
                return ServiceCallResultFactory.wrapReturnValue((Serializable)returnValue);
            }
            return ServiceCallResultFactory.wrapReturnValue(null);
        }
        catch (RuntimeException e) {
            return ServiceCallResultFactory.representInternalErrorAtHandler(serviceCallRequest, "Uncaught RuntimeException", e);
        }
    }

    private LocalServiceLookupResult lookupAndValidateService(ServiceCallRequest serviceCallRequest, String serviceName) {
        Method[] methods;
        Class<?> serviceInterface;
        try {
            serviceInterface = Class.forName(serviceName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.warn((Object)StringUtils.format((String)"Found no interface for service '%s' requested from '%s'", (Object[])new Object[]{serviceName, serviceCallRequest.getCallerNodeId()}));
            return LocalServiceLookupResult.createInvalidServicePlaceholder();
        }
        if (!serviceInterface.isAnnotationPresent(RemotableService.class)) {
            this.log.warn((Object)StringUtils.format((String)"Found the requested service interface '%s', but it is not a %s; refusing access", (Object[])new Object[]{serviceName, RemotableService.class.getSimpleName()}));
            return LocalServiceLookupResult.createInvalidServicePlaceholder();
        }
        Object serviceImplementation = this.serviceResolver.getLocalService(serviceName);
        if (serviceImplementation == null) {
            this.log.warn((Object)StringUtils.format((String)"Found the service interface '%s' requested by %s, but no registered implementation", (Object[])new Object[]{serviceName, serviceCallRequest.getCallerNodeId()}));
            return LocalServiceLookupResult.createInvalidServicePlaceholder();
        }
        if (!serviceInterface.isAssignableFrom(serviceImplementation.getClass())) {
            this.log.error((Object)StringUtils.format((String)"Consistency error: Found the service interface '%s', but the resolved implementation %s is not assignable to it!", (Object[])new Object[]{serviceName, serviceImplementation.getClass()}));
            return LocalServiceLookupResult.createInvalidServicePlaceholder();
        }
        HashSet<String> encounteredMethodNamesWithParameterCount = new HashSet<String>();
        HashSet<String> validatedMethodNames = new HashSet<String>();
        HashSet<String> blockedMethodNames = new HashSet<String>();
        Method[] methodArray = methods = serviceInterface.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            int parameterCount = method.getParameterTypes().length;
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            boolean roeDeclared = false;
            boolean allowMethodAccess = true;
            if (!encounteredMethodNamesWithParameterCount.add(String.valueOf(methodName) + "/" + parameterCount)) {
                this.log.error((Object)StringUtils.format((String)"Found overloaded method variants with same parameter count for %s#%s(), which is not allowed in remote service interfaces", (Object[])new Object[]{serviceName, methodName}));
                blockedMethodNames.add(methodName);
                allowMethodAccess = false;
            }
            Class<?>[] classArray = exceptionTypes;
            int n3 = exceptionTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> exceptionClass = classArray[n4];
                if (RuntimeException.class.isAssignableFrom(exceptionClass)) {
                    this.log.error((Object)StringUtils.format((String)"Method %s#%s() declares 'throws %s', which is a RuntimeException", (Object[])new Object[]{serviceName, methodName, exceptionClass.getName()}));
                    allowMethodAccess = false;
                }
                if (exceptionClass == RemoteOperationException.class) {
                    roeDeclared = true;
                } else {
                    try {
                        Constructor<?> stringOnlyConstructor = exceptionClass.getConstructor(String.class);
                        Assertions.isDefined(stringOnlyConstructor, (String)"Unexpected: getConstructor() should never return null");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.log.error((Object)StringUtils.format((String)"Method %s#%s() declares 'throws %s', but the exception class does not have a string-only constructor", (Object[])new Object[]{serviceName, methodName, exceptionClass.getName()}));
                        allowMethodAccess = false;
                    }
                }
                ++n4;
            }
            if (!roeDeclared) {
                this.log.error((Object)StringUtils.format((String)"Method %s#%s() is used as part of a remote service interface, but does not declare 'throws %s'", (Object[])new Object[]{serviceName, methodName, RemoteOperationException.class.getSimpleName()}));
                allowMethodAccess = false;
            }
            if (allowMethodAccess) {
                validatedMethodNames.add(methodName);
            } else {
                this.log.warn((Object)StringUtils.format((String)"Preventing remote access to %s#%s() as it violates one or more remote service method constraints", (Object[])new Object[]{serviceName, methodName, RemoteOperationException.class.getSimpleName()}));
            }
            ++n2;
        }
        validatedMethodNames.removeAll(blockedMethodNames);
        this.log.debug((Object)StringUtils.format((String)"Verified remote service methods for interface %s: %s", (Object[])new Object[]{serviceName, Arrays.toString(validatedMethodNames.toArray())}));
        return new LocalServiceLookupResult(serviceImplementation, validatedMethodNames);
    }
}

