/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.messaging.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.messaging.MessageEndpointHandler;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandlerMap;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.routing.internal.NetworkFormatter;
import de.rcenvironment.core.utils.common.LogUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageEndpointHandlerImpl
implements MessageEndpointHandler {
    private final Map<String, NetworkRequestHandler> requestHandlerMap = new HashMap<String, NetworkRequestHandler>();
    private final NodeIdentifierService nodeIdentifierService;
    private final Log log = LogFactory.getLog(this.getClass());

    public MessageEndpointHandlerImpl(NodeIdentifierService nodeIdentifierService) {
        this.nodeIdentifierService = nodeIdentifierService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkResponse onRequestArrivedAtDestination(NetworkRequest request) {
        Object loggableContent;
        NetworkRequestHandler handler;
        Map<String, NetworkRequestHandler> map = this.requestHandlerMap;
        synchronized (map) {
            handler = this.requestHandlerMap.get(request.getMessageType());
        }
        if (handler != null) {
            try {
                try {
                    request.getDeserializedContent();
                }
                catch (SerializationException e) {
                    throw new InternalMessagingException("Error deserializing request body", e);
                }
                try {
                    InstanceNodeSessionId prevHopId = null;
                    return handler.handleRequest(request, prevHopId);
                }
                catch (RuntimeException e) {
                    throw new InternalMessagingException("Uncaught RuntimeException while handling remote request", e);
                }
            }
            catch (InternalMessagingException e) {
                return this.logAndWrapLowLevelException(request, e);
            }
        }
        try {
            loggableContent = request.getDeserializedContent();
        }
        catch (SerializationException e) {
            loggableContent = "Failed to deserialize content: " + e;
        }
        String errorId = LogUtils.logErrorAndAssignUniqueMarker((Log)this.log, (String)("No request handler matched for message type '" + request.getMessageType() + "'; string representation of request: " + NetworkFormatter.message((Serializable)loggableContent, request.accessRawMetaData())));
        return NetworkResponseFactory.generateResponseForInternalErrorAtRecipient(request, errorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRequestHandler(String messageType, NetworkRequestHandler handler) {
        Map<String, NetworkRequestHandler> map = this.requestHandlerMap;
        synchronized (map) {
            this.requestHandlerMap.put(messageType, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRequestHandlers(NetworkRequestHandlerMap newMappings) {
        Map<String, NetworkRequestHandler> map = this.requestHandlerMap;
        synchronized (map) {
            this.requestHandlerMap.putAll(newMappings);
        }
    }

    private NetworkResponse logAndWrapLowLevelException(NetworkRequest request, InternalMessagingException e) {
        boolean compressStacktrace = false;
        String errorId = compressStacktrace ? LogUtils.logErrorAndAssignUniqueMarker((Log)this.log, (String)e.toString()) : (e.getCause() != null ? LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)this.log, (String)e.getMessage(), (Throwable)e.getCause()) : LogUtils.logErrorAndAssignUniqueMarker((Log)this.log, (String)e.getMessage()));
        NetworkResponse response = NetworkResponseFactory.generateResponseForInternalErrorAtRecipient(request, errorId);
        return response;
    }
}

