/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorMode;
import org.eclipse.wst.xsd.ui.internal.adt.editor.IEditorModeListener;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;

public class EditorModeManager
implements IAdaptable {
    private List modeList = new ArrayList();
    private EditorMode currentMode = null;
    private List listeners = new ArrayList();
    private String extensionPointId;
    private ProductCustomizationProvider productCustomizationProvider;

    public EditorModeManager(String extensionPointId) {
        this.extensionPointId = extensionPointId;
    }

    public void init() {
        this.readRegistry(this.extensionPointId);
        this.currentMode = this.getDefaultMode();
    }

    protected EditorMode getDefaultMode() {
        return (EditorMode)this.modeList.get(0);
    }

    protected void addMode(EditorMode mode) {
        this.modeList.add(mode);
    }

    public EditorMode getEditorMode(String editorModeId) {
        Iterator i = this.modeList.iterator();
        while (i.hasNext()) {
            EditorMode editorMode = (EditorMode)i.next();
            if (!editorModeId.equals(editorMode.getId())) continue;
            return editorMode;
        }
        return null;
    }

    public void setCurrentMode(EditorMode mode) {
        if (this.modeList.contains(mode)) {
            this.currentMode = mode;
            ArrayList clonedList = new ArrayList();
            clonedList.addAll(this.listeners);
            Iterator i = clonedList.iterator();
            while (i.hasNext()) {
                IEditorModeListener listener = (IEditorModeListener)i.next();
                listener.editorModeChanged(mode);
            }
        }
    }

    public EditorMode getCurrentMode() {
        return this.currentMode;
    }

    public EditorMode[] getModes() {
        EditorMode[] modes = new EditorMode[this.modeList.size()];
        this.modeList.toArray(modes);
        return modes;
    }

    public void addListener(IEditorModeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IEditorModeListener listener) {
        this.listeners.remove(listener);
    }

    private void readRegistry(String id) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String editorModeId = element.getAttribute("id");
            if (editorModeId == null || this.productCustomizationProvider == null || this.productCustomizationProvider.isEditorModeApplicable(editorModeId)) {
                try {
                    EditorMode mode = (EditorMode)element.createExecutableExtension("class");
                    this.modeList.add(mode);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setProductCustomizationProvider(ProductCustomizationProvider productCustomizationProvider) {
        this.productCustomizationProvider = productCustomizationProvider;
    }
}

