/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.ProcessEndpointsGroupCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParametricStudyEndpointSelectionPane
extends EndpointSelectionPane {
    private EndpointSelectionPane inputPane;
    private final WorkflowNodeCommand.Executor executor;

    public ParametricStudyEndpointSelectionPane(String title, EndpointType direction, WorkflowNodeCommand.Executor executor, EndpointSelectionPane inputPane) {
        super(title, direction, null, new String[0], new String[]{"Design variable"}, executor, false, true);
        this.inputPane = inputPane;
        this.executor = executor;
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        DesignVariableEndpointDialog dialog = new DesignVariableEndpointDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, isStaticEndpoint, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData);
        this.onEditClicked(name, dialog, newMetaData);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        ProcessEndpointsGroupCommand groupCommand = new ProcessEndpointsGroupCommand(this.executor, new Refreshable[]{this});
        groupCommand.add((WorkflowNodeCommand)new EditDynamicEndpointCommand(this.endpointType, oldDescription, newDescription, new Refreshable[]{this}));
        this.createParameterCommand(groupCommand, oldDescription, newDescription, "UseInputAsFromValue");
        this.createParameterCommand(groupCommand, oldDescription, newDescription, "UseInputAsToValue");
        this.createParameterCommand(groupCommand, oldDescription, newDescription, "UseInputAsStepSizeValue");
        this.execute((WorkflowNodeCommand)groupCommand);
    }

    private void createParameterCommand(ProcessEndpointsGroupCommand groupCommand, EndpointDescription oldDescription, EndpointDescription newDescription, String metaDataOutput) {
        String inputName;
        boolean oldUseInputAsFromValue = oldDescription.getMetaData().get(metaDataOutput) != null && Boolean.parseBoolean((String)oldDescription.getMetaData().get(metaDataOutput));
        boolean newUseInputAsFromValue = newDescription.getMetaData().get(metaDataOutput) != null && Boolean.parseBoolean((String)newDescription.getMetaData().get(metaDataOutput));
        switch (metaDataOutput) {
            case "UseInputAsFromValue": {
                inputName = "From Value";
                break;
            }
            case "UseInputAsToValue": {
                inputName = "To Value";
                break;
            }
            case "UseInputAsStepSizeValue": {
                inputName = "StepSize Value";
                break;
            }
            default: {
                return;
            }
        }
        if (newUseInputAsFromValue && !oldUseInputAsFromValue) {
            groupCommand.add((WorkflowNodeCommand)new AddDynamicInputCommand("paramericStudyParameters", inputName, DataType.Float, Collections.emptyMap(), "paramericStudyParameters", new Refreshable[]{this, this.inputPane}));
        } else if (!newUseInputAsFromValue && oldUseInputAsFromValue) {
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicInputCommand("paramericStudyParameters", inputName, new Refreshable[]{this, this.inputPane}));
        }
    }

    private final class DesignVariableEndpointDialog
    extends EndpointEditDialog {
        DesignVariableEndpointDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
            super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
        }

        protected void createSettings(Map<Integer, String> sortedKeyMap, Composite container) {
            if (sortedKeyMap.values().size() > 1) {
                Label useInput = new Label(container, 0);
                useInput.setText("Use Input");
                GridData useInputGridData = new GridData(131072, 4, true, false);
                useInputGridData.horizontalSpan = 2;
                useInput.setLayoutData((Object)useInputGridData);
            }
            for (String key : sortedKeyMap.values()) {
                if (this.metaData.getVisibility(key).equals((Object)EndpointMetaDataConstants.Visibility.developerConfigurable) || !this.metadataIsActive(key, this.metaData.getActivationFilter(key))) continue;
                String value = (String)this.metadataValues.get(key);
                if (value == null || value.equals("")) {
                    value = this.metaData.getDefaultValue(key);
                    this.metadataValues.put(key, value);
                }
                if (this.metaData.getDataType(key).equals("bool")) {
                    Label horizontalLine = new Label(container, 258);
                    GridData horizontalLineGD = new GridData(4, 4, true, false);
                    horizontalLineGD.horizontalSpan = 2;
                    horizontalLine.setLayoutData((Object)horizontalLineGD);
                    Button newCheckbox = this.createLabelAndCheckbox(container, String.valueOf(this.metaData.getGuiName(key)) + ":", value);
                    newCheckbox.setLayoutData((Object)new GridData(131072, 4, true, true));
                    this.widgetToKeyMap.put(newCheckbox, key);
                    newCheckbox.addSelectionListener((SelectionListener)new EndpointEditDialog.SelectionChangedListener((EndpointEditDialog)this));
                    continue;
                }
                if (this.metaData.getPossibleValues(key) != null && !this.metaData.getPossibleValues(key).contains("*")) continue;
                Text newTextfield = this.createLabelTextFieldAndCheckBox(container, String.valueOf(this.metaData.getGuiName(key)) + ":", this.metaData.getDataType(key), value, key);
                this.widgetToKeyMap.put(newTextfield, key);
                newTextfield.addModifyListener((ModifyListener)new EndpointEditDialog.MethodPropertiesModifyListener((EndpointEditDialog)this));
            }
        }

        private Text createLabelTextFieldAndCheckBox(Composite container, String label, String dataType, String value, String key) {
            new Label(container, 0).setText(label);
            Composite container2 = new Composite(container, 4);
            container2.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout textCheckBoxLayout = new GridLayout(2, false);
            textCheckBoxLayout.marginWidth = 0;
            textCheckBoxLayout.marginHeight = 0;
            container2.setLayout((Layout)textCheckBoxLayout);
            Text result = new Text(container2, 2052);
            result.setLayoutData((Object)new GridData(4, 4, true, false));
            result.setText(value);
            if (dataType.equals("int")) {
                result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 2));
                if (value.equals("-")) {
                    result.setText("");
                }
            }
            if (dataType.equals("float")) {
                result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 1));
                if (value.equals("-")) {
                    result.setText("");
                }
            }
            if (dataType.equals("float_greater_zero")) {
                result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 5));
                if (value.equals("-")) {
                    result.setText("");
                }
            }
            Button newButton = new Button(container2, 131104);
            this.widgetToKeyMap.put(newButton, (String)this.metaData.getGuiActivationFilter(key).keySet().iterator().next());
            newButton.addSelectionListener((SelectionListener)new EndpointEditDialog.SelectionChangedListener((EndpointEditDialog)this));
            newButton.setLayoutData((Object)new GridData(131072, 4, false, false));
            if (((String)this.metadataValues.get(this.metaData.getGuiActivationFilter(key).keySet().iterator().next())).equals("true")) {
                newButton.setSelection(true);
            } else {
                newButton.setSelection(false);
            }
            return result;
        }
    }
}

