/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.dialog;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.LayoutParameter;

public class WaitingDialog
extends Window {
    private final Thread spinThread;
    private final Label spinLabel = new Label("-");
    private boolean isClosed;

    public WaitingDialog(String title, String description) {
        super(title);
        Panel panel = new Panel(Panel.Orientation.HORISONTAL);
        panel.addComponent(new Label(description), new LayoutParameter[0]);
        panel.addComponent(this.spinLabel, new LayoutParameter[0]);
        this.addComponent(panel, new LayoutParameter[0]);
        this.isClosed = false;
        this.spinThread = new Thread(new SpinCode());
    }

    @Override
    protected void onVisible() {
        super.onVisible();
        this.spinThread.start();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.getOwner().runInEventThread(new Action(){

            @Override
            public void doAction() {
                WaitingDialog.super.close();
            }
        });
    }

    private class SpinCode
    implements Runnable {
        private SpinCode() {
        }

        @Override
        public void run() {
            while (!WaitingDialog.this.isClosed) {
                String currentSpin = WaitingDialog.this.spinLabel.getText();
                final String nextSpin = currentSpin.equals("-") ? "\\" : (currentSpin.equals("\\") ? "|" : (currentSpin.equals("|") ? "/" : "-"));
                if (WaitingDialog.this.getOwner() != null) {
                    WaitingDialog.this.getOwner().runInEventThread(new Action(){

                        @Override
                        public void doAction() {
                            WaitingDialog.this.spinLabel.setText(nextSpin);
                        }
                    });
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

