/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.gui.component.TextGrid;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.Scanner;

public class EditArea
extends AbstractInteractableComponent {
    private int minimumCols = 20;
    private int minimumRows = 5;
    private int charlimit = 0;
    private int currentCol = 0;
    private int currentRow = 0;
    private int rowOffset = 0;
    private int colOffset = 0;
    private boolean lockPreferredSize = false;
    private TerminalSize requestedSize;
    private int numberOfCols;
    private int numberOfRows;
    private StringBuilder dataBuffer;
    private TextGrid grid;

    public EditArea() {
        this(null);
    }

    public EditArea(TerminalSize preferredSize) {
        this(preferredSize, "");
    }

    public EditArea(TerminalSize preferredSize, String text) {
        this.dataBuffer = new StringBuilder(text);
        this.requestedSize = preferredSize;
        if (preferredSize == null) {
            preferredSize = this.calculatePreferredSize();
        }
        this.grid = new TextGrid(text);
    }

    public EditArea(TerminalSize preferredSize, String text, boolean lockPreferredSize) {
        this(preferredSize, text);
        this.lockPreferredSize = lockPreferredSize;
    }

    public void backspace() {
        TextGrid.DataGridCel cel;
        if (this.rowOffset + this.colOffset + this.currentCol + this.currentRow == 0) {
            return;
        }
        if (this.currentCol + this.colOffset == 0 && this.currentRow + this.rowOffset != 0) {
            cel = this.grid.getCel(this.currentRow + this.rowOffset - 1, this.grid.getLineLength(this.currentRow + this.rowOffset - 1));
            if (this.currentRow > 0) {
                --this.currentRow;
            } else {
                this.scrollUp();
            }
            this.end();
            int hack = this.colOffset;
            if (cel == null) {
                cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol - 1);
            }
            while (cel.getCharacter() != '\n') {
                cel = this.grid.getCel(this.currentRow + this.rowOffset, hack);
                ++hack;
            }
        } else {
            cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset - 1);
            if (this.colOffset > 0) {
                --this.colOffset;
            } else {
                --this.currentCol;
            }
        }
        this.grid.removeChar(cel.getBufferIndex());
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        if (this.lockPreferredSize) {
            return this.requestedSize;
        }
        TerminalSize ts = this.getDataSize();
        if (ts.getColumns() < this.minimumCols) {
            ts.setColumns(this.minimumCols);
        }
        if (ts.getRows() < this.minimumRows) {
            ts.setRows(this.minimumRows);
        }
        if (ts.getColumns() < this.requestedSize.getColumns()) {
            ts.setColumns(this.requestedSize.getColumns());
        }
        if (ts.getRows() < this.requestedSize.getRows()) {
            ts.setRows(this.requestedSize.getRows());
        }
        return ts;
    }

    public void delete() {
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        if (this.currentRow + this.rowOffset == this.numberOfRows - 1) {
            TextGrid.DataGridCel nextCel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset + 1);
            if (nextCel != null && nextCel.getCharacter() != '\u0001') {
                this.grid.removeChar(cel.getBufferIndex());
            }
        } else if (cel.getCharacter() != '\u0001') {
            this.grid.removeChar(cel.getBufferIndex());
        }
    }

    private void down() {
        if (this.currentRow + this.rowOffset < this.grid.getNumRows() - 1) {
            if (this.grid.getLineLength(this.currentRow + this.rowOffset + 1) <= this.currentCol + this.colOffset) {
                if (this.colOffset > this.grid.getLineLength(this.currentRow + this.rowOffset + 1)) {
                    this.colOffset = this.grid.getLineLength(this.currentRow + this.rowOffset + 1) - this.numberOfCols;
                    if (this.colOffset < 0) {
                        this.colOffset = 0;
                        this.currentCol = this.grid.getLineLength(this.currentRow + this.rowOffset + 1) - 1;
                    } else {
                        this.currentCol = this.numberOfCols - 1;
                    }
                } else {
                    this.currentCol = this.grid.getLineLength(this.currentRow + this.rowOffset + 1) - this.colOffset - 1;
                }
            }
            if (this.currentRow < this.numberOfRows - 1) {
                ++this.currentRow;
            } else {
                this.scrollDown();
            }
        }
    }

    protected void drawDisplay(TextGraphics g) {
        int width = g.getWidth();
        int height = g.getHeight();
        Terminal.Color fg = Theme.getDefaultTheme().getDefinition(Theme.Category.TEXTBOX).foreground();
        Terminal.Color bg = Theme.getDefaultTheme().getDefinition(Theme.Category.TEXTBOX).background();
        if (this.hasFocus()) {
            fg = Theme.getDefaultTheme().getDefinition(Theme.Category.TEXTBOX_FOCUSED).foreground();
            bg = Theme.getDefaultTheme().getDefinition(Theme.Category.TEXTBOX_FOCUSED).background();
        }
        for (int r = 0; r < height; ++r) {
            g.setForegroundColor(fg);
            g.setBackgroundColor(bg);
            String line = this.grid.getDisplayLine(r + this.rowOffset, this.colOffset, width);
            g.setBoldMask(false);
            g.drawString(0, r, line, new ScreenCharacterStyle[0]);
        }
    }

    private void end() {
        int linelen = this.grid.getLineLength(this.currentRow + this.rowOffset);
        this.grid.getCel(this.currentRow + this.rowOffset, linelen);
        if (linelen < this.numberOfCols) {
            this.colOffset = 0;
            this.currentCol = linelen;
        } else {
            this.currentCol = this.numberOfCols - 1;
            this.colOffset = linelen - this.numberOfCols + 1;
        }
    }

    private void enter(Key key) {
        if (this.limitReached()) {
            return;
        }
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        if (cel == null) {
            this.grid.appendChar('\n');
        } else if (cel.getBufferIndex() != -1) {
            this.grid.insertChar(cel.getBufferIndex(), '\n');
        } else {
            this.grid.appendChar('\n');
        }
        this.colOffset = 0;
        this.currentCol = 0;
        if (this.currentRow == this.numberOfRows - 1) {
            this.scrollDown();
        } else {
            ++this.currentRow;
        }
    }

    public void fix_issue() {
        if (this.currentCol < 0) {
            this.currentCol = 0;
        }
    }

    public String getData() {
        return this.grid.getDataBuffer();
    }

    public TerminalSize getDataSize() {
        int dataWidth = 0;
        int dataHeight = 0;
        Scanner scan = new Scanner(this.dataBuffer.toString());
        while (scan.hasNext()) {
            String Line = scan.nextLine();
            if (Line.length() > dataWidth) {
                dataWidth = Line.length();
            }
            ++dataHeight;
        }
        scan.close();
        return new TerminalSize(dataWidth, dataHeight);
    }

    private void home() {
        this.colOffset = 0;
        this.currentCol = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        try {
            switch (key.getKind()) {
                case Tab: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_RIGHT;
                    return result;
                }
                case Backspace: {
                    this.backspace();
                    break;
                }
                case ArrowDown: {
                    this.down();
                    break;
                }
                case ArrowUp: {
                    this.up();
                    break;
                }
                case ArrowLeft: {
                    this.left();
                    break;
                }
                case ArrowRight: {
                    this.right();
                    break;
                }
                case Enter: {
                    this.enter(key);
                    break;
                }
                case Delete: {
                    this.delete();
                    break;
                }
                case End: {
                    this.end();
                    break;
                }
                case Home: {
                    this.home();
                    break;
                }
                case PageDown: {
                    this.pageDown();
                    break;
                }
                case PageUp: {
                    this.pageUp();
                    break;
                }
                case NormalKey: {
                    this.normal(key);
                    break;
                }
                default: {
                    Interactable.Result result = Interactable.Result.EVENT_NOT_HANDLED;
                    return result;
                }
            }
            Interactable.Result result = Interactable.Result.EVENT_HANDLED;
            return result;
        }
        finally {
            this.fix_issue();
            this.invalidate();
        }
    }

    private void left() {
        if (this.currentCol > 0) {
            --this.currentCol;
        } else {
            this.scrollLeft();
        }
    }

    private boolean limitReached() {
        return this.charlimit > 0 && this.grid.size() >= this.charlimit;
    }

    private void normal(Key key) {
        if (this.limitReached()) {
            return;
        }
        if (key.getCharacter() == '\u007f') {
            return;
        }
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        if (cel != null && cel.getBufferIndex() != -1) {
            this.grid.insertChar(cel.getBufferIndex(), key.getCharacter());
        } else {
            this.grid.appendChar(key.getCharacter());
        }
        if (this.currentCol == this.numberOfCols - 1) {
            ++this.colOffset;
        } else {
            ++this.currentCol;
        }
    }

    private void pageDown() {
        if (this.rowOffset + this.numberOfRows > this.grid.getNumRows()) {
            this.currentRow = this.grid.getNumRows() - this.rowOffset;
        } else if (this.grid.getNumRows() < this.numberOfRows) {
            this.rowOffset = 0;
            this.currentRow = this.grid.getNumRows() - 1;
        } else if (this.rowOffset + this.numberOfRows >= this.grid.getNumRows()) {
            this.rowOffset = this.grid.getNumRows() - this.numberOfRows;
            this.currentRow = this.numberOfRows - 1;
        } else {
            this.rowOffset += this.numberOfRows;
        }
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        while (cel == null) {
            --this.currentRow;
            cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        }
        if (cel.getCharacter() == '\u0001') {
            this.end();
        }
    }

    private void pageUp() {
        if (this.rowOffset < this.numberOfRows) {
            this.currentRow = 0;
            this.rowOffset = 0;
        } else {
            this.rowOffset -= this.numberOfRows;
        }
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset);
        if (cel.getCharacter() == '\u0001') {
            this.end();
        }
    }

    @Override
    public void repaint(TextGraphics graphics) {
        this.numberOfCols = graphics.getWidth();
        this.numberOfRows = graphics.getHeight();
        this.drawDisplay(graphics);
        this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(this.currentCol, this.currentRow)));
    }

    private void right() {
        TextGrid.DataGridCel cel = this.grid.getCel(this.currentRow + this.rowOffset, this.currentCol + this.colOffset + 1);
        if (cel == null) {
            return;
        }
        if (cel.getBufferIndex() != -1) {
            if (this.currentCol < this.numberOfCols - 1) {
                ++this.currentCol;
            } else {
                this.scrollRight();
            }
        }
    }

    private void scrollDown() {
        if (this.numberOfRows + this.rowOffset < this.grid.getNumRows()) {
            ++this.rowOffset;
        }
    }

    public void scrollLeft() {
        if (this.colOffset > 0) {
            --this.colOffset;
        }
    }

    public void scrollRight() {
        if (this.numberOfCols + this.colOffset < this.grid.getLineLength(this.rowOffset + this.currentRow) + 1) {
            ++this.colOffset;
        }
    }

    private void scrollUp() {
        if (this.rowOffset > 0) {
            --this.rowOffset;
        }
    }

    public void setCharacterLimit(int limit) {
        this.charlimit = limit;
    }

    public void setData(String data) {
        this.grid.setBufferData(data);
        this.currentCol = 0;
        this.colOffset = 0;
        this.rowOffset = 0;
        this.currentRow = 0;
        this.invalidate();
    }

    private void up() {
        if (this.currentRow > 0) {
            --this.currentRow;
        } else {
            this.scrollUp();
        }
        if (this.grid.getLineLength(this.currentRow + this.rowOffset) <= this.currentCol + this.colOffset) {
            if (this.colOffset > this.grid.getLineLength(this.currentRow + this.rowOffset)) {
                this.colOffset = this.grid.getLineLength(this.currentRow + this.rowOffset) - this.numberOfCols;
                if (this.colOffset < 0) {
                    this.colOffset = 0;
                    this.currentCol = this.grid.getLineLength(this.currentRow + this.rowOffset) - 1;
                } else {
                    this.currentCol = this.numberOfCols - 1;
                }
            } else {
                this.currentCol = this.grid.getLineLength(this.currentRow + this.rowOffset) - this.colOffset - 1;
            }
        }
    }
}

