/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.configmanager.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class ManagedFactoryPropertiesProcessor {
    private static final Log LOGGER = LogFactory.getLog(ManagedFactoryPropertiesProcessor.class);
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    final void process(ConfigurationAdmin configAdminService, String servicePid, Properties prop) {
        NullArgumentException.validateNotNull(configAdminService, "configAdminService");
        NullArgumentException.validateNotNull(servicePid, "servicePid");
        if (!this.validate(prop)) {
            return;
        }
        int numberOfInstances = this.getInstanceCount(prop);
        String[] keys = this.getKeys(prop);
        for (int i = 1; i < numberOfInstances + 1; ++i) {
            Properties instanceProps = this.filterProps(keys, prop, i);
            LOGGER.debug(instanceProps);
            try {
                Configuration conf;
                String filter = "( &(service.factoryPid=" + servicePid + ") (service.pid=" + servicePid + "." + (i - 1) + ") )";
                LOGGER.debug("filter = " + filter);
                Configuration[] configs = configAdminService.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    conf = configs[0];
                    LOGGER.debug("\tfound -> " + conf.getPid());
                } else {
                    conf = configAdminService.createFactoryConfiguration(servicePid, null);
                    LOGGER.debug("\tcreate -> " + conf.getPid());
                }
                conf.update((Dictionary)instanceProps);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
        }
    }

    private final Properties filterProps(String[] keys, Properties prop, int instance) {
        Properties retval = new Properties();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i] + "." + instance;
            String value = prop.getProperty(key);
            if (value == null) continue;
            retval.put(keys[i], value);
        }
        return retval;
    }

    private final int getInstanceCount(Properties prop) {
        if (!prop.containsKey("instances")) {
            return -1;
        }
        String instancesRaw = (String)prop.get("instances");
        try {
            Integer instances = Integer.valueOf(instancesRaw);
            if (instances <= 0) {
                return -1;
            }
            return instances;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private final String[] getKeys(Properties prop) {
        if (!prop.containsKey("keys")) {
            return EMPTY_STRING_ARRAY;
        }
        String keysRaw = (String)prop.get("keys");
        if (keysRaw == null || keysRaw.trim().length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] keys = keysRaw.trim().split(",");
        if (keys.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return keys;
    }

    private final boolean validate(Properties prop) {
        int instances = this.getInstanceCount(prop);
        if (instances == -1) {
            return false;
        }
        String[] keys = this.getKeys(prop);
        return keys.length != 0;
    }
}

