/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor.context.impl;

import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.LocalCommandLineExecutor;
import de.rcenvironment.core.utils.executor.context.spi.ExecutorContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalExecutorContext
implements ExecutorContext {
    private File currentSandboxDir;
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public void setUpSession() throws IOException {
    }

    @Override
    public void tearDownSession() {
    }

    @Override
    public CommandLineExecutor setUpSandboxedExecutor() throws IOException {
        if (this.currentSandboxDir != null) {
            throw new IllegalStateException("The previous sandbox has not been disposed yet");
        }
        this.currentSandboxDir = TempFileServiceAccess.getInstance().createManagedTempDir("sandbox");
        this.log.debug((Object)("Prepared local sandbox at " + this.currentSandboxDir));
        return new LocalCommandLineExecutor(this.currentSandboxDir);
    }

    @Override
    public void tearDownSandbox(CommandLineExecutor executor) throws IOException {
        if (this.currentSandboxDir == null) {
            this.log.debug((Object)"No initialized local sandbox, ignoring tear down request");
            return;
        }
        this.log.debug((Object)("Cleaning local sandbox at " + this.currentSandboxDir.getAbsolutePath()));
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.currentSandboxDir);
        this.currentSandboxDir = null;
    }

    @Override
    public String createUniqueTempDir(String contextHint) throws IOException {
        String tempDirPath = TempFileServiceAccess.getInstance().createManagedTempDir(contextHint).getAbsolutePath();
        this.log.debug((Object)("Created new local temp directory at " + tempDirPath));
        return tempDirPath;
    }
}

