/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.ssh.jsch.executor;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.utils.executor.AbstractCommandLineExecutor;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.ssh.jsch.JschFileTransfer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSchCommandLineExecutor
extends AbstractCommandLineExecutor
implements CommandLineExecutor {
    private static final String SLASH = "/";
    private static final int TERMINATION_POLLING_INTERVAL_MSEC = 1000;
    private static final String EXCEPTION_MESSAGE_NOT_RUNNING = "Not running";
    private static final String EXCEPTION_MESSAGE_ALREADY_RUNNING = "Already running";
    private Session jschSession;
    private String remoteWorkDir;
    private ChannelExec executionChannel;
    private InputStream stdOutStream;
    private InputStream stdErrStream;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public JSchCommandLineExecutor(Session jschSession, String remoteWorkDir) {
        this.jschSession = jschSession;
        this.remoteWorkDir = remoteWorkDir;
    }

    public InputStream getStderr() throws IOException {
        if (this.executionChannel == null) {
            throw new IllegalStateException(EXCEPTION_MESSAGE_NOT_RUNNING);
        }
        return this.stdErrStream;
    }

    public InputStream getStdout() throws IOException {
        if (this.executionChannel == null) {
            throw new IllegalStateException(EXCEPTION_MESSAGE_NOT_RUNNING);
        }
        return this.stdOutStream;
    }

    public String getWorkDirPath() {
        return this.remoteWorkDir;
    }

    public void start(String commandString) throws IOException {
        this.start(commandString, null);
    }

    public void start(String commandString, InputStream stdinStream) throws IOException {
        if (this.executionChannel != null) {
            throw new IllegalStateException(EXCEPTION_MESSAGE_ALREADY_RUNNING);
        }
        StringBuilder command = new StringBuilder();
        for (Map.Entry entry : this.env.entrySet()) {
            command.append("export ");
            command.append((String)entry.getKey());
            command.append("=");
            command.append((String)entry.getValue());
            command.append(" && ");
        }
        command.append("cd ");
        command.append(this.remoteWorkDir);
        command.append(" && ");
        command.append(commandString);
        try {
            this.executionChannel = (ChannelExec)this.jschSession.openChannel("exec");
            String fullCommand = command.toString();
            this.log.debug((Object)("Full invocation command: " + fullCommand));
            this.executionChannel.setCommand(fullCommand);
            if (stdinStream != null) {
                this.executionChannel.setInputStream(stdinStream);
            }
            this.stdOutStream = this.executionChannel.getInputStream();
            this.stdErrStream = this.executionChannel.getExtInputStream();
            this.executionChannel.connect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public int waitForTermination() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void downloadWorkdir(File localDir) throws IOException {
        try {
            JschFileTransfer.downloadDirectory(this.jschSession, this.remoteWorkDir, localDir);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void uploadFileToWorkdir(File localFile, String remoteLocation) throws IOException {
        try {
            JschFileTransfer.uploadFile(this.jschSession, localFile, String.valueOf(this.remoteWorkDir) + SLASH + remoteLocation);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void downloadFileFromWorkdir(String remoteLocation, File localFile) throws IOException {
        try {
            JschFileTransfer.downloadFile(this.jschSession, String.valueOf(this.remoteWorkDir) + SLASH + remoteLocation, localFile);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void uploadDirectoryToWorkdir(File localDirectory, String remoteLocation) throws IOException {
        try {
            JschFileTransfer.uploadDirectory(this.jschSession, localDirectory, String.valueOf(this.remoteWorkDir) + SLASH + remoteLocation);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void downloadDirectoryFromWorkdir(String remoteLocation, File localDirectory) throws IOException {
        try {
            JschFileTransfer.downloadDirectory(this.jschSession, String.valueOf(this.remoteWorkDir) + SLASH + remoteLocation, localDirectory);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void downloadFile(String remoteSource, File remoteTarget) throws IOException {
        try {
            JschFileTransfer.downloadFile(this.jschSession, remoteSource, remoteTarget);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void downloadDirectory(String remoteLocation, File localDirectory) throws IOException {
        try {
            JschFileTransfer.downloadDirectory(this.jschSession, remoteLocation, localDirectory);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void uploadFile(File localFile, String remoteLocation) throws IOException {
        try {
            JschFileTransfer.uploadFile(this.jschSession, localFile, remoteLocation);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public void uploadDirectory(File localDirectory, String remoteLocation) throws IOException {
        try {
            JschFileTransfer.uploadDirectory(this.jschSession, localDirectory, remoteLocation);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void remoteCopy(String remoteSource, String remoteTarget) throws IOException {
        try {
            JschFileTransfer.remoteToRemoteCopy(this.jschSession, remoteSource, remoteTarget);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

