/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.common.jdbc.internal;

import de.rcenvironment.components.database.common.jdbc.JDBCDriverInformation;
import de.rcenvironment.components.database.common.jdbc.JDBCDriverService;
import de.rcenvironment.components.database.common.jdbc.internal.JDBCDriverInformationImpl;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class JDBCDriverServiceImpl
implements JDBCDriverService {
    private static final String ERROR_MESSAGE = "Failed to register JDBC driver (file: %s, driver class: %s): %s";
    private static final Log LOGGER = LogFactory.getLog(JDBCDriverServiceImpl.class);
    private static Map<String, JDBCDriverInformation> driverClassNamesWithInfo = new HashMap<String, JDBCDriverInformation>();
    private final Map<String, URLClassLoader> classLoaders = new HashMap<String, URLClassLoader>();
    private ConfigurationService configurationService;
    private Set<JDBCDriverInformation> driverInformations = new HashSet<JDBCDriverInformation>();
    private List<String> registeredDrivers = new ArrayList<String>();

    static {
        driverClassNamesWithInfo.put("com.mysql.jdbc.Driver", new JDBCDriverInformationImpl("mysql", "MySQL"));
        driverClassNamesWithInfo.put("org.postgresql.Driver", new JDBCDriverInformationImpl("postgresql", "PostgreSQL"));
        driverClassNamesWithInfo.put("COM.ibm.db2.jdbc.app.DB2Driver", new JDBCDriverInformationImpl("db2", "IBM DB2L"));
        driverClassNamesWithInfo.put("sun.jdbc.odbc.JdbcOdbcDriver", new JDBCDriverInformationImpl("odbc", "JDBC-ODBC Bridge"));
        driverClassNamesWithInfo.put("weblogic.jdbc.mssqlserver4.Driver", new JDBCDriverInformationImpl("weblogic:mssqlserver4", "Microsoft SQL Server"));
        driverClassNamesWithInfo.put("oracle.jdbc.driver.OracleDriver", new JDBCDriverInformationImpl("oracle:thin", "Oracle Thin"));
        driverClassNamesWithInfo.put("com.pointbase.jdbc.jdbcUniversalDriver", new JDBCDriverInformationImpl("pointbase://embedded[", "PointBase Embedded Server"));
        driverClassNamesWithInfo.put("COM.cloudscape.core.JDBCDriver", new JDBCDriverInformationImpl("cloudscape", "Cloudscape"));
        driverClassNamesWithInfo.put("RmiJdbc.RJDriver", new JDBCDriverInformationImpl("rmi", "Cloudscape RMI"));
        driverClassNamesWithInfo.put("org.firebirdsql.jdbc.FBDriver", new JDBCDriverInformationImpl("firebirdsql", "Firebird (JCA/JDBC Driver)"));
        driverClassNamesWithInfo.put("ids.sql.IDSDriver", new JDBCDriverInformationImpl("ids", "IDS Server"));
        driverClassNamesWithInfo.put("com.informix.jdbc.IfxDriver", new JDBCDriverInformationImpl("informix-sqli", "Informix Dynamic Server"));
        driverClassNamesWithInfo.put("jdbc.idbDriver", new JDBCDriverInformationImpl("idb", "InstantDB (v3.13 and earlier)"));
        driverClassNamesWithInfo.put("org.enhydra.instantdb.jdbc.idbDriver", new JDBCDriverInformationImpl("idb", "InstantDB (v3.14 and later)"));
        driverClassNamesWithInfo.put("interbase.interclient.Driver", new JDBCDriverInformationImpl("interbase", "Interbase (InterClient Driver)"));
        driverClassNamesWithInfo.put("hSql.hDriver", new JDBCDriverInformationImpl("HypersonicSQL", "Hypersonic SQL (v1.2 and earlier)"));
        driverClassNamesWithInfo.put("org.hsql.jdbcDriver", new JDBCDriverInformationImpl("HypersonicSQL", "Hypersonic SQL (v1.3 and later)"));
        driverClassNamesWithInfo.put("com.ashna.jturbo.driver.Driver", new JDBCDriverInformationImpl("JTurbo", "Microsoft SQL Server (JTurbo Driver)"));
        driverClassNamesWithInfo.put("com.inet.tds.TdsDriver", new JDBCDriverInformationImpl("inetdae", "Microsoft SQL Server (Sprinta Driver)"));
        driverClassNamesWithInfo.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", new JDBCDriverInformationImpl("microsoft:sqlserver", "Microsoft SQL Server 2000 (Microsoft Driver)"));
        driverClassNamesWithInfo.put("oracle.jdbc.driver.OracleDriver", new JDBCDriverInformationImpl("oracle:oci", "Oracle OCI 9i"));
        driverClassNamesWithInfo.put("com.sybase.jdbc.SybDriver", new JDBCDriverInformationImpl("sybase:Tds", "Sybase (jConnect 4.2 and earlier)"));
        driverClassNamesWithInfo.put("com.sybase.jdbc2.jdbc.SybDriver", new JDBCDriverInformationImpl("sybase:Tds", "Sybase (jConnect 5.2)"));
    }

    public void activate(BundleContext context) {
        this.registerJDBCDrivers();
    }

    public void deactivate() {
        for (String classloaderName : this.classLoaders.keySet()) {
            URLClassLoader classLoader = this.classLoaders.get(classloaderName);
            if (classLoader == null) continue;
            try {
                classLoader.close();
                LOGGER.debug((Object)("Closed classloader for " + classloaderName));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to close classloader for " + classloaderName + ". Reason: " + e.getMessage()));
            }
        }
    }

    @Override
    public Set<JDBCDriverInformation> getRegisteredJDBCDrivers() {
        return Collections.unmodifiableSet(this.driverInformations);
    }

    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    private void loadDriverIfNotLoadedAlready(File driverFile, String driverClassName) {
        if (!this.registeredDrivers.contains(driverClassName)) {
            this.loadDriver(driverFile, driverClassName);
        }
    }

    private void registerJDBCDrivers() {
        File[] fileArray = this.configurationService.getConfigurablePathList(ConfigurationService.ConfigurablePathListId.JDBC_DRIVER_DIRS);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            File[] fileArray2 = dir.listFiles();
            int n3 = fileArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String scheme;
                File file = fileArray2[n4];
                if (file.getName().contains("mysql")) {
                    scheme = "com.mysql.jdbc.Driver";
                    this.loadDriverIfNotLoadedAlready(file, scheme);
                } else if (file.getName().contains("postgresql")) {
                    scheme = "org.postgresql.Driver";
                    this.loadDriverIfNotLoadedAlready(file, scheme);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void loadDriver(File driverFile, String driverClassName) {
        URL[] urls;
        if (!(driverFile.exists() && driverFile.isFile() && driverFile.canRead())) {
            LOGGER.error((Object)StringUtils.format((String)ERROR_MESSAGE, (Object[])new Object[]{driverClassName, driverFile.getAbsolutePath(), "file not found or not readable"}));
            return;
        }
        try {
            urls = new URL[]{driverFile.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)StringUtils.format((String)ERROR_MESSAGE, (Object[])new Object[]{driverClassName, driverFile.getAbsolutePath(), e.getMessage()}));
            return;
        }
        try {
            URLClassLoader classLoader = new URLClassLoader(urls);
            Class<?> driverClass = Class.forName(driverClassName, true, classLoader);
            Driver driver = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(new DriverAdapter(driver));
            this.registeredDrivers.add(driverClassName);
            this.classLoaders.put(driverClassName, classLoader);
            LOGGER.info((Object)("Successfully registered JDBC driver from file: " + driverFile.getAbsolutePath()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            LOGGER.error((Object)StringUtils.format((String)ERROR_MESSAGE, (Object[])new Object[]{driverClassName, driverFile.getAbsolutePath(), e.getMessage()}));
            return;
        }
        this.driverInformations.add(driverClassNamesWithInfo.get(driverClassName));
    }

    @Override
    public Connection getConnectionWithCredentials(String url, String databaseUser, String databasePassword) throws SQLException {
        try {
            Connection connection = DriverManager.getConnection(url, databaseUser, databasePassword);
            return connection;
        }
        catch (SQLNonTransientConnectionException e) {
            throw new SQLException("Failed to establish connection; " + e.getCause().getMessage());
        }
    }

    @Override
    public Driver getDriverForURL(String url) throws SQLException {
        return DriverManager.getDriver(url);
    }

    private class DriverAdapter
    implements Driver {
        private final Driver driver;

        DriverAdapter(Driver driver) {
            this.driver = driver;
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.driver.connect(url, info);
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.driver.acceptsURL(url);
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.driver.getPropertyInfo(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not using java.util.logging");
        }
    }
}

