/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.internal.FileService;
import de.rcenvironment.core.component.integration.internal.RunnerService;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationFileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

public class ToolIntegrationFileWatcherManager {
    private static final String FOUND_NO_WATCHER_FOR_CONTEXT = "Found no watcher for context ";
    private static final String COULD_NOT_CREATE_A_WATCH_SERVICE_FOR_THE_FILE = "Could not create a WatchService for the file: ";
    private final Map<ToolIntegrationContext, ToolIntegrationFileWatcher> watchers = Collections.synchronizedMap(new HashMap());
    private ToolIntegrationFileWatcher.Factory fileWatcherFactory;
    private RunnerService runnerService;
    private FileService fileService;
    private final Log log = LogFactory.getLog(ToolIntegrationFileWatcherManager.class);

    protected ToolIntegrationFileWatcherManager() {
    }

    public void createWatcherForToolRootDirectory(ToolIntegrationContext context) {
        File integrationRootFolder = this.constructToolFolderFile(context);
        if (!integrationRootFolder.exists()) {
            integrationRootFolder.mkdirs();
        }
        try {
            ToolIntegrationFileWatcher integrationWatcher = this.fileWatcherFactory.create(context);
            this.runnerService.execute("Filewatcher for integration files", integrationWatcher, "FileWatcher " + context.getContextId());
            Path toolIntegrationPath = this.constructPath(integrationRootFolder);
            integrationWatcher.registerRecursive(toolIntegrationPath);
            this.watchers.put(context, integrationWatcher);
            this.log.debug((Object)("Created new watcher for context " + context.getContextType()));
        }
        catch (IOException e) {
            this.log.warn((Object)(COULD_NOT_CREATE_A_WATCH_SERVICE_FOR_THE_FILE + integrationRootFolder.getAbsolutePath()), (Throwable)e);
        }
    }

    private File constructToolFolderFile(ToolIntegrationContext context) {
        return this.fileService.createFile(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
    }

    private Path constructPath(File file) {
        return this.fileService.getPath(file.getAbsolutePath());
    }

    public void unregisterRootDirectory(ToolIntegrationContext context) {
        File integrationRootFolder = this.constructToolFolderFile(context);
        ToolIntegrationFileWatcher integrationWatcher = this.watchers.get(context);
        if (integrationWatcher != null) {
            try {
                integrationWatcher.unregisterRecursive(this.constructPath(integrationRootFolder));
            }
            catch (IOException e) {
                this.log.warn((Object)("Could not unregister integration root folder: " + integrationRootFolder.getAbsolutePath()), (Throwable)e);
            }
            integrationWatcher.stop();
            this.watchers.remove(context);
            this.log.debug((Object)("Unregistered watcher for context " + context.getContextId()));
        } else {
            this.log.warn((Object)(FOUND_NO_WATCHER_FOR_CONTEXT + context.getContextId()));
        }
    }

    public void setAllWatcherActivity(boolean active) {
        for (ToolIntegrationFileWatcher current : this.watchers.values()) {
            current.setWatcherActive(active);
        }
    }

    public void unregister(String previousToolName, ToolIntegrationContext integrationContext) {
        if (this.watchers.get(integrationContext) != null) {
            File path = new File(this.constructToolFolderFile(integrationContext), previousToolName);
            try {
                this.watchers.get(integrationContext).unregisterRecursive(this.constructPath(path));
            }
            catch (IOException e) {
                this.log.debug((Object)("Could not unregister tool directory of tool " + previousToolName), (Throwable)e);
            }
        } else {
            this.log.warn((Object)(FOUND_NO_WATCHER_FOR_CONTEXT + integrationContext.getContextId()));
        }
    }

    public void registerRecursive(String toolName, ToolIntegrationContext integrationContext) {
        if (this.watchers.get(integrationContext) != null) {
            File path = new File(this.constructToolFolderFile(integrationContext), toolName);
            try {
                this.watchers.get(integrationContext).registerRecursive(this.constructPath(path));
            }
            catch (IOException e) {
                this.log.debug((Object)("Could not register tool directory of tool " + toolName), (Throwable)e);
            }
        } else {
            this.log.warn((Object)(FOUND_NO_WATCHER_FOR_CONTEXT + integrationContext.getContextId()));
        }
    }

    public void shutdown() {
        this.log.debug((Object)"Shutting down file watchers");
        ArrayList<ToolIntegrationContext> contexts = new ArrayList<ToolIntegrationContext>(this.watchers.keySet());
        for (ToolIntegrationContext context : contexts) {
            this.unregisterRootDirectory(context);
        }
        if (this.watchers.size() != 0) {
            this.log.error((Object)"Unexpected state: Remaining registered watchers after deregistration");
        }
    }

    private void setFileWatcherFactory(ToolIntegrationFileWatcher.Factory fileWatcherFactory) {
        this.fileWatcherFactory = fileWatcherFactory;
    }

    private void setRunnerService(RunnerService runnerService) {
        this.runnerService = runnerService;
    }

    private void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @Component(service={Builder.class})
    public static class Builder {
        private ToolIntegrationFileWatcher.Factory fileWatcherFactory;
        private RunnerService runnerService;
        private FileService fileService;

        public ToolIntegrationFileWatcherManager build(ToolIntegrationService integrationService) {
            ToolIntegrationFileWatcherManager returnValue = new ToolIntegrationFileWatcherManager();
            this.fileWatcherFactory.setToolIntegrationService(integrationService);
            returnValue.setFileWatcherFactory(this.fileWatcherFactory);
            returnValue.setRunnerService(this.runnerService);
            returnValue.setFileService(this.fileService);
            return returnValue;
        }

        @Reference
        public void bindFileWatcherFactory(ToolIntegrationFileWatcher.Factory newInstance) {
            this.fileWatcherFactory = newInstance;
        }

        @Reference
        public void bindRunnerService(RunnerService newInstance) {
            this.runnerService = newInstance;
        }

        @Reference
        public void bindFileService(FileService newInstance) {
            this.fileService = newInstance;
        }
    }
}

