/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.HashMap;
import java.util.Map;

public class OptimizerAddDynamicEndpointCommand
extends AddDynamicEndpointCommand {
    private static final String DESIGN_VARIABLE = "Design";
    private final EndpointType direction;
    private final boolean hasGradient;
    private final Map<String, String> gradientMetadata = new HashMap<String, String>();

    public OptimizerAddDynamicEndpointCommand(EndpointType direction, String name, String id, DataType type, Map<String, String> metaData, Refreshable ... refreshable) {
        super(direction, id, name, type, metaData, refreshable);
        this.direction = direction;
        this.hasGradient = Boolean.parseBoolean(metaData.get("hasGradient"));
    }

    public void execute() {
        super.execute();
        EndpointDescription endpoint = this.endpointDescManager.getEndpointDescription(this.name);
        WorkflowNode workflowNode = this.getWorkflowNode();
        for (String key : this.metaData.keySet()) {
            if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                this.gradientMetadata.put(key, (String)this.metaData.get(key));
            } else {
                this.gradientMetadata.put(key, "-");
            }
            this.gradientMetadata.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
        }
        switch (this.direction) {
            case INPUT: {
                if (this.hasGradient) {
                    for (EndpointDescription e : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!e.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        this.endpointDescManager.addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.name, e.getName()), e.getDataType(), this.gradientMetadata);
                    }
                }
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.name, this.type, this.metaData, workflowNode);
                break;
            }
            case OUTPUT: {
                for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                    if (function.getMetaDataValue("hasGradient") == null || !Boolean.parseBoolean(function.getMetaDataValue("hasGradient"))) continue;
                    for (String key : this.metaData.keySet()) {
                        if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                            this.gradientMetadata.put(key, (String)this.metaData.get(key));
                        } else {
                            this.gradientMetadata.put(key, "-");
                        }
                        this.gradientMetadata.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                    }
                    workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.name), this.type, this.gradientMetadata);
                }
                HashMap optimalMetaData = new HashMap();
                optimalMetaData.putAll(this.metaData);
                this.endpointDescManager.addDynamicEndpointDescription("optima", String.valueOf(this.name) + "_optimal", this.type, optimalMetaData);
                if (this.metaData.get("hasStartValue") == null && ((String)this.metaData.get("startValue")).isEmpty() || this.metaData.get("hasStartValue") != null && !Boolean.parseBoolean((String)this.metaData.get("hasStartValue"))) {
                    HashMap<String, String> startValueMetaData = new HashMap<String, String>();
                    startValueMetaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                    workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(this.name) + " - start value", this.type, startValueMetaData);
                }
                if (endpoint.getMetaDataValue("useStep") != null && !endpoint.getMetaDataValue("useStep").isEmpty() && endpoint.getMetaDataValue("useUnifiedStep") != null && !Boolean.parseBoolean(endpoint.getMetaDataValue("useUnifiedStep"))) {
                    HashMap<String, String> stepValueMetaData = new HashMap<String, String>();
                    stepValueMetaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                    workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(this.name) + " - step value", this.type, stepValueMetaData);
                }
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.name, this.type, this.metaData, workflowNode);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        super.undo();
        WorkflowNode workflowNode = this.getWorkflowNode();
        switch (this.direction) {
            case INPUT: {
                if (this.hasGradient) {
                    for (EndpointDescription e : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!e.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        this.endpointDescManager.removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.name, e.getName()));
                    }
                }
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.name, this.metaData, workflowNode);
                break;
            }
            case OUTPUT: {
                for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                    if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.name))) continue;
                    workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.name));
                }
                this.endpointDescManager.removeDynamicEndpointDescription(String.valueOf(this.name) + "_optimal");
                if (this.metaData.get("hasStartValue") == null && ((String)this.metaData.get("startValue")).isEmpty() || this.metaData.get("hasStartValue") != null && !Boolean.parseBoolean((String)this.metaData.get("hasStartValue"))) {
                    workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.name) + " - start value");
                }
                if (this.metaData.get("useStep") != null && !((String)this.metaData.get("useStep")).isEmpty() && this.metaData.get("useUnifiedStep") != null && !Boolean.parseBoolean((String)this.metaData.get("useUnifiedStep"))) {
                    workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.name) + " - step value");
                }
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.name, this.metaData, workflowNode);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

