/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.Container;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.InteractableContainer;
import com.googlecode.lanterna.gui.component.AbstractComponent;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.listener.ContainerListener;
import com.googlecode.lanterna.gui.util.ShortcutHelper;
import com.googlecode.lanterna.input.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractContainer
extends AbstractComponent
implements InteractableContainer,
Container {
    private final List<ContainerListener> containerListeners;
    private final List<Component> components = new ArrayList<Component>();
    private final ShortcutHelper shortcutHelper;

    protected AbstractContainer() {
        this.containerListeners = new LinkedList<ContainerListener>();
        this.shortcutHelper = new ShortcutHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(Component component, LayoutParameter ... layoutParameters) {
        if (component == null) {
            return;
        }
        List<Component> list = this.components;
        synchronized (list) {
            this.components.add(component);
        }
        if (component instanceof AbstractComponent) {
            ((AbstractComponent)component).setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentAt(int index) {
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsComponent(Component component) {
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.contains(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentCount() {
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeComponent(Component component) {
        if (component == null) {
            return false;
        }
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllComponents() {
        List<Component> list = this.components;
        synchronized (list) {
            while (this.getComponentCount() > 0) {
                this.removeComponent(this.getComponentAt(0));
            }
        }
    }

    @Override
    public boolean isScrollable() {
        for (Component component : this.components) {
            if (!component.isScrollable()) continue;
            return true;
        }
        return false;
    }

    protected Iterable<Component> components() {
        return this.components;
    }

    @Override
    public void addContainerListener(ContainerListener cl) {
        if (cl != null) {
            this.containerListeners.add(cl);
        }
    }

    @Override
    public void removeContainerListener(ContainerListener cl) {
        if (cl != null) {
            this.containerListeners.remove(cl);
        }
    }

    @Override
    public boolean hasInteractable(Interactable interactable) {
        for (Component component : this.components()) {
            if (component instanceof InteractableContainer && ((InteractableContainer)((Object)component)).hasInteractable(interactable)) {
                return true;
            }
            if (component != interactable) continue;
            return true;
        }
        return false;
    }

    @Override
    public Interactable nextFocus(Interactable previous) {
        boolean chooseNextAvailable = previous == null;
        for (Component component : this.components()) {
            InteractableContainer ic;
            if (chooseNextAvailable) {
                Interactable firstInteractable;
                if (!component.isVisible()) continue;
                if (component instanceof Interactable) {
                    return (Interactable)((Object)component);
                }
                if (!(component instanceof InteractableContainer) || (firstInteractable = ((InteractableContainer)((Object)component)).nextFocus(null)) == null) continue;
                return firstInteractable;
            }
            if (component == previous) {
                chooseNextAvailable = true;
                continue;
            }
            if (!(component instanceof InteractableContainer) || !(ic = (InteractableContainer)((Object)component)).hasInteractable(previous)) continue;
            Interactable next = ic.nextFocus(previous);
            if (next == null) {
                chooseNextAvailable = true;
                continue;
            }
            return next;
        }
        return null;
    }

    @Override
    public Interactable previousFocus(Interactable fromThis) {
        boolean chooseNextAvailable = fromThis == null;
        ArrayList<Component> revComponents = new ArrayList<Component>(this.components);
        Collections.reverse(revComponents);
        for (Component component : revComponents) {
            InteractableContainer ic;
            if (chooseNextAvailable) {
                Interactable lastInteractable;
                if (!component.isVisible()) continue;
                if (component instanceof Interactable) {
                    return (Interactable)((Object)component);
                }
                if (!(component instanceof InteractableContainer) || (lastInteractable = ((InteractableContainer)((Object)component)).previousFocus(null)) == null) continue;
                return lastInteractable;
            }
            if (component == fromThis) {
                chooseNextAvailable = true;
                continue;
            }
            if (!(component instanceof InteractableContainer) || !(ic = (InteractableContainer)((Object)component)).hasInteractable(fromThis)) continue;
            Interactable next = ic.previousFocus(fromThis);
            if (next == null) {
                chooseNextAvailable = true;
                continue;
            }
            return next;
        }
        return null;
    }

    @Override
    public void addShortcut(Key.Kind key, Action action) {
        this.shortcutHelper.addShortcut(key, action);
    }

    @Override
    public void addShortcut(char character, boolean withCtrl, boolean withAlt, Action action) {
        this.shortcutHelper.addShortcut(character, withCtrl, withAlt, action);
    }

    @Override
    public boolean triggerShortcut(Key key) {
        return this.shortcutHelper.triggerShortcut(key);
    }
}

