/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentImageContainerService;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.workflow.editor.LabelFactory;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowNodeFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class WorkflowPaletteFactory {
    public PaletteRoot createPalette(List<DistributedComponentEntry> componentInstallations) {
        PaletteRoot palette = new PaletteRoot();
        this.createToolsGroup(palette);
        this.createComponentsGroup(palette, componentInstallations);
        return palette;
    }

    private void createComponentsGroup(PaletteRoot palette, List<DistributedComponentEntry> componentInstallations) {
        PaletteDrawer componentsDrawer;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        PlatformService platformService = (PlatformService)serviceRegistryAccess.getService(PlatformService.class);
        LogicalNodeId localNode = platformService.getLocalDefaultLogicalNodeId();
        HashMap<String, List> groupedComponents = new HashMap<String, List>();
        componentInstallations = ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)componentInstallations, (LogicalNodeId)localNode);
        Collections.sort(componentInstallations, (o1, o2) -> o1.getComponentInstallation().compareTo((Object)o2.getComponentInstallation()));
        ComponentImageContainerService componentImageContainerService = (ComponentImageContainerService)serviceRegistryAccess.getService(ComponentImageContainerService.class);
        for (DistributedComponentEntry distributedComponentEntry : componentInstallations) {
            ComponentInterface componentInterface = distributedComponentEntry.getComponentInstallation().getComponentInterface();
            Image image = componentImageContainerService.getComponentImageContainer(componentInterface).getComponentIcon16();
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
            String displayName = this.buildDisplayName(componentInterface);
            CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(displayName, displayName, (CreationFactory)new WorkflowNodeFactory(distributedComponentEntry.getComponentInstallation()), imageDescriptor, imageDescriptor);
            groupedComponents.computeIfAbsent(componentInterface.getGroupName(), ignored -> new ArrayList()).add(component);
        }
        for (Map.Entry entry : groupedComponents.entrySet()) {
            List list = (List)entry.getValue();
            Collections.sort(list, new PaletteComperator());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> standardGroups = new ArrayList<String>();
        for (String group : groupedComponents.keySet()) {
            if (group.startsWith("_")) {
                arrayList.add(group);
                continue;
            }
            standardGroups.add(group);
        }
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(standardGroups, String.CASE_INSENSITIVE_ORDER);
        for (String standardGroup : standardGroups) {
            componentsDrawer = new PaletteDrawer(standardGroup);
            componentsDrawer.addAll((List)groupedComponents.get(standardGroup));
            componentsDrawer.setInitialState(1);
            palette.add((PaletteEntry)componentsDrawer);
        }
        for (String specialGroup : arrayList) {
            componentsDrawer = new PaletteDrawer(specialGroup);
            componentsDrawer.addAll((List)groupedComponents.get(specialGroup));
            componentsDrawer.setInitialState(1);
            palette.add((PaletteEntry)componentsDrawer);
        }
    }

    private String buildDisplayName(ComponentInterface componentInterface) {
        String displayName = componentInterface.getDisplayName();
        ToolIntegrationContextRegistry toolIntegrationRegistry = (ToolIntegrationContextRegistry)ServiceRegistry.createAccessFor((Object)this).getService(ToolIntegrationContextRegistry.class);
        if (componentInterface.getVersion() != null && (toolIntegrationRegistry.hasTIContextMatchingPrefix(componentInterface.getIdentifierAndVersion()) || componentInterface.getIdentifierAndVersion().startsWith("de.rcenvironment.remoteaccess"))) {
            displayName = String.valueOf(displayName) + StringUtils.format((String)" (%s)", (Object[])new Object[]{componentInterface.getVersion()});
        }
        return displayName;
    }

    private void createToolsGroup(PaletteRoot palette) {
        PaletteGroup toolsGroup = new PaletteGroup(Messages.tools);
        ArrayList<PanningSelectionToolEntry> entries = new ArrayList<PanningSelectionToolEntry>();
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        tool.setLabel(Messages.select);
        palette.setDefaultEntry((ToolEntry)tool);
        entries.add(tool);
        tool = new ConnectionCreationToolEntry(Messages.connection, Messages.newConnection, (CreationFactory)new SimpleFactory(null), ImageDescriptor.createFromURL((URL)WorkflowPaletteFactory.class.getResource("/resources/icons/connection16.gif")), ImageDescriptor.createFromURL((URL)WorkflowPaletteFactory.class.getResource("/resources/icons/connection24.gif")));
        tool.setLabel(tool.getLabel());
        entries.add(tool);
        tool = new CombinedTemplateCreationEntry("Add Label", Messages.label, (CreationFactory)new LabelFactory(), null, null);
        tool.setDescription(Messages.labelDescription);
        tool.setLargeIcon(ImageDescriptor.createFromURL((URL)WorkflowPaletteFactory.class.getResource("/resources/icons/label_24.png")));
        tool.setSmallIcon(ImageDescriptor.createFromURL((URL)WorkflowPaletteFactory.class.getResource("/resources/icons/label_16.png")));
        entries.add(tool);
        toolsGroup.addAll(entries);
        palette.add((PaletteEntry)toolsGroup);
    }

    private class PaletteComperator
    implements Comparator<PaletteEntry> {
        private PaletteComperator() {
        }

        @Override
        public int compare(PaletteEntry pal1, PaletteEntry pal2) {
            return pal1.getLabel().compareToIgnoreCase(pal2.getLabel());
        }
    }
}

