/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.internal;

import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListener;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListenerAdapter;
import de.rcenvironment.core.communication.connection.api.DisconnectReason;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;

public class NetworkConnectionListenerImpl
implements IStartup {
    private static final String POPUP_TEXT_CONNECTION_WILL_BE_REATTEMPTED = "The connection will be automatically reattempted in the background.";
    private static final String POPUP_TEXT_CONNECTION_WILL_NOT_BE_REATTEMPTED = "The connection will not auto-reconnect. You can trigger a manual reconnect in the Network View.";
    private static final String DIALOG_TITLE = "Warning";
    private final ServiceRegistryPublisherAccess serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
    private boolean warningOpen = false;

    public void registerListener() {
        this.serviceRegistryAccess.registerService(ConnectionSetupListener.class, (Object)new ConnectionSetupListenerAdapter(){

            public void onConnectionAttemptFailed(ConnectionSetup setup, boolean firstConsecutiveFailure, boolean willAutoRetry) {
                if (!firstConsecutiveFailure) {
                    return;
                }
                String message = StringUtils.format((String)"Failed to establish network connection to \"%s\".\n\n%s", (Object[])new Object[]{setup.getDisplayName(), this.getAutoRetryRemark(willAutoRetry)});
                this.showMessageDialogAsync(message);
            }

            public void onConnectionClosed(ConnectionSetup setup, DisconnectReason disconnectReason, boolean willAutoRetry) {
                if (setup.getDisconnectReason() == DisconnectReason.ERROR) {
                    String message = StringUtils.format((String)"Network connection to \"%s\" was closed due to a connection error.\n\n%s", (Object[])new Object[]{setup.getDisplayName(), this.getAutoRetryRemark(willAutoRetry)});
                    this.showMessageDialogAsync(message);
                } else if (setup.getDisconnectReason() == DisconnectReason.REMOTE_SHUTDOWN) {
                    String message = StringUtils.format((String)"Network connection to \"%s\" was closed because the remote node is shutting down.\n\n%s", (Object[])new Object[]{setup.getDisplayName(), this.getAutoRetryRemark(willAutoRetry)});
                    this.showMessageDialogAsync(message);
                }
            }

            private String getAutoRetryRemark(boolean willAutoRetry) {
                if (willAutoRetry) {
                    return NetworkConnectionListenerImpl.POPUP_TEXT_CONNECTION_WILL_BE_REATTEMPTED;
                }
                return NetworkConnectionListenerImpl.POPUP_TEXT_CONNECTION_WILL_NOT_BE_REATTEMPTED;
            }

            private void showMessageDialogAsync(final String message) {
                if (!NetworkConnectionListenerImpl.this.warningOpen) {
                    final Display display = Display.getDefault();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Log log = LogFactory.getLog(this.getClass());
                            Shell shell = display.getActiveShell();
                            if (shell == null) {
                                log.debug((Object)"No active shell to open message dialog; using fallback");
                                Shell[] shellArray = display.getShells();
                                int n = shellArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Shell testShell = shellArray[n2];
                                    if (testShell.isVisible()) {
                                        shell = testShell;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (shell == null) {
                                    log.error((Object)("Failed to open message dialog; message text: " + message));
                                    return;
                                }
                            }
                            NetworkConnectionListenerImpl.this.warningOpen = true;
                            MessageBox warning = new MessageBox(shell, 40);
                            warning.setMessage(message);
                            warning.setText(NetworkConnectionListenerImpl.DIALOG_TITLE);
                            int id = warning.open();
                            if (id == 32 || id == 64) {
                                NetworkConnectionListenerImpl.this.warningOpen = false;
                            }
                        }
                    });
                }
            }
        });
    }

    public void earlyStartup() {
        this.registerListener();
    }
}

