/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static String constructFilter(Map<String, String> properties) {
        String filter = null;
        StringBuilder filterBuilder = new StringBuilder();
        if (properties != null && properties.size() > 0) {
            filterBuilder.append("(&");
            Map<String, String> serviceProperties = properties;
            for (Map.Entry<String, String> entry : serviceProperties.entrySet()) {
                filterBuilder.append("(" + entry.getKey() + "=" + entry.getValue() + ")");
            }
            filterBuilder.append(")");
            filter = new String(filterBuilder);
        }
        return filter;
    }

    public static <T> T createFailingServiceProxy(final Class<T> iface) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
                throw new IllegalStateException("Service not available: " + iface.getCanonicalName());
            }
        });
    }
}

