/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionController;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallbackService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstancesFactory;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEvent;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEventType;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutionControllerImpl
implements ComponentExecutionController {
    private static final Log LOG = LogFactory.getLog(ComponentExecutionControllerImpl.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private static ComponentExecutionRelatedInstancesFactory compExeInstancesFactory;
    private ComponentExecutionRelatedInstances compExeRelatedInstances;
    private String compInstanceName;
    private Object verifyLock = new Object();

    @Deprecated
    public ComponentExecutionControllerImpl() {
    }

    public ComponentExecutionControllerImpl(ComponentExecutionContext compExeCtx, WorkflowExecutionControllerCallbackService wfExeCtrlBridge, NetworkDestination wfStorageNetworkDestination, long currentTimestampOffWorkflowNode) {
        this.compInstanceName = compExeCtx.getInstanceName();
        int timestampOffsetToWorkfowNode = (int)(currentTimestampOffWorkflowNode - System.currentTimeMillis());
        this.compExeRelatedInstances = new ComponentExecutionRelatedInstances();
        this.compExeRelatedInstances.compExeCtx = compExeCtx;
        this.compExeRelatedInstances.timestampOffsetToWorkfowNode = timestampOffsetToWorkfowNode;
        this.compExeRelatedInstances.wfExeCtrlBridge = wfExeCtrlBridge;
        this.compExeRelatedInstances.wfStorageNetworkDestination = wfStorageNetworkDestination;
        this.compExeRelatedInstances.compExeStorageBridge = compExeInstancesFactory.createComponentExecutionStorageBridge(this.compExeRelatedInstances);
        this.compExeRelatedInstances.compStateMachine = compExeInstancesFactory.createComponentStateMachine(this.compExeRelatedInstances);
        this.compExeRelatedInstances.compExeScheduler = compExeInstancesFactory.createComponentExecutionScheduler(this.compExeRelatedInstances);
    }

    @Override
    public void prepare() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PREPARE_REQUESTED));
    }

    @Override
    public void start() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.START_REQUESTED));
    }

    @Override
    public void pause() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PAUSE_REQUESTED));
    }

    @Override
    public void resume() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESUME_REQUESTED));
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException("Restarting components not yet implemented");
    }

    @Override
    public void cancel() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.CANCEL_REQUESTED));
    }

    @Override
    public boolean cancelSync(long timeoutMsec) throws InterruptedException {
        this.cancel();
        long startTime = System.currentTimeMillis();
        do {
            Thread.sleep(400L);
            if (!ComponentConstants.FINAL_COMPONENT_STATES.contains(this.compExeRelatedInstances.compStateMachine.getState())) continue;
            return true;
        } while (System.currentTimeMillis() - startTime > timeoutMsec);
        return false;
    }

    @Override
    public void dispose() {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.DISPOSE_REQUESTED));
    }

    @Override
    public void onEndpointDatumReceived(EndpointDatum endpointDatum) {
        this.compExeRelatedInstances.compExeScheduler.validateAndQueueEndpointDatum(endpointDatum);
        if (VERBOSE_LOGGING) {
            LOG.debug((Object)StringUtils.format((String)"Received at %s@%s: %s (from %s)", (Object[])new Object[]{endpointDatum.getInputName(), this.compInstanceName, endpointDatum.getValue(), endpointDatum.getOutputsComponentExecutionIdentifier()}));
        }
    }

    @Override
    public void onSendingEndointDatumFailed(EndpointDatum endpointDatum, RemoteOperationException e) {
        this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED, new ComponentExecutionException(StringUtils.format((String)"Failed to send output value to input '%s' of '%s' at %s", (Object[])new Object[]{endpointDatum.getInputName(), endpointDatum.getInputsComponentInstanceName(), endpointDatum.getDestinationNodeId()}), e)));
    }

    @Override
    public ComponentState getState() {
        return (ComponentState)this.compExeRelatedInstances.compStateMachine.getState();
    }

    @Override
    public String getVerificationToken() {
        return this.compExeRelatedInstances.compStateMachine.getVerificationToken();
    }

    @Override
    public boolean isWorkflowControllerReachable() {
        return this.compExeRelatedInstances.compStateMachine.isWorkflowControllerReachable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyResults(String verificationToken, boolean verified) {
        Object object = this.verifyLock;
        synchronized (object) {
            block6: {
                if (this.compExeRelatedInstances.compStateMachine.getVerificationToken() != null && this.compExeRelatedInstances.compStateMachine.getVerificationToken().equals(verificationToken)) break block6;
                return false;
            }
            if (verified) {
                this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESULTS_APPROVED));
            } else {
                this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESULTS_REJECTED));
            }
            return true;
        }
    }

    protected void bindComponentExecutionRelatedInstancesFactory(ComponentExecutionRelatedInstancesFactory newService) {
        compExeInstancesFactory = newService;
    }

    protected ComponentExecutionRelatedInstances geComponentExecutionRelatedInstances() {
        return this.compExeRelatedInstances;
    }
}

