/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.scripting;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.scripting.ScriptDataTypeHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class ScriptingUtils {
    public static final Object SCRIPT_EVAL_LOCK_OBJECT = new Object();
    protected static final Log LOGGER = LogFactory.getLog(ScriptingUtils.class);
    private static final String BUNDLE_CONTAINING_JYTHON_JAR = "de.rcenvironment.platform.maven.other";
    private static final String PATH_TO_JYTHON_JAR = "lib/maven/jython-standalone-2.5.1.jar";
    private static final String NOT_A_VALUE_UUID = "not_a_value_7fdc603e";
    private static final String USE_PYTHON_AS_SCRIPT_LANGUAGE_INSTEAD_STRING = " use Python as script language instead";
    private static File jythonPath = null;
    private static final String SLASH = "/";
    private static final String ESCAPESLASH = "\\\\";
    private static final String QUOTE = "\"";
    private static final String CLOSE_LIST_NEWLINE = "]\n";
    private static final String COMMA = ",";
    private static final int MAXIMUM_SMALL_TABLE_ENTRIES = 10000;
    private static TypedDatumFactory typedDatumFactory;
    private static ComponentDataManagementService componentDatamanagementService;

    public static synchronized File getJythonPath() throws IOException {
        if (jythonPath == null) {
            URI resolvedURI;
            Bundle bundle = Platform.getBundle((String)BUNDLE_CONTAINING_JYTHON_JAR);
            URL fileURL = bundle.getEntry(PATH_TO_JYTHON_JAR);
            URL resolvedFileURL = FileLocator.toFileURL((URL)fileURL);
            try {
                resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            jythonPath = new File(resolvedURI).toPath().resolve("Lib").toFile();
        }
        return jythonPath;
    }

    public static synchronized void setJythonPath(File path) {
        jythonPath = path;
    }

    public static String prepareOrderedDictionaryScript() throws ComponentException {
        String orderedDictScript = "";
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = ScriptingUtils.class.getResourceAsStream("/resources/ordered_dict.py");){
                orderedDictScript = IOUtils.toString((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Internal error: Failed to intialize trak config factory script that is wrapped around the actual script", (Throwable)e);
        }
        return orderedDictScript;
    }

    public static String prepareInputFileFactoryScript(String path) throws ComponentException {
        String inputFileFactoryScript = "";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = ScriptingUtils.class.getResourceAsStream("/resources/input_file_factory.py");){
                inputFileFactoryScript = IOUtils.toString((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Internal error: Failed to intialize input file factory script that is wrapped around the actual script", (Throwable)e);
        }
        inputFileFactoryScript = String.valueOf(inputFileFactoryScript) + "\nInputFileFactory.p = '" + path + "/'";
        return inputFileFactoryScript;
    }

    public static String prepareHeaderScript(Map<String, Object> localStateMap, ComponentContext componentContext, File tempDir, List<File> tempFiles) throws ComponentException {
        String currentHeader = "";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = ScriptingUtils.class.getResourceAsStream("/resources/RCE_Jython.py");){
                currentHeader = IOUtils.toString((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Internal error: Failed to intialize header script that is wrapped around the actual script", (Throwable)e);
        }
        String stateMapDefinition = "RCE_STATE_VARIABLES = {";
        boolean first = true;
        for (String key : localStateMap.keySet()) {
            if (!first) {
                stateMapDefinition = String.valueOf(stateMapDefinition) + COMMA;
            } else {
                first = false;
            }
            stateMapDefinition = String.valueOf(stateMapDefinition) + QUOTE + key + "\" : " + localStateMap.get(key);
        }
        stateMapDefinition = String.valueOf(stateMapDefinition) + "}";
        currentHeader = String.valueOf(currentHeader) + stateMapDefinition + "\n";
        currentHeader = String.valueOf(currentHeader) + ScriptingUtils.prepareInput(tempDir, componentContext, tempFiles);
        String wrappingScript = "RCE_LIST_OUTPUTNAMES = [";
        first = true;
        for (String outputName : componentContext.getOutputs()) {
            if (!first) {
                wrappingScript = String.valueOf(wrappingScript) + COMMA;
            } else {
                first = false;
            }
            wrappingScript = String.valueOf(wrappingScript) + " \"" + outputName + QUOTE;
        }
        wrappingScript = String.valueOf(wrappingScript) + CLOSE_LIST_NEWLINE;
        currentHeader = String.valueOf(currentHeader) + StringUtils.format((String)"RCE_CURRENT_RUN_NUMBER = %s\n", (Object[])new Object[]{componentContext.getExecutionCount()});
        currentHeader = String.valueOf(currentHeader) + wrappingScript;
        currentHeader = String.valueOf(currentHeader) + "RCE.setDictionary_internal(RCE_Dict_InputChannels)\nimport shutil\n";
        LinkedList<String> notConnected = new LinkedList<String>();
        for (String input : componentContext.getInputsNotConnected()) {
            if (componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name()) && !componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.NotRequired.name())) continue;
            notConnected.add(input);
        }
        for (String input : componentContext.getInputs()) {
            if (componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.NotRequired.name()) || componentContext.getInputsWithDatum().contains(input)) continue;
            notConnected.add(input);
        }
        String notConnectedValues = "[";
        for (String input : notConnected) {
            notConnectedValues = String.valueOf(notConnectedValues) + QUOTE + input + "\",";
        }
        notConnectedValues.substring(0, notConnectedValues.length() - 1);
        notConnectedValues = String.valueOf(notConnectedValues) + "]";
        currentHeader = String.valueOf(currentHeader) + StringUtils.format((String)"RCE_LIST_REQ_IF_CONNECTED_INPUTS = %s\n", (Object[])new Object[]{notConnectedValues});
        return currentHeader;
    }

    private static String prepareInput(File tempDir, ComponentContext compContext, List<File> tempFiles) throws ComponentException {
        String dataDefinition = "RCE_Dict_InputChannels = { ";
        String nameAndValue = "";
        for (String inputName : compContext.getInputsWithDatum()) {
            nameAndValue = " \"" + StringEscapeUtils.escapeJava((String)inputName) + "\" : ";
            TypedDatum input = compContext.readInput(inputName);
            switch (compContext.getInputDataType(inputName)) {
                case FileReference: {
                    File fileInputDir = new File(tempDir, inputName);
                    tempFiles.add(fileInputDir);
                    File file = new File(fileInputDir, ((FileReferenceTD)input).getFileName());
                    try {
                        if (!file.exists()) {
                            componentDatamanagementService.copyFileReferenceTDToLocalFile(compContext, (FileReferenceTD)input, file);
                        }
                    }
                    catch (IOException e) {
                        throw new ComponentException("Failed to read input file from the data management", (Throwable)e);
                    }
                    nameAndValue = String.valueOf(nameAndValue) + QUOTE + file.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH) + QUOTE;
                    break;
                }
                case DirectoryReference: {
                    File dirInputDir = new File(tempDir, inputName);
                    tempFiles.add(dirInputDir);
                    File dir = new File(dirInputDir, ((DirectoryReferenceTD)input).getDirectoryName());
                    try {
                        if (!dir.exists()) {
                            componentDatamanagementService.copyDirectoryReferenceTDToLocalDirectory(compContext, (DirectoryReferenceTD)input, dirInputDir);
                        }
                    }
                    catch (IOException e) {
                        throw new ComponentException("Failed to read input directory from the data management", (Throwable)e);
                    }
                    nameAndValue = String.valueOf(nameAndValue) + QUOTE + dir.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH) + QUOTE;
                    break;
                }
                case Boolean: {
                    boolean bool = ((BooleanTD)input).getBooleanValue();
                    if (bool) {
                        nameAndValue = String.valueOf(nameAndValue) + "True";
                        break;
                    }
                    nameAndValue = String.valueOf(nameAndValue) + "False";
                    break;
                }
                case ShortText: {
                    String value = ((ShortTextTD)input).getShortTextValue();
                    if (value.contains("\n")) {
                        nameAndValue = String.valueOf(nameAndValue) + "\"\"\"" + StringEscapeUtils.escapeJava((String)value) + QUOTE + QUOTE + QUOTE;
                        break;
                    }
                    nameAndValue = String.valueOf(nameAndValue) + QUOTE + StringEscapeUtils.escapeJava((String)value) + QUOTE;
                    break;
                }
                case Integer: {
                    nameAndValue = String.valueOf(nameAndValue) + input;
                    break;
                }
                case Float: {
                    String append = ScriptingUtils.replaceNonNumericValue(((FloatTD)input).getFloatValue());
                    if (append.isEmpty()) {
                        nameAndValue = String.valueOf(nameAndValue) + ((FloatTD)input).getFloatValue();
                        break;
                    }
                    nameAndValue = String.valueOf(nameAndValue) + append;
                    break;
                }
                case Empty: {
                    nameAndValue = "None";
                    break;
                }
                case Vector: {
                    VectorTD vector = (VectorTD)input;
                    nameAndValue = String.valueOf(nameAndValue) + "[";
                    if (vector.getRowDimension() > 10000) {
                        throw new ComponentException(StringUtils.format((String)"Vector of input '%s' exceeds maximum number of entries allowed for Jython (entries: %s; maximum: %s); use Python as script language instead", (Object[])new Object[]{inputName, vector.getRowDimension(), 10000}));
                    }
                    int i = 0;
                    while (i < vector.getRowDimension()) {
                        String appending = ScriptingUtils.replaceNonNumericValue(vector.getFloatTDOfElement(i).getFloatValue());
                        nameAndValue = appending.isEmpty() ? String.valueOf(nameAndValue) + vector.getFloatTDOfElement(i).getFloatValue() : String.valueOf(nameAndValue) + appending;
                        nameAndValue = String.valueOf(nameAndValue) + COMMA;
                        ++i;
                    }
                    if (vector.getRowDimension() > 0) {
                        nameAndValue = nameAndValue.substring(0, nameAndValue.length() - 1);
                    }
                    nameAndValue = String.valueOf(nameAndValue) + CLOSE_LIST_NEWLINE;
                    break;
                }
                case Matrix: {
                    MatrixTD matrix = (MatrixTD)input;
                    nameAndValue = String.valueOf(nameAndValue) + "[";
                    nameAndValue = ScriptingUtils.getMatrix("[", nameAndValue, inputName, matrix);
                    nameAndValue = nameAndValue.substring(0, nameAndValue.length() - 1);
                    nameAndValue = String.valueOf(nameAndValue) + CLOSE_LIST_NEWLINE;
                    break;
                }
                case SmallTable: {
                    nameAndValue = ScriptingUtils.convertSmallTable("[", nameAndValue, inputName, input);
                    break;
                }
            }
            dataDefinition = String.valueOf(dataDefinition) + nameAndValue;
            dataDefinition = String.valueOf(dataDefinition) + " ,";
        }
        dataDefinition = dataDefinition.substring(0, dataDefinition.length() - 1);
        dataDefinition = String.valueOf(dataDefinition) + "}\n";
        return dataDefinition;
    }

    private static String convertSmallTable(String openBracket, String nameAndValue, String inputName, TypedDatum input) throws ComponentException {
        SmallTableTD table = (SmallTableTD)input;
        nameAndValue = String.valueOf(nameAndValue) + openBracket;
        if (table.getRowCount() * table.getColumnCount() > 10000) {
            throw new ComponentException(StringUtils.format((String)"Small Table of input '%s' exceeds maximum number of entries allowed for Jython (entries: %s; maximum: %s); use Python as script language instead", (Object[])new Object[]{inputName, table.getRowCount() * table.getColumnCount(), 10000}));
        }
        int i = 0;
        while (i < table.getRowCount()) {
            if (table.getRowCount() > 1) {
                nameAndValue = String.valueOf(nameAndValue) + openBracket;
            }
            int j = 0;
            while (j < table.getColumnCount()) {
                nameAndValue = ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(i, j)) instanceof String ? String.valueOf(nameAndValue) + QUOTE + ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(i, j)) + QUOTE + COMMA : (ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(i, j)) instanceof Double ? String.valueOf(nameAndValue) + ScriptingUtils.replaceNonNumericValue(((FloatTD)table.getTypedDatumOfCell(i, j)).getFloatValue()) + COMMA : String.valueOf(nameAndValue) + ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(i, j)) + COMMA);
                ++j;
            }
            nameAndValue = nameAndValue.substring(0, nameAndValue.length() - 1);
            nameAndValue = table.getRowCount() > 1 ? String.valueOf(nameAndValue) + "]," : String.valueOf(nameAndValue) + COMMA;
            ++i;
        }
        nameAndValue = nameAndValue.substring(0, nameAndValue.length() - 1);
        nameAndValue = String.valueOf(nameAndValue) + CLOSE_LIST_NEWLINE;
        return nameAndValue;
    }

    private static String replaceNonNumericValue(double floatValue) {
        String result = "";
        result = floatValue == Double.NEGATIVE_INFINITY ? String.valueOf(result) + "float(\"-INF\")" : (floatValue == Double.POSITIVE_INFINITY ? String.valueOf(result) + "float(\"INF\")" : (Double.isNaN(floatValue) ? String.valueOf(result) + "float(\"nan\")" : String.valueOf(result) + floatValue));
        return result;
    }

    private static String getMatrix(String openBracket, String nameAndValue, String inputName, MatrixTD matrix) throws ComponentException {
        if (matrix.getRowDimension() * matrix.getColumnDimension() > 10000) {
            throw new ComponentException(StringUtils.format((String)"Small Table of input '%s' exceeds maximum number of entries allowed for Jython (entries: %s; maximum: %s); use Python as script language instead", (Object[])new Object[]{inputName, matrix.getRowDimension() * matrix.getColumnDimension(), 10000}));
        }
        int i = 0;
        while (i < matrix.getRowDimension()) {
            if (matrix.getRowDimension() > 1) {
                nameAndValue = String.valueOf(nameAndValue) + openBracket;
            }
            int j = 0;
            while (j < matrix.getColumnDimension()) {
                if (ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j)) instanceof String) {
                    nameAndValue = String.valueOf(nameAndValue) + QUOTE + ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j)) + QUOTE + COMMA;
                } else if (ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j)) instanceof Double) {
                    String append = ScriptingUtils.replaceNonNumericValue(matrix.getFloatTDOfElement(i, j).getFloatValue());
                    nameAndValue = append.isEmpty() ? String.valueOf(nameAndValue) + ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j)) : String.valueOf(nameAndValue) + append;
                    nameAndValue = String.valueOf(nameAndValue) + COMMA;
                } else {
                    nameAndValue = String.valueOf(nameAndValue) + ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j)) + COMMA;
                }
                ++j;
            }
            nameAndValue = nameAndValue.substring(0, nameAndValue.length() - 1);
            nameAndValue = matrix.getRowDimension() > 1 ? String.valueOf(nameAndValue) + "]," : String.valueOf(nameAndValue) + COMMA;
            ++i;
        }
        return nameAndValue;
    }

    public static void writeAPIOutput(Map<String, Object> stateMap, ComponentContext componentContext, ScriptEngine engine, String workingPath, ComponentHistoryDataItem historyDataItem) throws ComponentException {
        ScriptingUtils.writeAPIOutput(stateMap, componentContext, engine, workingPath, historyDataItem, null);
    }

    public static void writeAPIOutput(Map<String, Object> stateMap, ComponentContext componentContext, ScriptEngine engine, String workingPath, ComponentHistoryDataItem historyDataItem, Map<String, TypedDatum> lastRunStaticOutputValues) throws ComponentException {
        Map map = (Map)engine.get("RCE_Dict_OutputChannels");
        for (String outputName : componentContext.getOutputs()) {
            DataType type = componentContext.getOutputDataType(outputName);
            List datas = (List)map.get(outputName);
            if (datas == null) continue;
            for (Object value : datas) {
                if (value != null && !String.valueOf(value).equals(NOT_A_VALUE_UUID)) {
                    TypedDatum outputValue = ScriptingUtils.getOutputByType(value, type, outputName, workingPath, componentContext);
                    ScriptingUtils.writeOutput(componentContext, historyDataItem, lastRunStaticOutputValues, outputName, outputValue);
                    continue;
                }
                if (!String.valueOf(value).equals(NOT_A_VALUE_UUID)) continue;
                ScriptingUtils.writeOutput(componentContext, historyDataItem, lastRunStaticOutputValues, outputName, (TypedDatum)typedDatumFactory.createNotAValue());
            }
        }
        Map stateMapOutput = (Map)engine.get("RCE_STATE_VARIABLES");
        for (String key : stateMapOutput.keySet()) {
            stateMap.put(key, stateMapOutput.get(key));
        }
        for (String endpointName : (List)engine.get("RCE_CloseOutputChannelsList")) {
            componentContext.closeOutput(endpointName);
        }
        for (String item : (List)engine.get("RCE_writtenInputFiles")) {
            LOGGER.debug((Object)("The Input File Factory has written the following file: " + item));
        }
    }

    private static void writeOutput(ComponentContext componentContext, ComponentHistoryDataItem historyDataItem, Map<String, TypedDatum> lastRunStaticOutputValues, String outputName, TypedDatum outputValue) {
        componentContext.writeOutput(outputName, outputValue);
        if (lastRunStaticOutputValues != null) {
            lastRunStaticOutputValues.put(outputName, outputValue);
        }
        ScriptingUtils.addOutputToHistoryDataItem(outputName, outputValue, historyDataItem);
    }

    public static Set<String> getOutputsSendingNotAValue(ScriptEngine engine, ComponentContext componentContext) {
        Map map = (Map)engine.get("RCE_Dict_OutputChannels");
        HashSet<String> returnSet = new HashSet<String>();
        block0: for (String outputName : componentContext.getOutputs()) {
            List datas = (List)map.get(outputName);
            if (datas == null) continue;
            for (Object value : datas) {
                if (value == null || !String.valueOf(value).equals(NOT_A_VALUE_UUID)) continue;
                returnSet.add(outputName);
                continue block0;
            }
        }
        return returnSet;
    }

    public static TypedDatum getOutputByType(Object value, DataType type, String name, String workingPath, ComponentContext componentContext) throws ComponentException {
        TypedDatum outputValue = null;
        switch (type) {
            case FileReference: {
                outputValue = ScriptingUtils.handeFileOrDirectoryOutput(value, "file", name, workingPath, componentContext, outputValue);
                break;
            }
            case DirectoryReference: {
                outputValue = ScriptingUtils.handeFileOrDirectoryOutput(value, "directory ", name, workingPath, componentContext, outputValue);
                break;
            }
            default: {
                outputValue = ScriptDataTypeHelper.parseToTypedDatum(value, typedDatumFactory, type);
            }
        }
        return outputValue;
    }

    private static TypedDatum handeFileOrDirectoryOutput(Object value, String type, String name, String workingPath, ComponentContext componentContext, TypedDatum outputValue) throws ComponentException {
        block8: {
            try {
                File file = new File(value.toString());
                if (!file.isAbsolute()) {
                    file = new File(workingPath, value.toString());
                }
                if (file.exists()) {
                    if (type.equals("file")) {
                        if (file.isDirectory()) {
                            throw new ComponentException(StringUtils.format((String)"Failed to write %s to output '%s' as it is a directory.", (Object[])new Object[]{file.getAbsolutePath(), name}));
                        }
                        outputValue = componentDatamanagementService.createFileReferenceTDFromLocalFile(componentContext, file, file.getName());
                    } else {
                        if (!file.isDirectory()) {
                            throw new ComponentException(StringUtils.format((String)"Failed to write %s to output '%s' as it is not a directory.", (Object[])new Object[]{file.getAbsolutePath(), name}));
                        }
                        outputValue = componentDatamanagementService.createDirectoryReferenceTDFromLocalDirectory(componentContext, file, file.getName());
                    }
                    break block8;
                }
                throw new ComponentException(StringUtils.format((String)"Failed to write %s to output '%s' as it does not exist: %s", (Object[])new Object[]{type, name, file.getAbsolutePath()}));
            }
            catch (IOException e) {
                throw new ComponentException(StringUtils.format((String)"Failed to store %s into the data management - if it is not stored in the data management, it can not be sent as output value", (Object[])new Object[]{type}), (Throwable)e);
            }
        }
        return outputValue;
    }

    private static void addOutputToHistoryDataItem(String name, TypedDatum outputValue, ComponentHistoryDataItem historyDataItem) {
        if (historyDataItem != null) {
            ((CommonComponentHistoryDataItem)historyDataItem).addOutput(name, outputValue);
        }
    }

    public void bindTypedDatumService(TypedDatumService newTypedDatumService) {
        typedDatumFactory = newTypedDatumService.getFactory();
    }

    public void unbindTypedDatumService(TypedDatumService oldTypedDatumService) {
    }

    public void bindComponentDataManagementService(ComponentDataManagementService compDataManagementService) {
        componentDatamanagementService = compDataManagementService;
    }

    public void unbindComponentDataManagementService(ComponentDataManagementService compDataManagementService) {
        componentDatamanagementService = null;
    }
}

