/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.gui;

import de.rcenvironment.components.evaluationmemory.gui.EvaluationMemoryEndpointEditDialog;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.gui.workflow.editor.properties.InputCoupledWithOutputSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EvaluationMemoryInputPaneToEvaluate
extends InputCoupledWithOutputSelectionPane {
    public EvaluationMemoryInputPaneToEvaluate(String title, String endpointId, WorkflowNodeCommand.Executor executor, Refreshable outputPane) {
        super(title, endpointId, executor, outputPane);
    }

    protected void onAddClicked() {
        EndpointMetaDataDefinition metaDataDefinition;
        Map<String, String> metaData = new HashMap<String, String>();
        Shell parentShell = Display.getDefault().getActiveShell();
        EvaluationMemoryEndpointEditDialog dialog = new EvaluationMemoryEndpointEditDialog(parentShell, EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, metaDataDefinition = this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), metaData);
        if (dialog.open() == 0) {
            String name = dialog.getChosenName();
            DataType type = dialog.getChosenDataType();
            metaData = dialog.getMetadataValues();
            this.appendPercentageSignToTolerance(metaData);
            this.executeAddCommand(name, type, metaData);
        }
    }

    private void appendPercentageSignToTolerance(Map<String, String> metaData) {
        String toleranceText;
        if (metaData.containsKey("tolerance") && !(toleranceText = metaData.get("tolerance")).isEmpty()) {
            metaData.put("tolerance", String.valueOf(toleranceText) + "%");
        }
    }

    private void removePercentageSignFromTolerance(Map<String, String> metaData) {
        String toleranceText;
        if (metaData.containsKey("tolerance") && !(toleranceText = metaData.get("tolerance")).isEmpty()) {
            metaData.put("tolerance", toleranceText.substring(0, toleranceText.length() - 1));
        }
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        Shell parentShell = Display.getDefault().getActiveShell();
        EndpointMetaDataDefinition metaDataDefinition = this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition();
        this.removePercentageSignFromTolerance(newMetaData);
        EvaluationMemoryEndpointEditDialog dialog = new EvaluationMemoryEndpointEditDialog(parentShell, EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, metaDataDefinition, newMetaData);
        this.onEditClicked(name, dialog);
    }

    protected void editEndpoint(EndpointDescription oldDesc, String newName, DataType newType, Map<String, String> newMetaData) {
        this.appendPercentageSignToTolerance(newMetaData);
        super.editEndpoint(oldDesc, newName, newType, newMetaData);
    }
}

