/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.gui;

import de.rcenvironment.components.evaluationmemory.common.EvaluationMemoryComponentConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EvaluationMemoryFileSection
extends ValidatingWorkflowNodePropertySection {
    private Text memoryFilePathText;
    private Button selectFilePathButton;
    private Button strictButton;
    private Button lenientButton;
    private PropertyChangeListener propertyListener = evt -> {
        if (evt.getNewValue() instanceof EndpointChange && !this.strictButton.isDisposed()) {
            if (this.containsTolerantInputs()) {
                this.enableToleranceOverlapButtons();
            } else {
                this.disableToleranceOverlapButtons();
            }
        }
    };

    protected void createCompositeContent(final Composite parent, TabbedPropertySheetPage propSheetPage) {
        super.createCompositeContent(parent, propSheetPage);
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Section memFileSection = propSheetPage.getWidgetFactory().createSection(parent, 256);
        memFileSection.setLayout((Layout)new GridLayout());
        memFileSection.setLayoutData((Object)new GridData(772));
        memFileSection.setText("Evaluation Memory File");
        Composite memFileComposite = propSheetPage.getWidgetFactory().createComposite(parent);
        memFileComposite.setLayout((Layout)new GridLayout(2, true));
        memFileComposite.setLayoutData((Object)new GridData(772));
        Button selectAtWfStartButton = new Button(memFileComposite, 32);
        selectAtWfStartButton.setText("Select at workflow start");
        selectAtWfStartButton.setBackground(memFileComposite.getDisplay().getSystemColor(1));
        selectAtWfStartButton.setData("property.control", (Object)"select_at_wf_start");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        selectAtWfStartButton.setLayoutData((Object)gridData);
        this.memoryFilePathText = new Text(memFileComposite, 2116);
        this.memoryFilePathText.setData("property.control", (Object)"mem_file");
        this.memoryFilePathText.setLayoutData((Object)new GridData(768));
        this.selectFilePathButton = new Button(memFileComposite, 8);
        this.selectFilePathButton.setText("...");
        this.selectFilePathButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                String path = dialog.open();
                if (path != null) {
                    EvaluationMemoryFileSection.this.memoryFilePathText.setText(path);
                }
            }
        });
        Section memOptionsSection = propSheetPage.getWidgetFactory().createSection(parent, 256);
        memOptionsSection.setLayout((Layout)new GridLayout());
        memOptionsSection.setLayoutData((Object)new GridData(772));
        memOptionsSection.setText("Evaluation Memory Options");
        Composite memOptionsComposite = propSheetPage.getWidgetFactory().createComposite(parent);
        memOptionsComposite.setLayout((Layout)new GridLayout(1, false));
        memOptionsComposite.setLayoutData((Object)new GridData(772));
        Button storeLoopFailures = new Button(memOptionsComposite, 32);
        storeLoopFailures.setData("property.control", (Object)"store_failures");
        storeLoopFailures.setText("Consider loop failures as valid loop results (values of type not-a-value that are explicitly sent by components)");
        storeLoopFailures.setBackground(memOptionsComposite.getDisplay().getSystemColor(1));
        TabbedPropertySheetWidgetFactory factory = propSheetPage.getWidgetFactory();
        this.appendToleranceOverlapConfigurationSection(parent, factory);
    }

    private void appendToleranceOverlapConfigurationSection(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        Section sectionOverlap = this.appendTitleBar(parent, factory);
        Composite compositeOverlap = factory.createFlatFormComposite((Composite)sectionOverlap);
        this.appendLabel(factory, compositeOverlap);
        this.appendStrictButton(factory, compositeOverlap);
        this.appendLenientButton(factory, compositeOverlap);
        sectionOverlap.setClient((Control)compositeOverlap);
    }

    private Section appendTitleBar(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        Section sectionOverlap = factory.createSection(parent, 256);
        sectionOverlap.setLayout((Layout)new GridLayout());
        sectionOverlap.setLayoutData((Object)new GridData(772));
        sectionOverlap.setText("Handling overlapping tolerance-intervals");
        return sectionOverlap;
    }

    private void appendLabel(TabbedPropertySheetWidgetFactory factory, Composite compositeOverlap) {
        compositeOverlap.setLayout((Layout)new GridLayout(3, false));
        factory.createLabel(compositeOverlap, "If the tolerance-interval around the input values contains multiple previously evaluated values:");
    }

    private void appendStrictButton(TabbedPropertySheetWidgetFactory factory, Composite compositeOverlap) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.strictButton = factory.createButton(compositeOverlap, "Strict: Evaluate with exact input-values", 16);
        this.strictButton.setLayoutData((Object)gridData);
        this.strictButton.setData("tolerance_overlap_behavior", (Object)EvaluationMemoryComponentConstants.OverlapBehavior.STRICT);
        this.strictButton.setData("property.control", (Object)"tolerance_overlap_behavior");
    }

    private void appendLenientButton(TabbedPropertySheetWidgetFactory factory, Composite compositeOverlap) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.lenientButton = factory.createButton(compositeOverlap, "Lenient: Return any previous evaluation within tolerance", 16);
        this.lenientButton.setLayoutData((Object)gridData);
        this.lenientButton.setData("tolerance_overlap_behavior", (Object)EvaluationMemoryComponentConstants.OverlapBehavior.LENIENT);
        this.lenientButton.setData("property.control", (Object)"tolerance_overlap_behavior");
    }

    private boolean containsTolerantInputs() {
        Set inputs = this.getInputs();
        for (EndpointDescription input : inputs) {
            boolean toleranceValueIsNonDefault;
            Map metaData = input.getMetaData();
            boolean containsToleranceKey = metaData.containsKey("tolerance");
            if (!containsToleranceKey) continue;
            String toleranceValue = (String)metaData.get("tolerance");
            boolean bl = toleranceValueIsNonDefault = !toleranceValue.isEmpty();
            if (!toleranceValueIsNonDefault) continue;
            return true;
        }
        return false;
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        ComponentInstanceProperties config = this.getConfiguration();
        config.addPropertyChangeListener(this.propertyListener);
    }

    private void enableFilePickerWidgets(boolean enabled) {
        this.memoryFilePathText.setEnabled(enabled);
        this.selectFilePathButton.setEnabled(enabled);
    }

    private void disableToleranceOverlapButtons() {
        this.strictButton.setEnabled(false);
        this.lenientButton.setEnabled(false);
    }

    private void enableToleranceOverlapButtons() {
        this.strictButton.setEnabled(true);
        this.lenientButton.setEnabled(true);
    }

    public void refreshSection() {
        super.refreshSection();
        boolean containsTolerantInputs = this.containsTolerantInputs();
        if (containsTolerantInputs) {
            this.enableToleranceOverlapButtons();
        } else {
            this.disableToleranceOverlapButtons();
        }
    }

    protected void beforeTearingDownModelBinding() {
        super.beforeTearingDownModelBinding();
        ComponentInstanceProperties config = this.getConfiguration();
        config.removePropertyChangeListener(this.propertyListener);
    }

    protected EvaluationMemoryFileDefaultUpdater createUpdater() {
        return new EvaluationMemoryFileDefaultUpdater();
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new EvaluationMemoryController();
    }

    protected class EvaluationMemoryController
    extends WorkflowNodePropertySection.DefaultController {
        protected EvaluationMemoryController() {
            super((WorkflowNodePropertySection)EvaluationMemoryFileSection.this);
        }

        public void widgetSelected(SelectionEvent event) {
            if (!(event.getSource() instanceof Button)) {
                return;
            }
            Button button = (Button)event.getSource();
            String key = (String)button.getData("property.control");
            if (key == null) {
                return;
            }
            if (key.equals("select_at_wf_start")) {
                EvaluationMemoryFileSection.this.enableFilePickerWidgets(!button.getSelection());
                EvaluationMemoryFileSection.this.setProperty(key, Boolean.toString(button.getSelection()));
            }
            if (key.equals("store_failures")) {
                EvaluationMemoryFileSection.this.setProperty(key, Boolean.toString(button.getSelection()));
            }
            if (key.equals("tolerance_overlap_behavior")) {
                if (button.getData("tolerance_overlap_behavior").equals(EvaluationMemoryComponentConstants.OverlapBehavior.STRICT)) {
                    this.setThresholdOverlapBehavior(EvaluationMemoryComponentConstants.OverlapBehavior.STRICT);
                    EvaluationMemoryFileSection.this.strictButton.setSelection(true);
                } else {
                    this.setThresholdOverlapBehavior(EvaluationMemoryComponentConstants.OverlapBehavior.LENIENT);
                    EvaluationMemoryFileSection.this.lenientButton.setSelection(true);
                }
            }
        }

        private void setThresholdOverlapBehavior(EvaluationMemoryComponentConstants.OverlapBehavior behavior) {
            EvaluationMemoryFileSection.this.setProperty("tolerance_overlap_behavior", behavior.toString());
        }
    }

    protected class EvaluationMemoryFileDefaultUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected EvaluationMemoryFileDefaultUpdater() {
            super((WorkflowNodePropertySection)EvaluationMemoryFileSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (control instanceof Button && propertyName.equals("select_at_wf_start")) {
                EvaluationMemoryFileSection.this.enableFilePickerWidgets(Boolean.valueOf(newValue) == false);
            }
            if (control instanceof Button && propertyName.equals("tolerance_overlap_behavior")) {
                String overlapBehaviorString = EvaluationMemoryFileSection.this.getConfiguration().getConfigurationDescription().getConfigurationValue(propertyName);
                switch (EvaluationMemoryComponentConstants.OverlapBehavior.parseConfigValue((String)overlapBehaviorString)) {
                    case LENIENT: {
                        EvaluationMemoryFileSection.this.lenientButton.setSelection(true);
                        break;
                    }
                    case STRICT: {
                        EvaluationMemoryFileSection.this.strictButton.setSelection(true);
                        break;
                    }
                    default: {
                        EvaluationMemoryFileSection.this.strictButton.setSelection(true);
                    }
                }
            }
        }
    }
}

