/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.io.WriteAbortedException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class Nio2Session
extends AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler ioHandler;
    private final AsynchronousSocketChannel socketChannel;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress acceptanceAddress;
    private final FactoryManager manager;
    private final Queue<Nio2DefaultIoWriteFuture> writes = new LinkedTransferQueue<Nio2DefaultIoWriteFuture>();
    private final AtomicReference<Nio2DefaultIoWriteFuture> currentWrite = new AtomicReference();

    public Nio2Session(Nio2Service service, FactoryManager manager, IoHandler handler, AsynchronousSocketChannel socket, SocketAddress acceptanceAddress) throws IOException {
        this.service = Objects.requireNonNull(service, "No service instance");
        this.manager = Objects.requireNonNull(manager, "No factory manager");
        this.ioHandler = Objects.requireNonNull(handler, "No IoHandler");
        this.socketChannel = Objects.requireNonNull(socket, "No socket channel");
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        this.acceptanceAddress = acceptanceAddress;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating IoSession on {} from {} via {}", new Object[]{this.localAddress, this.remoteAddress, acceptanceAddress});
        }
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttributeIfAbsent(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public AsynchronousSocketChannel getSocket() {
        return this.socketChannel;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void suspend() {
        AsynchronousSocketChannel socket = this.getSocket();
        try {
            socket.shutdownInput();
        }
        catch (IOException e) {
            this.log.warn("suspend({}) failed ({}) to shutdown input: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException e) {
            this.log.warn("suspend({}) failed ({}) to shutdown output: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
        }
    }

    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writePacket({}) Writing {} bytes", (Object)this, (Object)buffer.available());
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture(this.getRemoteAddress(), null, buf);
        if (this.isClosing()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void exceptionCaught(Throwable exc) {
        block5: {
            if (this.closeFuture.isClosed()) {
                return;
            }
            AsynchronousSocketChannel socket = this.getSocket();
            if (this.isOpen() && socket.isOpen()) {
                IoHandler handler = this.getIoHandler();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("exceptionCaught({}) caught {}[{}] - calling handler", new Object[]{this, exc.getClass().getSimpleName(), exc.getMessage()});
                    }
                    handler.exceptionCaught((IoSession)this, exc);
                }
                catch (Throwable e) {
                    Throwable t = GenericUtils.peelException((Throwable)e);
                    this.log.warn("exceptionCaught({}) Exception handler threw {}, closing the session: {}", new Object[]{this, t.getClass().getSimpleName(), t.getMessage()});
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.warn("exceptionCaught(" + (Object)((Object)this) + ") exception handler failure details", t);
                }
            }
        }
        this.close(true);
    }

    protected CloseFuture doCloseGracefully() {
        String closeId = this.toString();
        return this.builder().when((Object)closeId, this.writes).run((Object)closeId, () -> {
            try {
                AsynchronousSocketChannel socket = this.getSocket();
                socket.shutdownOutput();
            }
            catch (IOException e) {
                this.log.info("doCloseGracefully({}) {} while shutting down output: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
        }).build().close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCloseImmediately() {
        block13: {
            block12: {
                Nio2DefaultIoWriteFuture future;
                boolean debugEnabled = this.log.isDebugEnabled();
                while ((future = this.writes.poll()) != null) {
                    if (future.isWritten()) {
                        if (!debugEnabled) continue;
                        this.log.debug("doCloseImmediately({}) skip already written future={}", (Object)this, (Object)future);
                        continue;
                    }
                    Throwable error = future.getException();
                    if (error != null) continue;
                    if (debugEnabled) {
                        this.log.debug("doCloseImmediately({}) signal write abort for future={}", (Object)this, (Object)future);
                    }
                    future.setException(new WriteAbortedException("Write request aborted due to immediate session close", null));
                }
                AsynchronousSocketChannel socket = this.getSocket();
                try {
                    if (debugEnabled) {
                        this.log.debug("doCloseImmediately({}) closing socket={}", (Object)this, (Object)socket);
                    }
                    socket.close();
                    if (debugEnabled) {
                        this.log.debug("doCloseImmediately({}) socket={} closed", (Object)this, (Object)socket);
                    }
                }
                catch (IOException e) {
                    this.log.info("doCloseImmediately({}) {} caught while closing socket={}: {}", new Object[]{this, e.getClass().getSimpleName(), socket, e.getMessage()});
                    if (!debugEnabled) break block12;
                    this.log.info("doCloseImmediately(" + (Object)((Object)this) + ") socket=" + socket + " close failure details", (Throwable)e);
                }
            }
            this.service.sessionClosed(this);
            super.doCloseImmediately();
            IoHandler handler = this.getIoHandler();
            try {
                handler.sessionClosed((IoSession)this);
            }
            catch (Throwable e) {
                this.log.warn("doCloseImmediately({}) {} while calling IoHandler#sessionClosed: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
                if (!this.log.isDebugEnabled()) break block13;
                this.log.warn("doCloseImmediately(" + (Object)((Object)this) + ") IoHandler#sessionClosed failure details", e);
            }
        }
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
        }
    }

    public Nio2Service getService() {
        return this.service;
    }

    public void shutdownOutputStream() throws IOException {
        AsynchronousSocketChannel socket = this.getSocket();
        if (socket.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("shudownOutputStream({})", (Object)this);
            }
            socket.shutdownOutput();
        }
    }

    public void startReading() {
        this.startReading(this.manager.getIntProperty("nio2-read-buf-size", 32768));
    }

    public void startReading(int bufSize) {
        this.startReading(new byte[bufSize]);
    }

    public void startReading(byte[] buf) {
        this.startReading(buf, 0, buf.length);
    }

    public void startReading(byte[] buf, int offset, int len) {
        this.startReading(ByteBuffer.wrap(buf, offset, len));
    }

    public void startReading(ByteBuffer buffer) {
        this.doReadCycle(buffer, Readable.readable((ByteBuffer)buffer));
    }

    protected void doReadCycle(ByteBuffer buffer, Readable bufReader) {
        Nio2CompletionHandler<Integer, Object> completion = Objects.requireNonNull(this.createReadCycleCompletionHandler(buffer, bufReader), "No completion handler created");
        this.doReadCycle(buffer, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createReadCycleCompletionHandler(final ByteBuffer buffer, final Readable bufReader) {
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.handleReadCycleCompletion(buffer, bufReader, this, result, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleReadCycleFailure(buffer, bufReader, exc, attachment);
            }
        };
    }

    protected void handleReadCycleCompletion(ByteBuffer buffer, Readable bufReader, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (result >= 0) {
                if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) read {} bytes", (Object)this, (Object)result);
                }
                buffer.flip();
                IoHandler handler = this.getIoHandler();
                handler.messageReceived((IoSession)this, bufReader);
                if (!this.closeFuture.isClosed()) {
                    buffer.clear();
                    this.doReadCycle(buffer, completionHandler);
                } else if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) IoSession has been closed, stop reading", (Object)this);
                }
            } else if (debugEnabled) {
                this.log.debug("handleReadCycleCompletion({}) Socket has been disconnected (result={}), closing IoSession now", (Object)this, (Object)result);
            }
        }
        catch (Throwable exc) {
            completionHandler.failed(exc, attachment);
        }
    }

    protected void handleReadCycleFailure(ByteBuffer buffer, Readable bufReader, Throwable exc, Object attachment) {
        this.exceptionCaught(exc);
    }

    protected void doReadCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        long readTimeout = this.manager.getLongProperty("nio2-read-timeout", FactoryManager.DEFAULT_NIO2_READ_TIMEOUT);
        socket.read(buffer, readTimeout, TimeUnit.MILLISECONDS, null, completion);
    }

    protected void startWriting() {
        Nio2DefaultIoWriteFuture future = this.writes.peek();
        if (future == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, future)) {
            return;
        }
        try {
            AsynchronousSocketChannel socket = this.getSocket();
            ByteBuffer buffer = future.getBuffer();
            Nio2CompletionHandler<Integer, Object> handler = Objects.requireNonNull(this.createWriteCycleCompletionHandler(future, socket, buffer), "No write cycle completion handler created");
            this.doWriteCycle(buffer, handler);
        }
        catch (Throwable e) {
            future.setWritten();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void doWriteCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        long writeTimeout = this.manager.getLongProperty("nio2-min-write-timeout", FactoryManager.DEFAULT_NIO2_MIN_WRITE_TIMEOUT);
        socket.write(buffer, writeTimeout, TimeUnit.MILLISECONDS, null, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createWriteCycleCompletionHandler(final Nio2DefaultIoWriteFuture future, final AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        final int writeLen = buffer.remaining();
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.handleCompletedWriteCycle(future, socket, buffer, writeLen, this, result, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleWriteCycleFailure(future, socket, buffer, writeLen, exc, attachment);
            }
        };
    }

    protected void handleCompletedWriteCycle(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        if (buffer.hasRemaining()) {
            try {
                socket.write(buffer, null, completionHandler);
            }
            catch (Throwable t) {
                this.log.warn("handleCompletedWriteCycle({}) {} while writing to socket len={}: {}", new Object[]{this, t.getClass().getSimpleName(), writeLen, t.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.warn("handleCompletedWriteCycle(" + (Object)((Object)this) + ") Exception caught while writing " + writeLen + " bytes", t);
                }
                future.setWritten();
                this.finishWrite(future);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleCompletedWriteCycle({}) finished writing len={}", (Object)this, (Object)writeLen);
            }
            this.writes.remove((Object)future);
            future.setWritten();
            this.finishWrite(future);
        }
    }

    protected void handleWriteCycleFailure(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Throwable exc, Object attachment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWriteCycleFailure({}) failed ({}) to write {} bytes: {}", new Object[]{this, exc.getClass().getSimpleName(), writeLen, exc.getMessage()});
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleWriteCycleFailure(" + (Object)((Object)this) + ") len=" + writeLen + " failure details", exc);
        }
        future.setException(exc);
        this.exceptionCaught(exc);
        try {
            this.finishWrite(future);
        }
        catch (RuntimeException e) {
            this.log.warn("handleWriteCycleFailure({}) failed ({}) to finish writing: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
        }
    }

    protected void finishWrite(Nio2DefaultIoWriteFuture future) {
        this.writes.remove((Object)future);
        this.currentWrite.compareAndSet(future, null);
        this.startWriting();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

