/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.internal;

import de.rcenvironment.core.communication.api.LogicalNodeManagementService;
import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class LogicalNodeManagementServiceImpl
implements LogicalNodeManagementService {
    private static final String NODE_PROPERTIES_PREFIX_LOGICAL_NODE_NAMES = "nodeNames/";
    @Reference
    private PlatformService platformService;
    @Reference
    private NodePropertiesService nodePropertiesService;
    @Reference
    private NodeIdentifierService nodeIdentifierService;
    private InstanceNodeId localInstanceId;
    private InstanceNodeSessionId localInstanceSessionId;
    private final Log log = LogFactory.getLog(this.getClass());

    @Activate
    public void activate() {
        this.localInstanceId = this.platformService.getLocalInstanceNodeId();
        this.localInstanceSessionId = this.platformService.getLocalInstanceNodeSessionId();
        this.nodePropertiesService.addRawNodePropertiesChangeListener(newProperties -> this.processNewNodeProperties(newProperties));
    }

    @Override
    public InstanceNodeSessionId getLocalInstanceSessionId() {
        return this.localInstanceSessionId;
    }

    @Override
    public LogicalNodeId createRecognizableLocalLogicalNodeId(String qualifier, String optionalDisplayName) {
        if (StringUtils.isNullorEmpty((String)qualifier)) {
            throw new IllegalArgumentException("Empty or null qualifier");
        }
        if (qualifier.length() > 32) {
            throw new IllegalArgumentException("Qualifier exceeds allowed length");
        }
        LogicalNodeId logicalNodeId = this.localInstanceId.expandToLogicalNodeId("r" + qualifier);
        this.registerOptionalDisplayName(logicalNodeId.getLogicalNodePart(), optionalDisplayName);
        return logicalNodeId;
    }

    @Override
    public void updateDisplayNameForLocalLogicalNodeId(LogicalNodeId logicalNodeId, String newDisplayName) {
        Objects.requireNonNull(newDisplayName);
        this.registerOptionalDisplayName(logicalNodeId.getLogicalNodePart(), newDisplayName);
    }

    @Override
    public LogicalNodeId createTransientLocalLogicalNodeId(String optionalDisplayName) {
        LogicalNodeId logicalNodeId = this.localInstanceId.expandToLogicalNodeId("t" + IdGenerator.fastRandomHexString((int)32));
        this.registerOptionalDisplayName(logicalNodeId.getLogicalNodePart(), optionalDisplayName);
        return logicalNodeId;
    }

    private void registerOptionalDisplayName(String logicalNodePart, String optionalDisplayName) {
        if (optionalDisplayName == null) {
            return;
        }
        this.log.debug((Object)StringUtils.format((String)"Announcing display name '%s' for local logical node :%s:", (Object[])new Object[]{optionalDisplayName, logicalNodePart}));
        this.nodePropertiesService.addOrUpdateLocalNodeProperty(NODE_PROPERTIES_PREFIX_LOGICAL_NODE_NAMES + logicalNodePart, optionalDisplayName);
    }

    @Override
    public void releaseLogicalNodeId(LogicalNodeId id) {
    }

    private void processNewNodeProperties(Collection<? extends NodeProperty> newProperties) {
        for (NodeProperty nodeProperty : newProperties) {
            if (!nodeProperty.getKey().startsWith(NODE_PROPERTIES_PREFIX_LOGICAL_NODE_NAMES)) continue;
            InstanceNodeSessionId instanceNodeSessionId = nodeProperty.getInstanceNodeSessionId();
            String logicalNodePart = nodeProperty.getKey().substring(NODE_PROPERTIES_PREFIX_LOGICAL_NODE_NAMES.length());
            LogicalNodeSessionId logicalNodeSessionId = instanceNodeSessionId.expandToLogicalNodeSessionId(logicalNodePart);
            String displayNameOrNull = nodeProperty.getValue();
            if (displayNameOrNull != null) {
                String locationInfo = instanceNodeSessionId.isSameInstanceNodeAs(this.localInstanceId) ? "local" : "remote";
                this.log.debug((Object)StringUtils.format((String)"Registering name '%s' for %s logical node %s", (Object[])new Object[]{displayNameOrNull, locationInfo, logicalNodeSessionId.getLogicalNodeSessionIdString()}));
            } else {
                this.log.debug((Object)StringUtils.format((String)"Unregistering name association for logical node %s", (Object[])new Object[]{displayNameOrNull, logicalNodeSessionId}));
            }
            this.nodeIdentifierService.associateDisplayNameWithLogicalNode(logicalNodeSessionId, displayNameOrNull);
        }
    }
}

