/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import com.jcraft.jsch.JSchException;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.junit.Assert;

public class WorkflowStepDefinitions
extends InstanceManagementStepDefinitionBase {
    private static final String WORKFLOWS = "workflows";
    private static final String JSON = ".json";
    private static final String QUOTATION_MARK = "\"";
    private static final String BACKSLASH = "\\";
    private static final String ESCAPED_BACKSLASH = "\\\\";
    private static final String WORKFLOW_EXTENSION = ".wf";
    private static final String LIST_WORKFLOWS_COMMAND = "wf";
    private static final String EXPORTED_WORKFLOW_RUNS_SUB_DIR = "workspace\\exported_wfs";
    private String lastWorkflowName;
    private Path lastWorkflowLogDir;
    private ManagedInstance lastWorkflowInitiatingInstance;
    private Map<String, String> runningWorkflows = new ConcurrentHashMap<String, String>();

    public WorkflowStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @When(value="^executing (?:the )?workflow[s]? \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$(?: in (\\d+) seconds)?")
    public void whenExecutingWorkflowOnInstance(String workflowInputSequence, String instanceId, String timeoutString) throws Throwable {
        for (String workflowInput : this.parseCommaSeparatedList(workflowInputSequence)) {
            String placeholderFile;
            String workflowName;
            if (this.containsPlaceholderFile(workflowInput)) {
                String[] workflowInputSplit = this.splitWorkflowInput(workflowInput);
                workflowName = workflowInputSplit[0];
                String placeholderTemplate = workflowInputSplit[1];
                placeholderFile = this.injectValuesIntoPlaceholderFile(placeholderTemplate);
            } else {
                workflowName = workflowInput.trim();
                placeholderFile = null;
            }
            File wfFile = Paths.get(new File(workflowName).getPath(), new String[0]).toFile();
            this.whenStartingWorkflowOnInstance(wfFile.getPath(), placeholderFile, instanceId);
            this.whenWaitingUntilWorkflowReachedState(workflowInput.trim(), instanceId, "finished", timeoutString);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String injectValuesIntoPlaceholderFile(String placeholderTemplate) throws IOException {
        Path testLocation = this.executionContext.getTestScriptLocation().toPath();
        Path subdir = testLocation.resolve(Paths.get(WORKFLOWS, "placeholder_values"));
        Path originalPlaceholderFileLocation = subdir.resolve(placeholderTemplate);
        List<String> template = Files.readAllLines(originalPlaceholderFileLocation);
        File placeholderFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("*.json");
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            FileWriter fileWriter = new FileWriter(placeholderFile);
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                    for (String line : template) {
                        String replacedLine;
                        if (line.contains("$$TEMP_DIR$$")) {
                            File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir();
                            replacedLine = line.replace("$$TEMP_DIR$$", QUOTATION_MARK + tempDir.getAbsolutePath().replace(BACKSLASH, ESCAPED_BACKSLASH) + QUOTATION_MARK);
                        } else if (line.contains("$$TEMP_FILE$$")) {
                            File tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("*");
                            replacedLine = line.replace("$$TEMP_FILE$$", QUOTATION_MARK + tempFile.getAbsolutePath().replace(BACKSLASH, ESCAPED_BACKSLASH) + QUOTATION_MARK);
                        } else {
                            replacedLine = line;
                        }
                        bufferedWriter.write(replacedLine);
                        bufferedWriter.newLine();
                    }
                }
                if (fileWriter == null) return placeholderFile.getAbsolutePath();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileWriter == null) throw throwable;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            return placeholderFile.getAbsolutePath();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private String[] splitWorkflowInput(String workflowInput) {
        String[] workflowInputParts = workflowInput.trim().split("\\[");
        String workflowName = workflowInputParts[0].trim();
        String placeholderFileUnadjusted = workflowInputParts[1].trim();
        String placeholderFile = placeholderFileUnadjusted.substring(0, placeholderFileUnadjusted.length() - 1);
        return new String[]{workflowName, placeholderFile};
    }

    private boolean containsPlaceholderFile(String workflowInput) {
        return workflowInput.contains("[");
    }

    @When(value="^copying \"([^\"]*)\" into (?:the )?workspace of \"([^\"]*)\"")
    public void whenCopyingIntoWorksspace(String fileOrDir, String instanceId) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        this.printToCommandConsole(StringUtils.format((String)"Copying %s to instance %s", (Object[])new Object[]{fileOrDir, instance}));
        File workspace = instance.getAbsolutePathFromRelative("workspace");
        if (!workspace.exists()) {
            workspace.mkdir();
        }
        File origin = Paths.get(this.executionContext.getTestScriptLocation().toString(), new File(fileOrDir).getPath()).toFile();
        File dest = new File(workspace, origin.getName());
        if (origin.isDirectory()) {
            FileUtils.copyDirectory((File)origin, (File)dest);
        } else if (origin.isFile()) {
            FileUtils.copyFile((File)origin, (File)dest);
        } else {
            Assert.fail((String)StringUtils.format((String)"%s is neither directory nor file", (Object[])new Object[]{fileOrDir}));
        }
    }

    @When(value="^starting (?:the )?workflow \"([^\"]*)\" (?:using \"([^\"]*)\" as placeholder file)?on (?:instance )?\"([^\"]*)\"$")
    public void whenStartingWorkflowOnInstance(String workflowNameInput, String placeholderFile, String instanceId) throws Throwable {
        String workflowName;
        String[] workflowInfo;
        ManagedInstance instance = this.resolveInstance(instanceId);
        String workflowPath = this.addExtension(workflowNameInput, WORKFLOW_EXTENSION);
        if (placeholderFile != null && !placeholderFile.endsWith(JSON)) {
            placeholderFile = this.addExtension(placeholderFile, JSON);
        }
        if (!(workflowInfo = this.startWorkflowOnInstance(instance, workflowPath, placeholderFile))[0].equals(workflowName = this.convertWorkflowPathToName(workflowPath))) {
            Assert.fail((String)"obtained workflowInfo for wrong workflow execution.");
        }
        String workflowLogDir = workflowInfo[1];
        String workflowId = workflowInfo[2];
        String workflowKey = this.getWorkflowKey(workflowName, instanceId);
        if (this.runningWorkflows.containsKey(workflowKey)) {
            this.log.warn((Object)"Another workflow of the same file is still running. Cannot store the new workflow id.");
        } else {
            this.runningWorkflows.put(workflowKey, workflowId);
            this.startJobCheckingTermiantion(instanceId, instance, workflowName, workflowId, workflowKey);
        }
        Path logFilesDirectory = Paths.get(workflowLogDir, new String[0]);
        if (!Files.isDirectory(logFilesDirectory, new LinkOption[0])) {
            Assert.fail((String)("Found log output directory location '" + logFilesDirectory + "' in command output, but it does not point to an actual directory"));
        }
        this.lastWorkflowLogDir = logFilesDirectory;
        this.lastWorkflowName = workflowName;
        this.lastWorkflowInitiatingInstance = instance;
    }

    private void startJobCheckingTermiantion(final String instanceId, final ManagedInstance instance, final String workflowName, final String workflowId, final String workflowKey) {
        new Job(StringUtils.format((String)"check for termination workflow %s", (Object[])new Object[]{workflowId})){

            protected IStatus run(IProgressMonitor monitor) {
                block8: {
                    Pattern workflowFinishedPattern = Pattern.compile("(FINISHED|FAILED|CANCELLED) \\[" + workflowId + "\\]");
                    try {
                        while (INSTANCE_MANAGEMENT_SERVICE.isInstanceRunning(instanceId)) {
                            String commandOutput = null;
                            try {
                                commandOutput = WorkflowStepDefinitions.this.executeCommandOnInstance(instance, WorkflowStepDefinitions.LIST_WORKFLOWS_COMMAND, false);
                            }
                            catch (AssertionFailedError assertionFailedError) {
                                WorkflowStepDefinitions.this.runningWorkflows.remove(workflowKey);
                                return Status.OK_STATUS;
                            }
                            Matcher m = workflowFinishedPattern.matcher(commandOutput);
                            if (m.find()) {
                                WorkflowStepDefinitions.this.runningWorkflows.remove(workflowKey);
                                break block8;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                WorkflowStepDefinitions.this.log.error((Object)"Exception while trying to sleep tread", (Throwable)e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        WorkflowStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"instance %s not running anymore. Stopping to check for state of workflow %s.", (Object[])new Object[]{instanceId, workflowName}));
                    }
                    catch (IOException e) {
                        WorkflowStepDefinitions.this.log.error((Object)"Exception while checking running state of instance", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @When(value="^(cancelling|deleting|opening|pausing|resuming) workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$")
    public void operationOnRunningWorkflow(String operation, String workflowNameInput, String instanceId) {
        block20: {
            String command;
            String workflowKey;
            ManagedInstance instance;
            block19: {
                instance = this.resolveInstance(instanceId);
                String workflowName = this.convertWorkflowPathToName(this.addExtension(workflowNameInput, WORKFLOW_EXTENSION));
                workflowKey = this.getWorkflowKey(workflowName, instanceId);
                if (this.runningWorkflows.containsKey(workflowKey)) break block19;
                Assert.fail((String)"Could not execute operation on workflow, since workflow id could not be obtained.");
                break block20;
            }
            String workflowId = this.runningWorkflows.get(workflowKey);
            switch (operation) {
                case "cancelling": {
                    command = StringUtils.format((String)"wf cancel %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "deleting": {
                    command = StringUtils.format((String)"wf delete %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "opening": {
                    command = StringUtils.format((String)"wf open %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "pausing": {
                    command = StringUtils.format((String)"wf pause %s", (Object[])new Object[]{workflowId});
                    break;
                }
                case "resuming": {
                    command = StringUtils.format((String)"wf resume %s", (Object[])new Object[]{workflowId});
                    break;
                }
                default: {
                    Assert.fail((String)StringUtils.format((String)"%s a unsupported operation.", (Object[])new Object[]{operation}));
                    return;
                }
            }
            String output = this.executeCommandOnInstance(instance, command, false);
            this.printToCommandConsole(output);
        }
    }

    @When(value="^waiting until workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\" (?:has|is) (finished|cancelled|canceling|failed)(?: or (\\d+) seconds have passed)?")
    public void whenWaitingUntilWorkflowReachedState(String workflowNameInput, String instanceId, String state, String timeoutString) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        String workflowName = this.convertWorkflowPathToName(this.addExtension(workflowNameInput, WORKFLOW_EXTENSION));
        int timeoutInSecs = this.parseTimeout(timeoutString);
        this.printToCommandConsole(StringUtils.format((String)"Waiting for workflow %s to be %s. Aborting after %s seconds if not happend by then.", (Object[])new Object[]{workflowName, state, timeoutInSecs}));
        String workflowKey = this.getWorkflowKey(workflowName, instanceId);
        if (!this.runningWorkflows.containsKey(workflowKey)) {
            this.printToCommandConsole(StringUtils.format((String)"Workflow %s is not running on instance %s", (Object[])new Object[]{workflowName, instanceId}));
            return;
        }
        String workflowId = this.runningWorkflows.get(workflowKey);
        Pattern workflowFinishedPattern = Pattern.compile(String.valueOf(state.toUpperCase()) + " \\[" + workflowId + "\\]");
        for (long countMillis = TimeUnit.SECONDS.toMillis(timeoutInSecs); countMillis > 0L; countMillis -= 500L) {
            String commandOutput = this.executeCommandOnInstance(instance, "wf list", false);
            Matcher m = workflowFinishedPattern.matcher(commandOutput);
            try {
                if (m.find()) {
                    this.printToCommandConsole(StringUtils.format((String)"Workflow %s has reached state %s on %s.", (Object[])new Object[]{workflowName, state, instanceId}));
                    return;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)StringUtils.format((String)"InterruptedException caused when waiting for workflow to reach state. Exception: \n%s", (Object[])new Object[]{e}));
                return;
            }
        }
        Assert.fail((String)StringUtils.format((String)"%s second(s) have passed and workflow %s has not reached state %s. Timeout was reached.", (Object[])new Object[]{timeoutInSecs, workflowName, state}));
    }

    @When(value="^waiting until all workflows on \"([^\"]*)\" are not running anymore(?: or (\\d+) seconds have passed)?")
    public void whenWaitingUntilAllWorkflowsFinished(String instanceId, String timeoutString) throws Throwable {
        int timeoutInSecs = this.parseTimeout(timeoutString);
        long countMillis = TimeUnit.SECONDS.toMillis(timeoutInSecs);
        while (countMillis > 0L) {
            ManagedInstance instance = this.resolveInstance(instanceId);
            String commandOutput = this.executeCommandOnInstance(instance, LIST_WORKFLOWS_COMMAND, false);
            Pattern logDirPattern = Pattern.compile("-- TOTAL COUNT: \\d+ workflow\\(s\\): (\\d+) running");
            Matcher matcher = logDirPattern.matcher(commandOutput);
            if (!matcher.find()) {
                Assert.fail((String)StringUtils.format((String)"Could not identify the number of running workflows by trying to match \"%s\"; full output:\n %s", (Object[])new Object[]{logDirPattern, commandOutput}));
            } else if (Integer.parseInt(matcher.group(1)) == 0) {
                return;
            }
            Thread.sleep(500L);
            countMillis -= 500L;
        }
        this.printToCommandConsole(StringUtils.format((String)"%s second(s) have passed and not all workflows are finished. Timeout was reached.", (Object[])new Object[]{timeoutInSecs}));
    }

    @When(value="^exporting all workflow runs from \"([^\"]*)\" to \"([^\"]*)\"")
    public void whenExportingAllWorkflows(String instanceId, String relativeExportPath) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        File exportDir = instance.getAbsolutePathFromRelative(StringUtils.format((String)"%s\\%s", (Object[])new Object[]{EXPORTED_WORKFLOW_RUNS_SUB_DIR, relativeExportPath}));
        this.executeCommandOnInstance(instance, StringUtils.format((String)"tc export_all_wf_runs %s", (Object[])new Object[]{exportDir}), false);
    }

    @Then(value="all exported workflow run directories from \"([^\"]*)\" should be identical$")
    public void thenAllExportWorkflowRunsIdenical(String instanceId) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        File wfParentDir = instance.getAbsolutePathFromRelative(EXPORTED_WORKFLOW_RUNS_SUB_DIR);
        File[] subdirectories = wfParentDir.listFiles(File::isDirectory);
        int length = subdirectories.length;
        if (!wfParentDir.exists() || length == 0) {
            Assert.fail((String)StringUtils.format((String)"There are no exported workflow run directories for instance %s", (Object[])new Object[]{instanceId}));
        }
        if (length == 1) {
            Assert.fail((String)StringUtils.format((String)"There is only one exported workflow run directory for instance %s. At least two are necessary.", (Object[])new Object[]{instanceId}));
        }
        File compareDir = subdirectories[0];
        File[] compareDirFiles = compareDir.listFiles(File::isFile);
        int i = 1;
        while (i < subdirectories.length) {
            File[] files = subdirectories[i].listFiles(File::isFile);
            if (compareDirFiles.length != files.length) {
                Assert.fail((String)StringUtils.format((String)"Subdirectories %s and %s do not contain the same amount of exported wf runs.", (Object[])new Object[]{compareDir, subdirectories[i]}));
            }
            int j = 0;
            while (j < files.length) {
                String output = this.executeCommandOnInstance(instance, StringUtils.format((String)"tc compare_wf_runs %s %s", (Object[])new Object[]{compareDirFiles[j].getAbsolutePath(), files[j].getAbsolutePath()}), false);
                if (!output.contains("The compared workflow runs are identical.")) {
                    Assert.fail((String)StringUtils.format((String)"The workflow runs %s and %s are not identical.", (Object[])new Object[]{compareDirFiles[j].getAbsolutePath(), files[j].getAbsolutePath()}));
                }
                ++j;
            }
            ++i;
        }
        this.printToCommandConsole(StringUtils.format((String)"All exported workflow run directories from instance %s are identical.", (Object[])new Object[]{instanceId}));
    }

    @Then(value="^the workflow log should (not )?contain (the pattern )?\"(.*)\"$")
    public void thenWorkflowLogContains(String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        if (this.lastWorkflowLogDir == null) {
            Assert.fail((String)"Test error: No workflow log present yet");
            return;
        }
        String wfLogFileContent = null;
        Path wfLogFile = this.lastWorkflowLogDir.resolve("workflow.log");
        if (Files.exists(this.lastWorkflowLogDir.resolve("workflow.log.tmp"), new LinkOption[0]) || Files.isRegularFile(wfLogFile, new LinkOption[0])) {
            int tries = 3;
            while (tries > 0) {
                if (Files.isRegularFile(wfLogFile, new LinkOption[0])) {
                    wfLogFileContent = FileUtils.readFileToString((File)wfLogFile.toFile());
                    break;
                }
                Thread.sleep(500L);
                if (tries != 0) continue;
                Assert.fail((String)("Found log output directory location '" + this.lastWorkflowLogDir + "', but workflow.log.tmp did not convert to workflow.log"));
            }
        } else {
            Assert.fail((String)("Found log output directory location '" + this.lastWorkflowLogDir + "', but there is neither workflow.log not workflow.log.tmp file inside"));
        }
        if (wfLogFileContent.isEmpty()) {
            Assert.fail((String)"Test error: Workflow log was stored, but is empty");
        }
        this.assertPropertyOfTextOutput(this.lastWorkflowInitiatingInstance, negationFlag, useRegexpMarker, substring, wfLogFileContent, "workflow log");
    }

    @Then(value="^the workflow should have reached the (\\w+) state$")
    public void thenWorkflowReachedState(String state) throws Throwable {
        this.thenWorkflowLogContainsCaller(false, false, "NEW_STATE:" + state);
    }

    @Then(value="^the workflow controller should have been \"([^\"]+)\"(?: using node id \"(\\w+)\")?$")
    public void thenWorkflowController(String nodeName, String nodeId) throws Throwable {
        this.thenWorkflowLogContainsCaller(false, false, "Location of workflow controller: \"" + nodeName + QUOTATION_MARK);
    }

    @Then(value="^workflow component \"([^\"]+)\" should have been run on \"([^\"]+)\"( via uplink)?(?: using node id \"(\\w+)\")?$")
    public void thenComponentRanOn(String compName, String nodeName, String uplinkFlag, String nodeId) throws Throwable {
        if (uplinkFlag != null) {
            nodeName = String.valueOf(nodeName) + " \\(via [^)]+\\)";
        }
        String regexp = "Location of workflow component \"" + compName + "\" [^:]+: \"" + nodeName + QUOTATION_MARK;
        if (nodeId != null) {
            regexp = String.valueOf(regexp) + " \\[" + nodeId + ":0\\]";
        }
        this.thenWorkflowLogContainsCaller(false, true, regexp);
    }

    @Then(value="^workflow component \"([^\"]+)\" should have been cancelled$")
    public void thenComponentCancelledOn(String compName) throws Throwable {
        this.whenWaitingUntilWorkflowReachedState(this.lastWorkflowName, this.lastWorkflowInitiatingInstance.getId(), "cancelled", null);
        this.thenComponentTerminated(compName);
    }

    @Then(value="^workflow component \"([^\"]+)\" should be terminated$")
    public void thenComponentTerminated(String compName) throws Throwable {
        String regexp = "\\[LIFE_CYCLE_EVENT\\] \\[" + compName + "\\] COMPONENT_TERMINATED";
        this.thenWorkflowLogContainsCaller(false, true, regexp);
    }

    @Then(value="^(all )?(?:instance[s]? )?(?:\"([^\"]+)\" )?should see(?: workflow[s]?)? \"([^\"]+)\"$")
    public void thenInstancesShouldSeeworkflow(String allFlag, String instanceIds, String workflowNames) {
        this.performActionOnInstances(new AssertWorkflowVisibilityAction(this.parseCommaSeparatedList(workflowNames)), this.resolveInstanceList(allFlag != null, instanceIds), InstanceManagementStepDefinitionBase.InstanceActionExecutionType.RANDOM);
    }

    @Then(value="^(all )?(?:instance[s]? )?(?:\"([^\"]+)\" )?should see identical data for(?: workflow[s]?)? \"([^\"]+)\"$")
    public void thenInstancesShouldSeeIdenticalData(String allFlag, String instanceIds, String workflowNames) {
        List<ManagedInstance> instances = this.resolveInstanceList(allFlag != null, instanceIds);
        if (instances.size() < 2) {
            Assert.fail((String)"At least two instances are neccessara to have a meaningful comparison. Less were provided.");
        }
        this.performActionOnInstances(new AssertWorkflowDataAction(instances.remove(0), this.parseCommaSeparatedList(workflowNames)), instances, InstanceManagementStepDefinitionBase.InstanceActionExecutionType.RANDOM);
    }

    private String convertWorkflowPathToName(String workflowPath) {
        return new File(workflowPath).getName();
    }

    private String[] startWorkflowOnInstance(ManagedInstance instance, String workflowName, String placeholderFile) throws IOException {
        boolean hasPlaceholder = placeholderFile != null;
        String instanceId = instance.getId();
        Path originalWfFileLocation = this.executionContext.getTestScriptLocation().toPath().resolve(WORKFLOWS).resolve(workflowName);
        if (!Files.isRegularFile(originalWfFileLocation, new LinkOption[0])) {
            throw new AssertionError((Object)("No workflow file found at expected location " + originalWfFileLocation));
        }
        File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("bdd-wf");
        Path wfFileLocation = tempDir.toPath().resolve(originalWfFileLocation.getFileName());
        Files.copy(originalWfFileLocation, wfFileLocation, new CopyOption[0]);
        String startInfoText = StringUtils.format((String)"Starting workflow %s on instance %s", (Object[])new Object[]{workflowName, instanceId});
        Path placeholderFileLocation = null;
        if (hasPlaceholder) {
            if (!new File(placeholderFile).isAbsolute()) {
                Path testLocation = this.executionContext.getTestScriptLocation().toPath();
                Path subdir = testLocation.resolve(WORKFLOWS).resolve("placeholder_values");
                Path originalPlaceholderFileLocation = subdir.resolve(placeholderFile);
                if (!Files.isRegularFile(originalPlaceholderFileLocation, new LinkOption[0])) {
                    throw new AssertionError((Object)("No placeholder file found at expected location " + originalWfFileLocation));
                }
                placeholderFileLocation = tempDir.toPath().resolve(originalPlaceholderFileLocation.getFileName());
                Files.copy(originalPlaceholderFileLocation, placeholderFileLocation, new CopyOption[0]);
            } else {
                placeholderFileLocation = Paths.get(placeholderFile, new String[0]);
            }
            startInfoText = StringUtils.format((String)"%s using placeholders from %s", (Object[])new Object[]{startInfoText, placeholderFile});
        }
        this.printToCommandConsole(startInfoText);
        this.log.debug((Object)startInfoText);
        CapturingTextOutReceiver commandOutputReceiver = new CapturingTextOutReceiver();
        try {
            String[] workflowInfo = hasPlaceholder ? INSTANCE_MANAGEMENT_SERVICE.startWorkflowOnInstance(instanceId, wfFileLocation, placeholderFileLocation, commandOutputReceiver) : INSTANCE_MANAGEMENT_SERVICE.startWorkflowOnInstance(instanceId, wfFileLocation, commandOutputReceiver);
            if (workflowInfo == null || workflowInfo.length != 3) {
                Assert.fail((String)"Info about started workflow did not contain the expected amount of information.");
            }
            instance.setLastCommandOutput(commandOutputReceiver.getBufferedOutput());
            this.executionContext.setLastInstanceWithSingleCommandExecution(instance);
            this.log.debug((Object)StringUtils.format((String)"Started workflow %s on instance %s", (Object[])new Object[]{workflowName, instanceId}));
            return workflowInfo;
        }
        catch (JSchException | SshParameterException | IOException | InterruptedException e) {
            Assert.fail((String)StringUtils.format((String)"Failed to start workflow %s on instance %s: %s", (Object[])new Object[]{workflowName, instanceId, e.toString()}));
            return null;
        }
    }

    private void thenWorkflowLogContainsCaller(boolean negate, boolean useRegex, String contents) throws Throwable {
        String negationFlag = null;
        String regexFlag = null;
        if (negate) {
            negationFlag = "not ";
        }
        if (useRegex) {
            regexFlag = "the pattern ";
        }
        this.thenWorkflowLogContains(negationFlag, regexFlag, contents);
    }

    private int parseTimeout(String timeoutString) {
        int timeoutInSecs = timeoutString == null ? 60 : Integer.parseInt(timeoutString);
        return timeoutInSecs;
    }

    private String addExtension(String file, String extension) {
        if (!file.endsWith(extension)) {
            file = String.valueOf(file) + extension;
        }
        return file;
    }

    private String getWorkflowKey(String workflowName, String instanceId) {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{workflowName, instanceId});
    }

    private class AssertWorkflowDataAction
    implements InstanceManagementStepDefinitionBase.InstanceAction {
        private ManagedInstance comparator;
        private List<String> workflowNames;

        AssertWorkflowDataAction(ManagedInstance comparator, List<String> workflowNames) {
            this.comparator = comparator;
            this.workflowNames = workflowNames;
        }

        @Override
        public void performActionOnInstance(ManagedInstance instance, long timeout) throws IOException {
            String commandOutput = WorkflowStepDefinitions.this.executeCommandOnInstance(instance, WorkflowStepDefinitions.LIST_WORKFLOWS_COMMAND, false);
            instance.setLastCommandOutput(commandOutput);
            WorkflowStepDefinitions.this.executionContext.setLastInstanceWithSingleCommandExecution(instance);
            File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("wf_run_export");
            File tmpDirBase = new File(tempDir, "base");
            File tmpDirInst = new File(tempDir, instance.getId());
            Boolean baseExists = tmpDirBase.exists();
            for (String workflowName : this.workflowNames) {
                Pattern p = Pattern.compile("'(" + workflowName + "[\\d-_:]+)'");
                Matcher m = p.matcher(commandOutput);
                while (m.find()) {
                    String workflowRun = m.group(1);
                    if (!baseExists.booleanValue()) {
                        String outputExportBase = WorkflowStepDefinitions.this.executeCommandOnInstance(this.comparator, StringUtils.format((String)"tc export_wf_run %s %s", (Object[])new Object[]{tmpDirBase, workflowRun}), false);
                        WorkflowStepDefinitions.this.printToCommandConsole(outputExportBase);
                        if (!outputExportBase.contains("Successfully exported workflowrun.")) {
                            Assert.fail((String)StringUtils.format((String)"The workflow run %s could not be exported from instance %s", (Object[])new Object[]{workflowRun, this.comparator}));
                        }
                    }
                    String outputExportInst = WorkflowStepDefinitions.this.executeCommandOnInstance(instance, StringUtils.format((String)"tc export_wf_run %s %s", (Object[])new Object[]{tmpDirInst, workflowRun}), false);
                    WorkflowStepDefinitions.this.printToCommandConsole(outputExportInst);
                    if (!outputExportInst.contains("Successfully exported workflowrun.")) {
                        Assert.fail((String)StringUtils.format((String)"The workflow run %s could not be exported from instance %s", (Object[])new Object[]{workflowRun, instance}));
                    }
                    String outputComparison = WorkflowStepDefinitions.this.executeCommandOnInstance(this.comparator, StringUtils.format((String)"tc compare_wf_runs %s %s", (Object[])new Object[]{StringUtils.format((String)"%s\\%s.json", (Object[])new Object[]{tmpDirBase, workflowRun.replaceAll(":", "_")}), StringUtils.format((String)"%s\\%s.json", (Object[])new Object[]{tmpDirInst, workflowRun.replaceAll(":", "_")})}), false);
                    WorkflowStepDefinitions.this.printToCommandConsole(outputComparison);
                    if (outputComparison.contains("The compared workflow runs are identical.")) continue;
                    Assert.fail((String)StringUtils.format((String)"The workflow run %s is not identical on instance %s and instance %s", (Object[])new Object[]{workflowRun, this.comparator, instance}));
                }
            }
        }
    }

    private class AssertWorkflowVisibilityAction
    implements InstanceManagementStepDefinitionBase.InstanceAction {
        private List<String> workflowNames;

        AssertWorkflowVisibilityAction(List<String> workflowNames) {
            this.workflowNames = workflowNames;
        }

        @Override
        public void performActionOnInstance(ManagedInstance instance, long timeout) throws IOException {
            String commandOutput = WorkflowStepDefinitions.this.executeCommandOnInstance(instance, WorkflowStepDefinitions.LIST_WORKFLOWS_COMMAND, false);
            instance.setLastCommandOutput(commandOutput);
            WorkflowStepDefinitions.this.executionContext.setLastInstanceWithSingleCommandExecution(instance);
            for (String workflowName : this.workflowNames) {
                if (commandOutput.contains(workflowName)) continue;
                Assert.fail((String)StringUtils.format((String)"Instance %s could not see %s. It saw these workflows: \n %s", (Object[])new Object[]{instance, workflowName, commandOutput}));
            }
        }
    }
}

