/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.dialogs;

import de.rcenvironment.core.gui.palette.GroupNameValidator;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddCustomGroupDialog
extends TitleAreaDialog {
    private static final int HEIGHT = 200;
    private static final int WIDTH = 450;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PaletteViewContentProvider contentProvider;
    private List<PaletteTreeNode> currentGroups;
    private PaletteTreeNode parentNode;
    private String text;
    private Text addGroupText;
    private boolean groupAdded = false;

    public AddCustomGroupDialog(Shell parentShell, PaletteViewContentProvider contentProvider, PaletteTreeNode parentNode, boolean isSubgroupDialog) {
        super(parentShell);
        this.contentProvider = contentProvider;
        this.currentGroups = parentNode.getSubGroups();
        this.parentNode = parentNode;
        this.text = isSubgroupDialog ? "Add subgroup to custom group '" + parentNode.getNodeName() + "'" : "Add custom top level group";
        AddCustomGroupDialog.setDialogHelpAvailable((boolean)false);
    }

    public void create() {
        super.create();
        this.setTitle("Add Group Dialog");
        this.setMessage(this.text);
        this.getShell().setSize(450, 200);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        GridData contentData = new GridData(1808);
        content.setLayoutData((Object)contentData);
        CLabel label = new CLabel(content, 0);
        label.setText("Set group name:");
        this.addGroupText = new Text(content, 2048);
        GridData addGroupGridData = new GridData(768);
        addGroupGridData.grabExcessVerticalSpace = true;
        this.addGroupText.setLayoutData((Object)addGroupGridData);
        this.addGroupText.setEditable(true);
        this.addGroupText.addModifyListener((ModifyListener)new AddGroupModifyListener());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        String groupString = this.addGroupText.getText().trim();
        GroupNode node = (GroupNode)this.contentProvider.createGroupNode(this.parentNode, groupString);
        node.setCustomGroup(true);
        this.groupAdded = true;
        if (this.parentNode.isRoot()) {
            this.log.debug((Object)StringUtils.format((String)"Created custom group '%s'.", (Object[])new Object[]{groupString}));
        } else {
            this.log.debug((Object)StringUtils.format((String)"Created subgroup '%s' in group '%s'.", (Object[])new Object[]{groupString, this.parentNode.getQualifiedGroupName()}));
        }
        super.okPressed();
    }

    public boolean isGroupAdded() {
        return this.groupAdded;
    }

    private class AddGroupModifyListener
    implements ModifyListener {
        private AddGroupModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            AddCustomGroupDialog.this.setErrorMessage(null);
            String modifiedText = AddCustomGroupDialog.this.addGroupText.getText();
            GroupNameValidator validator = new GroupNameValidator(AddCustomGroupDialog.this.currentGroups, AddCustomGroupDialog.this.parentNode.isRoot());
            Optional<String> validationMessage = validator.valdiateText(modifiedText);
            AddCustomGroupDialog.this.getButton(0).setEnabled(!validationMessage.isPresent());
            if (validationMessage.isPresent()) {
                AddCustomGroupDialog.this.setErrorMessage(validationMessage.get());
            }
        }
    }
}

