/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui.internal;

import de.rcenvironment.core.start.gui.internal.ApplicationActionBarAdvisor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Log LOGGER = LogFactory.getLog(ApplicationWorkbenchWindowAdvisor.class);

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        IPreferenceStore preferenceStore = PlatformUI.getPreferenceStore();
        preferenceStore.setValue("DOCK_PERSPECTIVE_BAR", "TOP_RIGHT");
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        String workbenchNode = "org.eclipse.ui.workbench";
        String mirgratedPreferenceFlag = "e4Workbench";
        if (!InstanceScope.INSTANCE.getNode(workbenchNode).getBoolean(mirgratedPreferenceFlag, false)) {
            IPath location = Platform.getLocation();
            IPath workbenchXml = location.addTrailingSeparator().append(".metadata").addTrailingSeparator().append(".plugins").addTrailingSeparator().append(workbenchNode).addTrailingSeparator().append("workbench.xml");
            if (workbenchXml.toFile().exists()) {
                IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
                configurer.getWindow().getActivePage().closeAllEditors(true);
                workbenchXml.toFile().delete();
                LOGGER.debug((Object)"'Workbench.xml' file found and deleted. Workbench migrated to e4 platform. Closed editor tabs previously opened with e3 platform.");
            }
            InstanceScope.INSTANCE.getNode(workbenchNode).putBoolean(mirgratedPreferenceFlag, true);
        }
        String migratedPaletteFlag = "rcePaletteView";
        if (!InstanceScope.INSTANCE.getNode(workbenchNode).getBoolean(migratedPaletteFlag, false)) {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.getWindow().getActivePage().resetPerspective();
            InstanceScope.INSTANCE.getNode(workbenchNode).putBoolean(migratedPaletteFlag, true);
        }
    }

    public boolean preWindowShellClose() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.save(true, null);
        }
        catch (CoreException coreException) {
        }
        catch (RuntimeException runtimeException) {}
        return super.preWindowShellClose();
    }
}

