/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.GUIWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.parts.ReadOnlyWorkflowEditorEditPartFactory;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ReadOnlyWorkflowEditor
extends WorkflowEditor {
    private static final Log LOGGER = LogFactory.getLog(ReadOnlyWorkflowEditor.class);
    private TabbedPropertySheetPage tabbedPropertySheetPage;

    @Override
    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null || this.tabbedPropertySheetPage.getControl() == null || this.tabbedPropertySheetPage.getControl().isDisposed()) {
                this.tabbedPropertySheetPage = new ReadOnlyTabbedPropertySheetPage(this);
            }
            return this.tabbedPropertySheetPage;
        }
        return super.getAdapter(type);
    }

    @Override
    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = super.getViewer();
        viewer.setEditPartFactory((EditPartFactory)new ReadOnlyWorkflowEditorEditPartFactory());
        viewer.setContents((Object)super.getWorkflowDescription());
        viewer.getControl().setBackground(Display.getDefault().getSystemColor(15));
        viewer.setContextMenu(new MenuManager());
        int[] eventTypes = new int[]{8, 29};
        ReadOnlyWorkflowEditor.removeListeners((Widget)viewer.getControl(), eventTypes);
        this.tabbedPropertySheetPage = new ReadOnlyTabbedPropertySheetPage(this);
    }

    @Override
    protected void loadWorkflowFromFile(final File wfFile, final GUIWorkflowDescriptionLoaderCallback wfdc) {
        String fileName;
        if (wfFile != null) {
            Job job = new Job(Messages.openWorkflow){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask(Messages.loadingComponents, 2);
                            monitor.worked(1);
                            ReadOnlyWorkflowEditor.this.workflowDescription = ReadOnlyWorkflowEditor.this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, (WorkflowDescriptionLoaderCallback)wfdc, true);
                            ReadOnlyWorkflowEditor.this.initializeWorkflowDescriptionListener();
                            monitor.worked(1);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (ReadOnlyWorkflowEditor.this.getViewer().getControl() != null) {
                                        ReadOnlyWorkflowEditor.this.getViewer().setContents((Object)(this).ReadOnlyWorkflowEditor.this.workflowDescription);
                                        if (ReadOnlyWorkflowEditor.this.getEditorSite() != null) {
                                            ReadOnlyWorkflowEditor.this.setFocus();
                                        }
                                        ReadOnlyWorkflowEditor.this.firePropertyChange(768);
                                    }
                                }
                            });
                        }
                        catch (WorkflowFileException e) {
                            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to open workflow: " + wfFile.getAbsolutePath()), (Throwable)e);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ReadOnlyWorkflowEditor.this.closeEditorAndShowMessage("Failed to open workflow file in read-only: The workflow was probably executed with a different version of RCE than the one in use.");
                                }
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        if ((fileName = this.getPartName()) != null) {
            String fileNameRO = String.valueOf(fileName) + " - Read only";
            this.setPartName(fileNameRO);
        }
    }

    @Override
    public String getContributorId() {
        return "de.rcenvironment.rce.gui.workflow.editor.WorkflowEditor";
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    @Override
    public void doSave(IProgressMonitor arg0) {
    }

    private void disableCurrentPropertySection(TabbedPropertySheetPage tpsp) {
        Control swtControls;
        if (tpsp instanceof TabbedPropertySheetPage && (swtControls = tpsp.getControl()) instanceof TabbedPropertyComposite) {
            TabbedPropertyComposite propComposite = (TabbedPropertyComposite)swtControls;
            Composite tabComposite = propComposite.getTabComposite();
            this.recursiveSetDisabled(tabComposite);
        }
    }

    private void recursiveSetDisabled(Object obj) {
        if (obj instanceof Composite) {
            Composite comp = (Composite)obj;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetDisabled(c);
                ++n2;
            }
            if (comp.getChildren().length == 0) {
                comp.setEnabled(false);
            }
        } else if (obj instanceof Control) {
            Control ctrl = (Control)obj;
            ctrl.setEnabled(false);
        }
        this.specialTreatment(obj);
    }

    private void specialTreatment(Object obj) {
        Control ctrl;
        if (obj instanceof Composite) {
            Composite comp = (Composite)obj;
            if (comp instanceof Tree) {
                Tree t = (Tree)comp;
                int[] eventTypes = new int[]{29, 13};
                ReadOnlyWorkflowEditor.removeListeners((Widget)t, eventTypes);
                t.setEnabled(true);
            }
            if (comp instanceof StyledText) {
                StyledText text = (StyledText)comp;
                text.setEnabled(true);
                text.setEditable(false);
            }
            if (comp instanceof CTabFolder) {
                CTabItem[] folderItems;
                CTabFolder folder = (CTabFolder)comp;
                CTabItem[] cTabItemArray = folderItems = folder.getItems();
                int n = folderItems.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem cItem = cTabItemArray[n2];
                    if (cItem.getStyle() != 64) {
                        cItem.dispose();
                    } else {
                        cItem.setShowClose(false);
                    }
                    ++n2;
                }
            }
        } else if (obj instanceof Control && (ctrl = (Control)obj) instanceof Label) {
            ctrl.setEnabled(true);
            int[] eventTypes = new int[]{3, 4, 8};
            ReadOnlyWorkflowEditor.removeListeners((Widget)ctrl, eventTypes);
        }
    }

    public static void removeListeners(Widget ctrl, int[] eventTypes) {
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Listener[] listeners;
            int eventType = nArray[n2];
            Listener[] listenerArray = listeners = ctrl.getListeners(eventType);
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener listener = listenerArray[n4];
                ctrl.removeListener(eventType, listener);
                ++n4;
            }
            ++n2;
        }
    }

    private class ReadOnlyTabbedPropertySheetPage
    extends TabbedPropertySheetPage {
        ReadOnlyTabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
            super(tabbedPropertySheetPageContributor);
            super.addTabSelectionListener(new ITabSelectionListener(){

                public void tabSelected(ITabDescriptor arg0) {
                    ReadOnlyWorkflowEditor.this.disableCurrentPropertySection(ReadOnlyWorkflowEditor.this.tabbedPropertySheetPage);
                }
            });
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            super.selectionChanged(part, selection);
            ReadOnlyWorkflowEditor.this.disableCurrentPropertySection(ReadOnlyWorkflowEditor.this.tabbedPropertySheetPage);
        }
    }
}

