/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor.fileinfo;

import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.fileinfo.FileInfo;
import de.rcenvironment.core.utils.executor.fileinfo.internal.AbstractFileService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnixFileInfoService
extends AbstractFileService {
    private static final Pattern LS_DIRECTORY_PATTERN = Pattern.compile("^(.*):$");
    private static final Pattern LS_TOTAL_PATTERN = Pattern.compile("^total \\d+$");
    private static final Pattern LS_LINE_PATTERN = Pattern.compile("^([-dl])(?:[-r][-w][-xst]){3}(?:\\+)?\\s+\\d+\\s+([-_\\w]+)\\s+([-_\\w]+)\\s+(\\d+)\\s+(\\d+)\\s+(.*)\\s*$");
    private static final Pattern FILE_CMD_DIRECTORY_PATTERN = Pattern.compile(".*: (?:sticky )?directory$");
    private static final Pattern FILE_CMD_SYMLINK_PATTERN = Pattern.compile("^(.*): (?:broken )?symbolic link to `(.*)'$");
    private static final Pattern NON_EXISTING_PATTERN = Pattern.compile("^.*: cannot open `.*' \\(No such file or directory\\)$");
    private static final Pattern PERMISSION_DENIED_PATTERN = Pattern.compile("^.*: cannot access `.*': \\(?Permission denied\\)?$");

    public UnixFileInfoService(CommandLineExecutor commandLineExecutor) {
        super(commandLineExecutor);
    }

    @Override
    public Collection<FileInfo> listFiles(String directory, boolean recursively) throws IOException {
        return this.listContent(directory, recursively, false);
    }

    @Override
    public Collection<FileInfo> listContent(String directory, boolean recursively) throws IOException {
        return this.listContent(directory, recursively, true);
    }

    protected Collection<FileInfo> listContent(String directory, boolean recursively, boolean directories) throws IOException {
        LinkedList<FileInfo> result = new LinkedList<FileInfo>();
        String commandPattern = recursively ? "ls -R -l -A -b -q --time-style=+%%s --color=never %s" : "ls -l -A -b -q --time-style=+%%s --color=never %s";
        String command = StringUtils.format((String)commandPattern, (Object[])new Object[]{directory});
        try {
            Output executionOutput = this.exec(command);
            if (executionOutput.err.length() > 0) {
                throw new IOException(executionOutput.err);
            }
            String output = executionOutput.out.trim();
            Throwable throwable = null;
            Object var10_12 = null;
            try (Scanner scanner = new Scanner(output);){
                String relativePathPrefix = "";
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty() || LS_TOTAL_PATTERN.matcher(line).matches()) continue;
                    Matcher directoryMatcher = LS_DIRECTORY_PATTERN.matcher(line);
                    if (directoryMatcher.matches()) {
                        relativePathPrefix = directoryMatcher.group(1);
                        if (relativePathPrefix.equals(".")) {
                            relativePathPrefix = "";
                        }
                        relativePathPrefix = relativePathPrefix.replaceAll("\\./", "");
                        continue;
                    }
                    FileInfo fileInfo = this.parseFileInfo(line, directory, relativePathPrefix);
                    if (fileInfo == null || !directories && fileInfo.isDirectory()) continue;
                    result.add(fileInfo);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private FileInfo parseFileInfo(String line, String path, String directory) throws IOException {
        long size;
        Matcher matcher = LS_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IOException(StringUtils.format((String)"LS line does not match pattern: %s", (Object[])new Object[]{line}));
        }
        int type = matcher.group(1).charAt(0);
        try {
            String sizeString = matcher.group(4);
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        Date modificationDate = null;
        try {
            String timestampString = matcher.group(5);
            long timestamp = Long.parseLong(timestampString) * 1000L;
            modificationDate = new Date(timestamp);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        String name = matcher.group(6);
        if (type == 108) {
            name = name.substring(0, name.indexOf("->") - 1);
            String targetPath = this.resolveTarget(String.valueOf(path) + name);
            if (targetPath == null) {
                return null;
            }
            if (this.isDirectory(targetPath)) {
                type = 100;
            } else {
                type = 45;
                size = this.size(targetPath);
            }
        }
        String relativePath = directory.isEmpty() ? name : String.valueOf(directory) + '/' + name;
        if (type == 100) {
            size = 0L;
        }
        relativePath = relativePath.replaceAll("/+", "/");
        FileInfo fileInfo = new FileInfo(type == 45, relativePath, modificationDate, size);
        return fileInfo;
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        String output;
        block5: {
            String command = StringUtils.format((String)"file %s", (Object[])new Object[]{path});
            try {
                Output executionOutput = this.exec(command);
                if (executionOutput.err.length() > 0) {
                    throw new IOException(executionOutput.err);
                }
                output = executionOutput.out.trim();
                Matcher matcher1 = FILE_CMD_DIRECTORY_PATTERN.matcher(output);
                if (!matcher1.matches()) break block5;
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        Matcher matcher2 = FILE_CMD_SYMLINK_PATTERN.matcher(output);
        if (matcher2.matches()) {
            return this.isDirectory(matcher2.group(2));
        }
        return false;
    }

    private String resolveTarget(String path) throws IOException {
        block6: {
            String command = StringUtils.format((String)"file %s", (Object[])new Object[]{path});
            try {
                Output executionOutput = this.exec(command);
                if (executionOutput.err.length() > 0) {
                    throw new IOException(executionOutput.err);
                }
                String output = executionOutput.out.trim();
                Matcher matcher = FILE_CMD_SYMLINK_PATTERN.matcher(output);
                if (matcher.matches()) {
                    String targetPath = matcher.group(2);
                    if (targetPath.startsWith("/")) {
                        return this.resolveTarget(targetPath);
                    }
                    String absolutePath = String.valueOf(path.substring(0, path.lastIndexOf(47) + 1)) + targetPath;
                    return this.resolveTarget(absolutePath);
                }
                matcher = NON_EXISTING_PATTERN.matcher(output);
                if (!matcher.matches()) break block6;
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long size(String path) throws IOException {
        if (this.isDirectory(path)) {
            return 0L;
        }
        String command = StringUtils.format((String)"du --bytes %s", (Object[])new Object[]{path});
        try {
            Output executionOutput = this.exec(command);
            if (executionOutput.err.length() <= 0) {
                String output = executionOutput.out.trim();
                String[] sizeInfo = output.split("\\s+");
                return Long.parseLong(sizeInfo[0]);
            }
            if (PERMISSION_DENIED_PATTERN.matcher(executionOutput.err.trim()).matches()) {
                return null;
            }
            throw new IOException(executionOutput.err);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private Output exec(String commandString) throws IOException, InterruptedException {
        CommandLineExecutor executor = this.getCommandLineExecutor();
        executor.setEnv("LANG", "en_US.UTF8");
        executor.start(commandString);
        InputStream stdout = executor.getStdout();
        InputStream stderr = executor.getStderr();
        CapturingTextOutReceiver outReceiver = new CapturingTextOutReceiver();
        CapturingTextOutReceiver errReceiver = new CapturingTextOutReceiver();
        TextStreamWatcher stdoutWatcher = TextStreamWatcherFactory.create((InputStream)stdout, (TextOutputReceiver[])new TextOutputReceiver[]{outReceiver});
        TextStreamWatcher stderrWatcher = TextStreamWatcherFactory.create((InputStream)stderr, (TextOutputReceiver[])new TextOutputReceiver[]{errReceiver});
        stdoutWatcher.start();
        stderrWatcher.start();
        executor.waitForTermination();
        stdoutWatcher.waitForTermination();
        stderrWatcher.waitForTermination();
        Output result = new Output();
        result.out = outReceiver.getBufferedOutput();
        result.err = errReceiver.getBufferedOutput();
        return result;
    }

    private static final class Output {
        private String out;
        private String err;

        private Output() {
        }
    }
}

