/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.matching;

import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.utils.common.StringUtils;

public class MatrixTDMatcher
implements Matcher<MatrixTD> {
    @Override
    public MatchResult matches(MatrixTD actual, MatrixTD expected) {
        MatchResult result = new MatchResult();
        int actualRow = actual.getRowDimension();
        int actualColumn = actual.getColumnDimension();
        int expectedRow = expected.getRowDimension();
        int expectedColumn = expected.getColumnDimension();
        if (actualRow != expectedRow || actualColumn != expectedColumn) {
            result.addFailureCause("The matrix dimensions are not the same.");
            return result;
        }
        int i = 0;
        while (i < actualRow) {
            int j = 0;
            while (j < actualColumn) {
                if (!actual.getFloatTDOfElement(i, j).equals(expected.getFloatTDOfElement(i, j))) {
                    result.addFailureCause(StringUtils.format((String)"The matrix values in row %s and column %s are not the same.", (Object[])new Object[]{i, j}));
                    return result;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

