/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.dialogs;

import de.rcenvironment.core.component.model.api.ComponentImageManagerService;
import de.rcenvironment.core.component.model.impl.ComponentImageManagerImpl;
import de.rcenvironment.core.gui.palette.PaletteViewConstants;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.PaletteTreeViewerComparator;
import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.PaletteViewTreeListener;
import de.rcenvironment.core.gui.palette.view.dialogs.AddCustomGroupDialog;
import de.rcenvironment.core.gui.palette.view.dialogs.EditCustomGroupDialog;
import de.rcenvironment.core.gui.palette.view.dialogs.ManageGroupsContentProvider;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.ComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.OfflineComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ManageCustomGroupsDialog
extends TitleAreaDialog {
    private static final int HEIGHT = 500;
    private static final int WIDTH = 800;
    private static final int COLUMN_2_WIDTH = 120;
    private static final int COLUMN_1_WIDTH = 80;
    private static final int COLUMN_0_WIDTH = 445;
    private static final int BUTTON_WIDTH = 110;
    private static final String[] TITLES = new String[]{"Group Hierachy", "Location", "Currently Available"};
    private static final int TABLE_BUTTON_SIZE = 26;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TreeViewer treeViewer;
    private PaletteView paletteView;
    private Button addSubgroupButton;
    private Button editButton;
    private Button deleteButton;
    private Button resetButton;
    private ComponentImageManagerService componentImageManager;
    private PaletteViewContentProvider contentProvider;

    public ManageCustomGroupsDialog(Shell parentShell, PaletteView paletteView) {
        super(parentShell);
        this.paletteView = paletteView;
        this.contentProvider = paletteView.getContentProvider();
        this.componentImageManager = (ComponentImageManagerService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(ComponentImageManagerService.class);
    }

    public void create() {
        super.create();
        this.setTitle("Manage Custom Groups and Group Assignments");
        this.setMessage("Add, edit or delete custom groups. Reset components to their default groups.");
        this.getShell().setSize(800, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        GridData contentData = new GridData(1808);
        content.setLayoutData((Object)contentData);
        Tree tree = new Tree(content, 67586);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ManageGroupsContentProvider());
        this.treeViewer.setComparator((ViewerComparator)new PaletteTreeViewerComparator());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
        this.treeViewer.getTree().addTreeListener((TreeListener)new PaletteViewTreeListener(this.treeViewer));
        GridData viewerGridData = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)viewerGridData);
        this.createColumns();
        this.treeViewer.setInput((Object)this.contentProvider.getRootNode());
        this.treeViewer.expandAll();
        this.treeViewer.refresh();
        Composite buttonComposite = new Composite(content, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        buttonComposite.setLayoutData((Object)new GridData(2));
        GridData gridDataButtons = new GridData();
        gridDataButtons.widthHint = 110;
        gridDataButtons.heightHint = 26;
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText("Add Group");
        addButton.addSelectionListener((SelectionListener)new AddButtonSelectionListener());
        addButton.setLayoutData((Object)gridDataButtons);
        this.addSubgroupButton = new Button(buttonComposite, 8);
        this.addSubgroupButton.setText("Add Subgroup");
        this.addSubgroupButton.addSelectionListener((SelectionListener)new AddSubgroupButtonSelectionListener());
        this.addSubgroupButton.setLayoutData((Object)gridDataButtons);
        this.addSubgroupButton.setEnabled(false);
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText("Edit Group");
        this.editButton.setLayoutData((Object)gridDataButtons);
        this.editButton.addSelectionListener((SelectionListener)new EditButtonSelectionListener());
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(buttonComposite, 8);
        this.deleteButton.setText("Delete Group");
        this.deleteButton.setLayoutData((Object)gridDataButtons);
        this.deleteButton.addSelectionListener((SelectionListener)new DeleteButtonSelectionListener());
        this.deleteButton.setEnabled(false);
        this.resetButton = new Button(buttonComposite, 8);
        this.resetButton.setText("Reset Component");
        this.resetButton.setLayoutData((Object)gridDataButtons);
        this.resetButton.addSelectionListener((SelectionListener)new ResetButtonSelectionListener());
        this.resetButton.setEnabled(false);
        this.setHelpAvailable(false);
        return container;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        if (id == 0) {
            return super.createButton(parent, id, "Close", defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    private void createColumns() {
        TreeViewerColumn column0 = this.createTreeViewerColumn(TITLES[0], 16384);
        TreeViewerColumn column1 = this.createTreeViewerColumn(TITLES[1], 0x1000000);
        TreeViewerColumn column2 = this.createTreeViewerColumn(TITLES[2], 0x1000000);
        column0.setLabelProvider((CellLabelProvider)new TableColumnLabelProvider(0));
        column1.setLabelProvider((CellLabelProvider)new TableColumnLabelProvider(1));
        column2.setLabelProvider((CellLabelProvider)new TableColumnLabelProvider(2));
        column0.getColumn().setWidth(445);
        column1.getColumn().setWidth(80);
        column2.getColumn().setWidth(120);
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int type) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, type);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(false);
        return viewerColumn;
    }

    protected void okPressed() {
        this.paletteView.setOrganizeGroupsDialog(null);
        super.okPressed();
    }

    private void setTreesVisible(boolean visible) {
        this.paletteView.getPaletteTreeViewer().getTree().setVisible(visible);
        this.treeViewer.getTree().setVisible(visible);
    }

    private void refreshTrees() {
        this.paletteView.getPaletteTreeViewer().refresh();
        this.treeViewer.refresh();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void refreshTree() {
        this.treeViewer.refresh();
    }

    private class AddButtonSelectionListener
    implements SelectionListener {
        private AddButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Shell shell = Display.getDefault().getActiveShell();
            AddCustomGroupDialog addDialog = new AddCustomGroupDialog(shell, ManageCustomGroupsDialog.this.contentProvider, ManageCustomGroupsDialog.this.contentProvider.getRootNode(), false);
            addDialog.open();
            if (addDialog.isGroupAdded()) {
                ManageCustomGroupsDialog.this.refreshTrees();
            }
            ManageCustomGroupsDialog.this.getButton(0).setFocus();
        }
    }

    private class AddSubgroupButtonSelectionListener
    implements SelectionListener {
        private AddSubgroupButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Shell shell = Display.getDefault().getActiveShell();
            PaletteTreeNode parent = (PaletteTreeNode)ManageCustomGroupsDialog.this.treeViewer.getTree().getSelection()[0].getData();
            AddCustomGroupDialog addDialog = new AddCustomGroupDialog(shell, ManageCustomGroupsDialog.this.contentProvider, parent, true);
            addDialog.open();
            if (addDialog.isGroupAdded()) {
                ManageCustomGroupsDialog.this.refreshTrees();
            }
            ManageCustomGroupsDialog.this.getButton(0).setFocus();
        }
    }

    private class DeleteButtonSelectionListener
    implements SelectionListener {
        private DeleteButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent evt) {
            TreeItem[] items = ManageCustomGroupsDialog.this.treeViewer.getTree().getSelection();
            ManageCustomGroupsDialog.this.setTreesVisible(false);
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof PaletteTreeNode) {
                    PaletteTreeNode node = (PaletteTreeNode)item.getData();
                    String logNodeName = StringUtils.format((String)"'%s'", (Object[])new Object[]{node.getQualifiedGroupName()});
                    if (node.hasChildren()) {
                        logNodeName = StringUtils.format((String)"%s and subgroup(s) (%s)", (Object[])new Object[]{logNodeName, String.join((CharSequence)", ", (CharSequence[])node.getAllSubGroups().stream().sorted().map(PaletteTreeNode::getQualifiedGroupName).toArray(String[]::new))});
                    }
                    ManageCustomGroupsDialog.this.contentProvider.deleteGroup(node);
                    ManageCustomGroupsDialog.this.log.debug((Object)StringUtils.format((String)"Deleted group %s.", (Object[])new Object[]{logNodeName}));
                }
                ++n2;
            }
            ManageCustomGroupsDialog.this.setTreesVisible(true);
            ManageCustomGroupsDialog.this.refreshTrees();
            ManageCustomGroupsDialog.this.getButton(0).setFocus();
        }
    }

    private class EditButtonSelectionListener
    implements SelectionListener {
        private EditButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            TreeItem item = ManageCustomGroupsDialog.this.treeViewer.getTree().getSelection()[0];
            if (item.getData() instanceof PaletteTreeNode) {
                PaletteTreeNode node = (PaletteTreeNode)item.getData();
                Shell shell = Display.getDefault().getActiveShell();
                EditCustomGroupDialog editDialog = new EditCustomGroupDialog(shell, node, ManageCustomGroupsDialog.this.contentProvider.getAssignment());
                editDialog.open();
                if (editDialog.isGroupUpdated()) {
                    ManageCustomGroupsDialog.this.refreshTrees();
                }
            }
            ManageCustomGroupsDialog.this.getButton(0).setFocus();
        }
    }

    private class ResetButtonSelectionListener
    implements SelectionListener {
        private ResetButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            ComponentNode[] nodes;
            TreeItem[] items = ManageCustomGroupsDialog.this.treeViewer.getTree().getSelection();
            if (items.length == 0) {
                return;
            }
            Object[] expandedElements = ManageCustomGroupsDialog.this.treeViewer.getExpandedElements();
            ComponentNode[] componentNodeArray = nodes = (ComponentNode[])Arrays.stream(items).map(Widget::getData).filter(ComponentNode.class::isInstance).toArray(ComponentNode[]::new);
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentNode nodeToReset = componentNodeArray[n2];
                ManageCustomGroupsDialog.this.setTreesVisible(false);
                Object[] expandedElements1 = ManageCustomGroupsDialog.this.paletteView.getPaletteTreeViewer().getExpandedElements();
                ManageCustomGroupsDialog.this.contentProvider.resetGroup(nodeToReset);
                ManageCustomGroupsDialog.this.paletteView.getPaletteTreeViewer().refresh();
                ManageCustomGroupsDialog.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements1);
                ManageCustomGroupsDialog.this.paletteView.expandToNode(nodeToReset);
                ManageCustomGroupsDialog.this.setTreesVisible(true);
                ++n2;
            }
            ManageCustomGroupsDialog.this.refreshTrees();
            ManageCustomGroupsDialog.this.treeViewer.setExpandedElements(expandedElements);
            ManageCustomGroupsDialog.this.resetButton.setEnabled(false);
            ManageCustomGroupsDialog.this.getButton(0).setFocus();
            Object[] objectArray = new Object[1];
            objectArray[0] = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(nodes).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).sorted().map(node -> StringUtils.format((String)"%s (%s)", (Object[])new Object[]{node.getDisplayName(), node.getToolIdentification().getToolID()})).toArray(String[]::new));
            ManageCustomGroupsDialog.this.log.debug((Object)StringUtils.format((String)"Group assignment of component(s) '%s' reset to default group(s).", (Object[])objectArray));
        }
    }

    private class TableColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        TableColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        private Image getDefaultImage() {
            return ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
        }

        public Image getImage(Object element) {
            if (this.columnIndex == 0 && element instanceof PaletteTreeNode) {
                PaletteTreeNode node = (PaletteTreeNode)element;
                if (node.isOfflineComponent()) {
                    String componentID = node.getOfflineComponentNode().getToolIdentification().getToolID();
                    ComponentImageManagerImpl.ImagePackage imagePackage = ManageCustomGroupsDialog.this.componentImageManager.getImagePackage(componentID);
                    return imagePackage.getIcon16(componentID);
                }
                if (node.isGroup()) {
                    return node.getGroupNode().getIcon(ManageCustomGroupsDialog.this.treeViewer.getExpandedState((Object)node) && node.hasChildren());
                }
                return node.getIcon().orElseGet(this::getDefaultImage);
            }
            return super.getImage(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof OfflineComponentNode) {
                return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_DOVE_GRAY);
            }
            return super.getForeground(element);
        }

        public String getText(Object element) {
            if (element instanceof PaletteTreeNode) {
                PaletteTreeNode node = (PaletteTreeNode)element;
                if (this.columnIndex == 0) {
                    return node.getDisplayName();
                }
                if (node instanceof ComponentNode) {
                    ComponentNode componentNode = (ComponentNode)node;
                    if (this.columnIndex == 1) {
                        if (componentNode.isLocal()) {
                            return "local";
                        }
                        return "remote";
                    }
                    if (this.columnIndex == 2) {
                        return Boolean.toString(ManageCustomGroupsDialog.this.contentProvider.toolIsPresent(componentNode.getNodeName()));
                    }
                }
            }
            return "";
        }
    }

    private class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent arg0) {
            TreeItem[] items = ManageCustomGroupsDialog.this.treeViewer.getTree().getSelection();
            if (items.length == 0) {
                ManageCustomGroupsDialog.this.addSubgroupButton.setEnabled(false);
                ManageCustomGroupsDialog.this.resetButton.setEnabled(false);
                ManageCustomGroupsDialog.this.editButton.setEnabled(false);
                ManageCustomGroupsDialog.this.deleteButton.setEnabled(false);
                return;
            }
            Object data = items[0].getData();
            boolean disableButtons = false;
            if (!(data instanceof PaletteTreeNode)) {
                return;
            }
            PaletteTreeNode node0 = (PaletteTreeNode)data;
            if (node0.isAccessibleComponent()) {
                disableButtons = Stream.of(items).anyMatch(item -> !((PaletteTreeNode)item.getData()).isAccessibleComponent());
            } else if (node0.isGroup()) {
                disableButtons = Stream.of(items).anyMatch(item -> !((PaletteTreeNode)item.getData()).isGroup());
            }
            if (!disableButtons) {
                ManageCustomGroupsDialog.this.resetButton.setEnabled(node0 instanceof ComponentNode);
                ManageCustomGroupsDialog.this.editButton.setEnabled(items.length == 1 && node0.isGroup() && node0.getGroupNode().isCustomGroup());
                ManageCustomGroupsDialog.this.addSubgroupButton.setEnabled(node0.isGroup() && items.length == 1);
                ManageCustomGroupsDialog.this.deleteButton.setEnabled(node0.isGroup() && node0.getGroupNode().isCustomGroup() && !ManageCustomGroupsDialog.this.contentProvider.containsAnyToolNodes(node0, false));
                if (data instanceof PaletteTreeNode) {
                    PaletteTreeNode node = (PaletteTreeNode)data;
                    if (Stream.of(PaletteViewConstants.RCE_GROUPS).collect(Collectors.toList()).contains(node.getNodeName()) || ToolType.getTopLevelGroupNames().contains(node.getNodeName())) {
                        ManageCustomGroupsDialog.this.editButton.setEnabled(false);
                    }
                }
            } else {
                ManageCustomGroupsDialog.this.addSubgroupButton.setEnabled(false);
                ManageCustomGroupsDialog.this.resetButton.setEnabled(false);
                ManageCustomGroupsDialog.this.editButton.setEnabled(false);
                ManageCustomGroupsDialog.this.deleteButton.setEnabled(false);
            }
        }
    }
}

