/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.api.Deprecated;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class VampZeroInitializerComponent
extends DefaultComponent {
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private String vampZeroInputs;
    private XmlComponentHistoryDataItem historyDataItem = null;
    private EndpointXMLService endpointXmlUtils;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.endpointXmlUtils = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
        this.vampZeroInputs = this.componentContext.getConfigurationValue("xmlContent");
        if (this.vampZeroInputs == null || this.vampZeroInputs.isEmpty()) {
            throw new ComponentException("No initial CPACS for VAMPzero given. Did you forget to click the 'Create CPACS' button?");
        }
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public void processInputs() throws ComponentException {
        FileReferenceTD fileReference;
        File tempFile;
        this.initializeNewHistoryDataItem();
        try {
            tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("VAMPZeroInitializer-*.xml");
            FileUtils.writeStringToFile((File)tempFile, (String)this.vampZeroInputs);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to write initial CPACS into a temporary file (that is required for VAMPzero Initializer)", (Throwable)e);
        }
        HashMap<String, TypedDatum> variableInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            variableInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        if (this.historyDataItem != null && !variableInputs.isEmpty()) {
            try {
                String plainVampZeroInputsFileRef = this.dataManagementService.createTaggedReferenceFromLocalFile(this.componentContext, tempFile, "cpacs.xml");
                this.historyDataItem.setPlainXMLFileReference(plainVampZeroInputsFileRef);
                this.storeHistoryDataItem();
            }
            catch (IOException e) {
                String errorMessage = "Failed to store plain, initial CPACS file into the data management; it will not be available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LogFactory.getLog(VampZeroInitializerComponent.class), (String)errorMessage, (Throwable)e);
                this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        try {
            this.endpointXmlUtils.updateXMLWithInputs(tempFile, variableInputs, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to add dynamic input values to the initial CPACS", (Throwable)e);
        }
        try {
            fileReference = this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, tempFile, "cpacs.xml");
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store initial CPACS file in the data management - if it is not stored in the data management, it can not be sent as output value", (Throwable)e);
        }
        this.componentContext.writeOutput("CPACS", (TypedDatum)fileReference);
        try {
            this.endpointXmlUtils.updateOutputsFromXML(tempFile, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to extract dynamic output values from the initial CPACS", (Throwable)e);
        }
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.storeHistoryDataItem();
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new XmlComponentHistoryDataItem("de.rcenvironment.vampzeroinitializer");
        }
    }

    private void storeHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }
}

