/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.BenchmarkSetup;
import de.rcenvironment.core.communication.management.RemoteBenchmarkService;
import de.rcenvironment.core.communication.management.internal.BenchmarkSubtaskImpl;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BenchmarkProcess
implements Runnable {
    private final Log log = LogFactory.getLog(this.getClass());
    private List<BenchmarkSubtaskImpl> subtasks = new ArrayList<BenchmarkSubtaskImpl>();
    private TextOutputReceiver outputReceiver;
    private CommunicationService communicationService;

    public BenchmarkProcess(BenchmarkSetup setup, TextOutputReceiver outputReceiver, CommunicationService communicationService) {
        this.subtasks.addAll(setup.getSubtasks());
        this.communicationService = communicationService;
        this.outputReceiver = outputReceiver;
    }

    public String getCategoryName() {
        return "Communication Layer: benchmark main task";
    }

    @Override
    public void run() {
        this.outputReceiver.onStart();
        this.printOutput("Starting " + this.subtasks.size() + " benchmark task(s)");
        int index = 1;
        for (BenchmarkSubtaskImpl subtask : this.subtasks) {
            this.printOutput("  Task " + index++ + ": " + subtask.formatDescription());
            subtask.recordStartTime();
            for (InstanceNodeSessionId nodeId : subtask.getTargetNodes()) {
                AtomicInteger messageCounter = new AtomicInteger(subtask.getNumMessages());
                int senderIndex = 0;
                while (senderIndex < subtask.getThreadsPerTarget()) {
                    SenderTask sender = new SenderTask(subtask, nodeId, messageCounter);
                    ConcurrencyUtils.getAsyncTaskService().execute("Communication Layer: benchmark sender task", (Runnable)sender);
                    ++senderIndex;
                }
            }
        }
        this.printOutput("Awaiting benchmark results...");
        for (BenchmarkSubtaskImpl subtask : this.subtasks) {
            try {
                subtask.awaitTermination();
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"Benchmark subtask interrupted", (Throwable)e);
                this.outputReceiver.onFatalError((Exception)e);
            }
        }
        this.printOutput("Benchmark results:");
        index = 1;
        for (BenchmarkSubtaskImpl subtask : this.subtasks) {
            this.printOutput("  Task " + index++ + ": " + subtask.formatDescription());
            String[] stringArray = subtask.formatResults();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.printOutput("    " + line);
                ++n2;
            }
        }
        this.outputReceiver.onFinished();
    }

    private void printOutput(String line) {
        this.outputReceiver.addOutput(line);
    }

    private final class SenderTask
    implements Runnable {
        private InstanceNodeSessionId targetNode;
        private AtomicInteger messageCounter;
        private BenchmarkSubtaskImpl subtask;
        private RemoteBenchmarkService remoteService;

        SenderTask(BenchmarkSubtaskImpl subtask, InstanceNodeSessionId nodeId, AtomicInteger messageCounter) {
            this.targetNode = nodeId;
            this.messageCounter = messageCounter;
            this.subtask = subtask;
            this.remoteService = BenchmarkProcess.this.communicationService.getRemotableService(RemoteBenchmarkService.class, this.targetNode);
        }

        @Override
        @TaskDescription(value="Communication Layer: benchmark sender task")
        public void run() {
            while (this.messageCounter.decrementAndGet() >= 0) {
                long startTime = System.nanoTime();
                RemoteOperationException error = null;
                try {
                    this.performRequest();
                }
                catch (RemoteOperationException e) {
                    error = e;
                }
                long duration = System.nanoTime() - startTime;
                this.subtask.recordSingleResult(this.targetNode, duration, error);
            }
        }

        private void performRequest() throws RemoteOperationException {
            Serializable response = this.remoteService.respond((Serializable)new byte[this.subtask.getRequestSize()], this.subtask.getResponseSize(), this.subtask.getResponseDelay());
            byte[] responseBytes = (byte[])response;
            if (responseBytes == null || responseBytes.length != this.subtask.getResponseSize()) {
                throw new IllegalStateException("Unexpected benchmark response payload");
            }
        }
    }
}

