/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.update.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class PersistentWorkflowDescription
implements Serializable {
    private static final long serialVersionUID = -5664277831346681518L;
    private static final String WORKFLOW_VERSION = "workflowVersion";
    private String workflowVersion = "";
    private List<PersistentComponentDescription> componentDescriptions;
    private String workflowDescriptionString;

    public PersistentWorkflowDescription(List<PersistentComponentDescription> componentDescriptions, String workflowDescriptionString) throws JsonParseException, IOException {
        this.componentDescriptions = componentDescriptions;
        this.workflowDescriptionString = workflowDescriptionString;
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonParser jsonParser = new JsonFactory().createJsonParser(workflowDescriptionString);){
            JsonNode node = (JsonNode)JsonUtils.getDefaultObjectMapper().readTree(jsonParser);
            if (node.get(WORKFLOW_VERSION) != null) {
                this.workflowVersion = node.get(WORKFLOW_VERSION).textValue();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getWorkflowVersion() {
        return this.workflowVersion;
    }

    public List<PersistentComponentDescription> getComponentDescriptions() {
        return this.componentDescriptions;
    }

    public String getWorkflowDescriptionAsString() {
        return this.workflowDescriptionString;
    }

    public String toString() {
        return this.getWorkflowDescriptionAsString();
    }
}

